/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.network;

import com.android.ddmlib.Client;
import com.android.tools.idea.actions.BrowserHelpAction;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.monitor.BaseMonitorView;
import com.android.tools.idea.monitor.actions.RecordingAction;
import com.android.tools.idea.monitor.network.NetworkSampler;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.Color;
import java.util.concurrent.Future;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NetworkMonitorView
extends BaseMonitorView<NetworkSampler>
implements DeviceContext.DeviceSelectionListener {
    private static final int SAMPLE_FREQUENCY_MS = 500;
    private static final float TIMELINE_BUFFER_TIME = 0.75f;
    private static final float TIMELINE_INITIAL_MAX = 5.0f;
    private static final float TIMELINE_ABSOLUTE_MAX = Float.MAX_VALUE;
    private static final float TIMELINE_INITIAL_MARKER_SEPARATION = 1.0f;
    private static final Color BACKGROUND_COLOR = UIUtil.getTextFieldBackground();
    private static final String MISSING_LABEL = "Network monitoring is not available on your device.";
    private static final String STARTING_LABEL = "Starting... If this doesn't finish within seconds, the device may not be properly connected. Please reconnect.";
    private Future<?> checkStatsFileFuture;

    public NetworkMonitorView(@NotNull Project project, @NotNull DeviceContext deviceContext) {
        if (project == null) {
            NetworkMonitorView.$$$reportNull$$$0(0);
        }
        if (deviceContext == null) {
            NetworkMonitorView.$$$reportNull$$$0(1);
        }
        super(project, deviceContext, new NetworkSampler(500), 0.75f, 5.0f, Float.MAX_VALUE, 1.0f);
        this.myTimelineComponent.configureUnits("KB/s");
        this.myTimelineComponent.configureStream(0, "Rx", (Color)new JBColor(0xFF8000, 0xFF8000));
        this.myTimelineComponent.configureStream(1, "Tx", (Color)new JBColor(0xFFCC99, 0xFFCC99), true);
        this.myTimelineComponent.setBackground(BACKGROUND_COLOR);
        this.addOverlayText(MISSING_LABEL, 4);
        this.addOverlayText(STARTING_LABEL, 6);
        this.setViewComponent((JComponent)this.myTimelineComponent);
        deviceContext.addListener(this, (Disposable)project);
    }

    @Override
    @NotNull
    public ActionGroup getToolbarActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new RecordingAction(this));
        group.add((AnAction)new Separator());
        group.add((AnAction)new BrowserHelpAction("Network monitor", "http://developer.android.com/r/studio-ui/am-network.html"));
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            NetworkMonitorView.$$$reportNull$$$0(2);
        }
        return defaultActionGroup;
    }

    @Override
    public void clientSelected(final @Nullable Client c) {
        ((NetworkSampler)this.mySampler).setClient(c);
        if (this.checkStatsFileFuture != null) {
            if (!this.checkStatsFileFuture.isDone()) {
                this.checkStatsFileFuture.cancel(true);
            }
            this.checkStatsFileFuture = null;
        }
        this.setOverlayEnabled(STARTING_LABEL, c != null);
        this.setOverlayEnabled(MISSING_LABEL, false);
        if (c != null) {
            this.checkStatsFileFuture = ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    final int networkStatsFileState = ((NetworkSampler)NetworkMonitorView.this.mySampler).checkStatsFile(c);
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (c == NetworkMonitorView.this.myDeviceContext.getSelectedClient()) {
                                NetworkMonitorView.this.setOverlayEnabled(NetworkMonitorView.STARTING_LABEL, networkStatsFileState == 0);
                                NetworkMonitorView.this.setOverlayEnabled(NetworkMonitorView.MISSING_LABEL, networkStatsFileState < 0);
                            }
                        }
                    });
                }
            });
        }
    }

    @Override
    @NotNull
    public String getTitleName() {
        if ("Network" == null) {
            NetworkMonitorView.$$$reportNull$$$0(3);
        }
        return "Network";
    }

    @Override
    @NotNull
    public Icon getTitleIcon() {
        Icon icon = AndroidIcons.NetworkMonitor;
        if (icon == null) {
            NetworkMonitorView.$$$reportNull$$$0(4);
        }
        return icon;
    }

    @Override
    protected int getDefaultPosition() {
        return 2;
    }

    @Override
    @NotNull
    public String getMonitorName() {
        if ("NetworkMonitor" == null) {
            NetworkMonitorView.$$$reportNull$$$0(5);
        }
        return "NetworkMonitor";
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("network data usage" == null) {
            NetworkMonitorView.$$$reportNull$$$0(6);
        }
        return "network data usage";
    }

    @Override
    public AndroidStudioEvent.MonitorType getMonitorType() {
        return AndroidStudioEvent.MonitorType.NETWORK;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceContext";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/monitor/network/NetworkMonitorView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/monitor/network/NetworkMonitorView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitleName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitleIcon";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMonitorName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

