/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.memory;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.tools.adtui.TimelineData;
import com.android.tools.idea.monitor.DeviceSampler;
import org.jetbrains.annotations.NotNull;

public class MemorySampler
extends DeviceSampler
implements AndroidDebugBridge.IClientChangeListener {
    public static final int SAMPLES = 2048;
    private boolean myRequestPending;

    MemorySampler(int sampleFrequencyMs) {
        super(new TimelineData(2, 2048), sampleFrequencyMs);
    }

    @Override
    public void start() {
        if (!this.isRunning() && this.getClient() != null) {
            AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
        }
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
        this.myRequestPending = false;
        AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
    }

    @Override
    @NotNull
    public String getName() {
        if ("Memory Sampler" == null) {
            MemorySampler.$$$reportNull$$$0(0);
        }
        return "Memory Sampler";
    }

    protected void recordSample(int type) {
        float freeMb = 0.0f;
        float allocMb = 0.0f;
        Client client = this.getClient();
        if (client != null) {
            ClientData.HeapInfo m = client.getClientData().getVmHeapInfo(1);
            if (m != null) {
                allocMb = (float)m.bytesAllocated / 1048576.0f;
                freeMb = (float)m.sizeInBytes / 1048576.0f - allocMb;
            }
        } else {
            type = 0;
        }
        this.getTimelineData().add(System.currentTimeMillis(), type, new float[]{allocMb, freeMb});
    }

    protected void requestSample() {
        Client client = this.getClient();
        if (client != null) {
            client.updateHeapInfo();
        }
    }

    @Override
    protected void sample(boolean forced) throws InterruptedException {
        if (forced) {
            this.myRequestPending = false;
            this.recordSample(1);
        } else {
            if (this.myRequestPending) {
                this.recordSample(2);
            }
            this.requestSample();
            this.myRequestPending = true;
        }
    }

    public void clientChanged(@NotNull Client client, int changeMask) {
        Client localClient;
        if (client == null) {
            MemorySampler.$$$reportNull$$$0(1);
        }
        if ((localClient = this.getClient()) != null && localClient == client && (changeMask & 0x40) != 0) {
            this.forceSample();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/monitor/memory/MemorySampler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/monitor/memory/MemorySampler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "clientChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

