/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellEnabledDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.logcat.LogCatHeader;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.ddmlib.logcat.LogCatTimestamp;
import com.android.tools.idea.logcat.AndroidLogcatReceiver;
import com.android.tools.idea.run.LoggingReceiver;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.intellij.execution.impl.ConsoleBuffer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidOutputReceiver;
import org.jetbrains.annotations.NotNull;

@ThreadSafe
public final class AndroidLogcatService
implements AndroidDebugBridge.IDeviceChangeListener,
Disposable {
    private final Object myLock = new Object();
    @GuardedBy(value="myLock")
    private final Map<IDevice, List<LogcatListener>> myListeners = new HashMap<IDevice, List<LogcatListener>>();
    @GuardedBy(value="myLock")
    private final Map<IDevice, LogcatBuffer> myLogBuffers = new HashMap<IDevice, LogcatBuffer>();
    @GuardedBy(value="myLock")
    private final Map<IDevice, AndroidLogcatReceiver> myLogReceivers = new HashMap<IDevice, AndroidLogcatReceiver>();
    @GuardedBy(value="myLock")
    private final Map<IDevice, ExecutorService> myExecutors = new HashMap<IDevice, ExecutorService>();

    private static Logger getLog() {
        return Logger.getInstance(AndroidLogcatService.class);
    }

    @NotNull
    public static AndroidLogcatService getInstance() {
        AndroidLogcatService androidLogcatService = (AndroidLogcatService)ServiceManager.getService(AndroidLogcatService.class);
        if (androidLogcatService == null) {
            AndroidLogcatService.$$$reportNull$$$0(0);
        }
        return androidLogcatService;
    }

    AndroidLogcatService() {
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startReceiving(@NotNull IDevice device) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(1);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myLogReceivers.containsKey(device)) {
                return;
            }
            this.connect(device);
            AndroidLogcatReceiver receiver = this.createReceiver(device);
            this.myLogReceivers.put(device, receiver);
            this.myLogBuffers.put(device, new LogcatBuffer());
            this.myExecutors.get(device).submit(() -> {
                if (device == null) {
                    AndroidLogcatService.$$$reportNull$$$0(28);
                }
                AndroidLogcatService.executeLogcatWithLongOutputFormat((IShellEnabledDevice)device, receiver);
            });
        }
    }

    private static void executeLogcatWithLongOutputFormat(@NotNull IShellEnabledDevice device, @NotNull AndroidLogcatReceiver receiver) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(2);
        }
        if (receiver == null) {
            AndroidLogcatService.$$$reportNull$$$0(3);
        }
        try {
            AndroidLogcatService.execute(device, "logcat -v long", receiver, Duration.ZERO);
        }
        catch (Exception exception) {
            String message = "Caught an exception when capturing logcat output from the device " + device.getName() + ". Receiving output from the device will be stopped and the listeners will be notified with the exception message as the last message.";
            AndroidLogcatService.getLog().info(message, (Throwable)exception);
            receiver.notifyLine(new LogCatHeader(Log.LogLevel.ERROR, 0, 0, "?", "Internal", LogCatTimestamp.ZERO), exception.getMessage());
        }
    }

    @NotNull
    private AndroidLogcatReceiver createReceiver(final @NotNull IDevice device) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(4);
        }
        LogcatListener logcatListener = new LogcatListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLogLineReceived(@NotNull LogCatMessage line) {
                if (line == null) {
                    1.$$$reportNull$$$0(0);
                }
                Object object = AndroidLogcatService.this.myLock;
                synchronized (object) {
                    if (AndroidLogcatService.this.myListeners.containsKey(device)) {
                        for (LogcatListener listener : (List)AndroidLogcatService.this.myListeners.get(device)) {
                            listener.onLogLineReceived(line);
                        }
                    }
                    if (AndroidLogcatService.this.myLogBuffers.containsKey(device)) {
                        ((LogcatBuffer)AndroidLogcatService.this.myLogBuffers.get(device)).addMessage(line);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/logcat/AndroidLogcatService$1", "onLogLineReceived"));
            }
        };
        AndroidLogcatReceiver androidLogcatReceiver = new AndroidLogcatReceiver(device, logcatListener);
        if (androidLogcatReceiver == null) {
            AndroidLogcatService.$$$reportNull$$$0(5);
        }
        return androidLogcatReceiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(@NotNull IDevice device) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(6);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myExecutors.containsKey(device)) {
                ThreadFactory factory = new ThreadFactoryBuilder().setNameFormat("logcat-" + device.getName()).build();
                this.myExecutors.put(device, Executors.newSingleThreadExecutor(factory));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect(@NotNull IDevice device) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(7);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.stopReceiving(device);
            this.myExecutors.remove(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopReceiving(@NotNull IDevice device) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(8);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myLogReceivers.containsKey(device)) {
                this.myLogReceivers.get(device).cancel();
                this.myLogReceivers.remove(device);
                this.myLogBuffers.remove(device);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLogcat(@NotNull IDevice device, @NotNull Project project) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(9);
        }
        if (project == null) {
            AndroidLogcatService.$$$reportNull$$$0(10);
        }
        Object object = this.myLock;
        synchronized (object) {
            ExecutorService executor = this.myExecutors.get(device);
            if (executor == null) {
                this.notifyThatLogcatWasCleared(device);
                return;
            }
            this.stopReceiving(device);
            executor.submit(() -> {
                if (device == null) {
                    AndroidLogcatService.$$$reportNull$$$0(25);
                }
                if (project == null) {
                    AndroidLogcatService.$$$reportNull$$$0(26);
                }
                try {
                    AndroidLogcatService.execute((IShellEnabledDevice)device, "logcat -c", new LoggingReceiver(AndroidLogcatService.getLog()), Duration.ofSeconds(5L));
                }
                catch (Exception e) {
                    AndroidLogcatService.getLog().info((Throwable)e);
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (project == null) {
                            AndroidLogcatService.$$$reportNull$$$0(27);
                        }
                        Messages.showErrorDialog((Project)project, (String)("Error: " + e.getMessage()), (String)AndroidBundle.message("android.logcat.error.dialog.title", new Object[0]));
                    });
                }
                this.notifyThatLogcatWasCleared(device);
            });
            this.startReceiving(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyThatLogcatWasCleared(@NotNull IDevice device) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(11);
        }
        Object object = this.myLock;
        synchronized (object) {
            Iterable listeners = this.myListeners.get(device);
            if (listeners == null) {
                return;
            }
            listeners.forEach(LogcatListener::onCleared);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(@NotNull IDevice device, @NotNull LogcatListener listener, boolean addOldLogs) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(12);
        }
        if (listener == null) {
            AndroidLogcatService.$$$reportNull$$$0(13);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (addOldLogs && this.myLogBuffers.containsKey(device)) {
                for (LogCatMessage line : this.myLogBuffers.get(device).getMessages()) {
                    listener.onLogLineReceived(line);
                }
            }
            if (!this.myListeners.containsKey(device)) {
                this.myListeners.put(device, new ArrayList());
            }
            this.myListeners.get(device).add(listener);
            if (device.isOnline()) {
                this.startReceiving(device);
            }
        }
    }

    public void addListener(@NotNull IDevice device, @NotNull LogcatListener listener) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(14);
        }
        if (listener == null) {
            AndroidLogcatService.$$$reportNull$$$0(15);
        }
        this.addListener(device, listener, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(@NotNull IDevice device, @NotNull LogcatListener listener) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(16);
        }
        if (listener == null) {
            AndroidLogcatService.$$$reportNull$$$0(17);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myListeners.containsKey(device)) {
                this.myListeners.get(device).remove(listener);
                if (this.myListeners.get(device).isEmpty()) {
                    this.stopReceiving(device);
                }
            }
        }
    }

    public void deviceConnected(@NotNull IDevice device) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(18);
        }
        if (device.isOnline()) {
            this.startReceiving(device);
        }
    }

    public void deviceDisconnected(@NotNull IDevice device) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(19);
        }
        this.disconnect(device);
    }

    public void deviceChanged(@NotNull IDevice device, int changeMask) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(20);
        }
        if (device.isOnline()) {
            this.startReceiving(device);
        } else {
            this.disconnect(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        Object object = this.myLock;
        synchronized (object) {
            for (AndroidLogcatReceiver receiver : this.myLogReceivers.values()) {
                receiver.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Disposer.dispose((Disposable)this);
        Object object = this.myLock;
        synchronized (object) {
            this.myExecutors.values().forEach(executor -> {
                try {
                    executor.shutdownNow();
                    executor.awaitTermination(5000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    AndroidLogcatService.getLog().info("Error shutting down executor", (Throwable)e);
                }
            });
        }
    }

    private static void execute(@NotNull IShellEnabledDevice device, @NotNull String command, @NotNull AndroidOutputReceiver receiver, @NotNull Duration duration) throws Exception {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(21);
        }
        if (command == null) {
            AndroidLogcatService.$$$reportNull$$$0(22);
        }
        if (receiver == null) {
            AndroidLogcatService.$$$reportNull$$$0(23);
        }
        if (duration == null) {
            AndroidLogcatService.$$$reportNull$$$0(24);
        }
        device.executeShellCommand(command, (IShellOutputReceiver)receiver, duration.toMillis(), TimeUnit.MILLISECONDS);
        if (receiver.isCancelled()) {
            return;
        }
        receiver.invalidate();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/logcat/AndroidLogcatService";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 3: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 10: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/logcat/AndroidLogcatService";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createReceiver";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "startReceiving";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "executeLogcatWithLongOutputFormat";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createReceiver";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "connect";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "disconnect";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "stopReceiving";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "clearLogcat";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "notifyThatLogcatWasCleared";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "deviceConnected";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "deviceDisconnected";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "deviceChanged";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$clearLogcat$2";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$startReceiving$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface LogcatListener {
        default public void onLogLineReceived(@NotNull LogCatMessage line) {
            if (line == null) {
                LogcatListener.$$$reportNull$$$0(0);
            }
        }

        default public void onCleared() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/logcat/AndroidLogcatService$LogcatListener", "onLogLineReceived"));
        }
    }

    private static class LogcatBuffer {
        private int myBufferSize;
        private final LinkedList<LogCatMessage> myMessages = new LinkedList();

        private LogcatBuffer() {
        }

        public void addMessage(@NotNull LogCatMessage message) {
            if (message == null) {
                LogcatBuffer.$$$reportNull$$$0(0);
            }
            this.myMessages.add(message);
            this.myBufferSize += message.getMessage().length();
            if (ConsoleBuffer.useCycleBuffer()) {
                while (this.myBufferSize > ConsoleBuffer.getCycleBufferSize()) {
                    this.myBufferSize -= this.myMessages.removeFirst().getMessage().length();
                }
            }
        }

        @NotNull
        public List<LogCatMessage> getMessages() {
            LinkedList<LogCatMessage> linkedList = this.myMessages;
            if (linkedList == null) {
                LogcatBuffer.$$$reportNull$$$0(1);
            }
            return linkedList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/logcat/AndroidLogcatService$LogcatBuffer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/logcat/AndroidLogcatService$LogcatBuffer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessages";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addMessage";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

