/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.actions.BrowserHelpAction;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.actions.ScreenRecorderAction;
import com.android.tools.idea.ddms.actions.ScreenshotAction;
import com.android.tools.idea.ddms.actions.TerminateVMAction;
import com.android.tools.idea.logcat.AndroidLogFilterModel;
import com.android.tools.idea.logcat.AndroidLogcatFormatter;
import com.android.tools.idea.logcat.AndroidLogcatPreferences;
import com.android.tools.idea.logcat.AndroidLogcatService;
import com.android.tools.idea.logcat.AndroidLogcatView;
import com.android.tools.idea.logcat.RegexFilterComponent;
import com.intellij.diagnostic.logging.LogConsoleBase;
import com.intellij.diagnostic.logging.LogFilterModel;
import com.intellij.diagnostic.logging.LogFormatter;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class AndroidLogConsole
extends LogConsoleBase {
    private final AndroidLogcatView myView;
    private final RegexFilterComponent myRegexFilterComponent;
    private final AndroidLogcatPreferences myPreferences;

    AndroidLogConsole(@NotNull AndroidLogcatView view, @NotNull Project project, @NotNull AndroidLogFilterModel model) {
        if (view == null) {
            AndroidLogConsole.$$$reportNull$$$0(0);
        }
        if (project == null) {
            AndroidLogConsole.$$$reportNull$$$0(1);
        }
        if (model == null) {
            AndroidLogConsole.$$$reportNull$$$0(2);
        }
        super(project, null, "", false, (LogFilterModel)model, GlobalSearchScope.allScope((Project)project), AndroidLogConsole.newLogFormatter(project));
        this.myRegexFilterComponent = new RegexFilterComponent("LOG_FILTER_HISTORY", 5);
        ConsoleView console = this.getConsole();
        if (console instanceof ConsoleViewImpl) {
            ConsoleViewImpl c = (ConsoleViewImpl)console;
            c.addCustomConsoleAction((AnAction)new Separator());
            c.addCustomConsoleAction((AnAction)new AndroidLogcatView.MyRestartAction(view));
            c.addCustomConsoleAction((AnAction)new AndroidLogcatView.MyConfigureLogcatHeaderAction(view));
            DeviceContext context = view.getDeviceContext();
            c.addCustomConsoleAction((AnAction)new Separator());
            c.addCustomConsoleAction((AnAction)new ScreenshotAction(project, context));
            c.addCustomConsoleAction((AnAction)new ScreenRecorderAction(project, context));
            c.addCustomConsoleAction((AnAction)new Separator());
            c.addCustomConsoleAction((AnAction)new TerminateVMAction(context));
            c.addCustomConsoleAction((AnAction)new Separator());
            c.addCustomConsoleAction((AnAction)new BrowserHelpAction("logcat", "http://developer.android.com/r/studio-ui/am-logcat.html"));
        }
        this.myView = view;
        this.myPreferences = AndroidLogcatPreferences.getInstance(project);
        this.myRegexFilterComponent.setFilter(this.myPreferences.TOOL_WINDOW_CUSTOM_FILTER);
        this.myRegexFilterComponent.setIsRegex(this.myPreferences.TOOL_WINDOW_REGEXP_FILTER);
        this.myRegexFilterComponent.addRegexListener(filter -> {
            if (model == null) {
                AndroidLogConsole.$$$reportNull$$$0(8);
            }
            this.myPreferences.TOOL_WINDOW_CUSTOM_FILTER = filter.getFilter();
            this.myPreferences.TOOL_WINDOW_REGEXP_FILTER = filter.isRegex();
            model.updateCustomPattern(filter.getPattern());
        });
    }

    @NotNull
    private static LogFormatter newLogFormatter(@NotNull Project project) {
        if (project == null) {
            AndroidLogConsole.$$$reportNull$$$0(3);
        }
        AndroidLogcatFormatter androidLogcatFormatter = new AndroidLogcatFormatter(AndroidLogcatPreferences.getInstance(project));
        if (androidLogcatFormatter == null) {
            AndroidLogConsole.$$$reportNull$$$0(4);
        }
        return androidLogcatFormatter;
    }

    public boolean isActive() {
        return this.myView.isActive();
    }

    public void clearLogcat() {
        IDevice device = this.myView.getSelectedDevice();
        if (device == null) {
            return;
        }
        AndroidLogcatService.getInstance().clearLogcat(device, this.myView.getProject());
    }

    @NotNull
    public Component getLogFilterComboBox() {
        JComponent component2 = this.getSearchComponent();
        assert (component2 != null);
        Component component3 = component2.getComponent(0);
        if (component3 == null) {
            AndroidLogConsole.$$$reportNull$$$0(5);
        }
        return component3;
    }

    @NotNull
    public Component getTextFilterComponent() {
        RegexFilterComponent regexFilterComponent = this.myRegexFilterComponent;
        if (regexFilterComponent == null) {
            AndroidLogConsole.$$$reportNull$$$0(6);
        }
        return regexFilterComponent;
    }

    public void addLogLine(@NotNull String line) {
        if (line == null) {
            AndroidLogConsole.$$$reportNull$$$0(7);
        }
        super.addMessage(line);
    }

    public void refresh() {
        this.onTextFilterChange();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/logcat/AndroidLogConsole";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/logcat/AndroidLogConsole";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "newLogFormatter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogFilterComboBox";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextFilterComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "newLogFormatter";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addLogLine";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

