/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParcelableQuickFix
implements AndroidLintQuickFix {
    private static final String CREATOR = "public static final android.os.Parcelable.Creator<%1$s> CREATOR = new android.os.Parcelable.Creator<%1$s>() {\n  @Override\n  public %1$s createFromParcel(android.os.Parcel in) {\n    return new %1$s(in);\n  }\n\n  @Override\n  public %1$s[] newArray(int size) {\n    return new %1$s[size];\n  }\n};\n";
    private static final String CONSTRUCTOR = "protected %1$s(android.os.Parcel in) {\n}\n";
    private static final String CONSTRUCTOR_WITH_SUPER = "protected %1$s(android.os.Parcel in) {\n  super(in);\n}\n";
    private static final String DESCRIBE_CONTENTS = "@Override\npublic int describeContents() {\n  return 0;\n}\n";
    private static final String WRITE_TO_PARCEL = "@Override\npublic void writeToParcel(android.os.Parcel dest, int flags) {\n}\n";
    private static final String WRITE_TO_PARCEL_WITH_SUPER = "@Override\npublic void writeToParcel(android.os.Parcel dest, int flags) {\n  super.writeToParcel(dest, flags);\n}\n";
    private static final String CLASS_T = "T";
    private static final String CLASS_T_ARRAY = "T[]";
    private final String myName;
    private final Operation myOperation;

    public ParcelableQuickFix(String name, Operation operation) {
        this.myName = name;
        this.myOperation = operation;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            ParcelableQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        PsiClass parcelable;
        if (startElement == null) {
            ParcelableQuickFix.$$$reportNull$$$0(1);
        }
        if (endElement == null) {
            ParcelableQuickFix.$$$reportNull$$$0(2);
        }
        if (contextType == null) {
            ParcelableQuickFix.$$$reportNull$$$0(3);
        }
        if ((parcelable = this.getClassOfSupportedElement(startElement)) == null || ParcelableQuickFix.findParcelableFromImplementsList(parcelable) == null) {
            return false;
        }
        switch (this.myOperation) {
            case IMPLEMENT: {
                return parcelable.findFieldByName("CREATOR", false) == null;
            }
            case REIMPLEMENT: {
                return parcelable.findFieldByName("CREATOR", false) != null;
            }
            case REMOVE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        PsiClass parcelable;
        if (startElement == null) {
            ParcelableQuickFix.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            ParcelableQuickFix.$$$reportNull$$$0(5);
        }
        if (context == null) {
            ParcelableQuickFix.$$$reportNull$$$0(6);
        }
        if ((parcelable = this.getClassOfSupportedElement(startElement)) == null) {
            return;
        }
        QuickFixWorker worker = new QuickFixWorker(parcelable);
        switch (this.myOperation) {
            case IMPLEMENT: {
                worker.implement();
                break;
            }
            case REMOVE: {
                worker.remove();
                break;
            }
            case REIMPLEMENT: {
                worker.reimplement();
            }
        }
    }

    @Nullable
    private PsiClass getClassOfSupportedElement(@NotNull PsiElement element) {
        PsiJavaCodeReferenceElement reference;
        if (element == null) {
            ParcelableQuickFix.$$$reportNull$$$0(7);
        }
        if (element instanceof PsiIdentifier && element.getParent() instanceof PsiClass) {
            return (PsiClass)element.getParent();
        }
        if (element instanceof PsiClass && this.myOperation != Operation.IMPLEMENT) {
            return (PsiClass)element;
        }
        if (element instanceof PsiJavaCodeReferenceElement && (reference = (PsiJavaCodeReferenceElement)element).getCanonicalText().equals("android.os.Parcelable") && reference.getParent() instanceof PsiReferenceList && reference.getParent().getParent() instanceof PsiClass) {
            return (PsiClass)reference.getParent().getParent();
        }
        return null;
    }

    @Nullable
    private static PsiElement findParcelableFromImplementsList(@NotNull PsiClass parcelable) {
        PsiReferenceList implementsList;
        if (parcelable == null) {
            ParcelableQuickFix.$$$reportNull$$$0(8);
        }
        if ((implementsList = parcelable.getImplementsList()) != null) {
            for (PsiJavaCodeReferenceElement element : implementsList.getReferenceElements()) {
                if (!"android.os.Parcelable".equals(element.getQualifiedName())) continue;
                return element;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/lint/ParcelableQuickFix";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parcelable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/lint/ParcelableQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getClassOfSupportedElement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findParcelableFromImplementsList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ShortOrCharObjectFieldPersistence
    implements QuickFixWorker.FieldPersistence {
        private String myCast;

        ShortOrCharObjectFieldPersistence(String cast) {
            this.myCast = cast;
        }

        @Override
        public String[] formatWrite(@NotNull PsiField field, @NotNull String parcelVariableName, @NotNull String flagsVariableName) {
            if (field == null) {
                ShortOrCharObjectFieldPersistence.$$$reportNull$$$0(0);
            }
            if (parcelVariableName == null) {
                ShortOrCharObjectFieldPersistence.$$$reportNull$$$0(1);
            }
            if (flagsVariableName == null) {
                ShortOrCharObjectFieldPersistence.$$$reportNull$$$0(2);
            }
            return new String[]{String.format("%1$s.writeInt(%2$s != null ? (int)%2$s : Integer.MAX_VALUE);", parcelVariableName, field.getName())};
        }

        @Override
        public String[] formatRead(@NotNull PsiField field, @NotNull String parcelVariableName) {
            if (field == null) {
                ShortOrCharObjectFieldPersistence.$$$reportNull$$$0(3);
            }
            if (parcelVariableName == null) {
                ShortOrCharObjectFieldPersistence.$$$reportNull$$$0(4);
            }
            String fieldName = field.getName();
            assert (fieldName != null);
            String var = "tmp" + StringUtil.capitalize((String)fieldName);
            return new String[]{String.format("int %1$s = %2$s.readInt();", var, parcelVariableName), String.format("%1$s = %2$s != Integer.MAX_VALUE ? (%3$s) %2$s : null;", fieldName, var, this.myCast)};
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parcelVariableName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flagsVariableName";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/lint/ParcelableQuickFix$ShortOrCharObjectFieldPersistence";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "formatWrite";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "formatRead";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ShortOrCharFieldPersistence
    implements QuickFixWorker.FieldPersistence {
        private String myCast;

        ShortOrCharFieldPersistence(String cast) {
            this.myCast = cast;
        }

        @Override
        public String[] formatWrite(@NotNull PsiField field, @NotNull String parcelVariableName, @NotNull String flagsVariableName) {
            if (field == null) {
                ShortOrCharFieldPersistence.$$$reportNull$$$0(0);
            }
            if (parcelVariableName == null) {
                ShortOrCharFieldPersistence.$$$reportNull$$$0(1);
            }
            if (flagsVariableName == null) {
                ShortOrCharFieldPersistence.$$$reportNull$$$0(2);
            }
            return new String[]{String.format("%1$s.writeInt((int)%2$s);", parcelVariableName, field.getName())};
        }

        @Override
        public String[] formatRead(@NotNull PsiField field, @NotNull String parcelVariableName) {
            if (field == null) {
                ShortOrCharFieldPersistence.$$$reportNull$$$0(3);
            }
            if (parcelVariableName == null) {
                ShortOrCharFieldPersistence.$$$reportNull$$$0(4);
            }
            return new String[]{String.format("%1$s = (%2$s)%3$s.readInt();", field.getName(), this.myCast, parcelVariableName)};
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parcelVariableName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flagsVariableName";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/lint/ParcelableQuickFix$ShortOrCharFieldPersistence";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "formatWrite";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "formatRead";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class BooleanObjectFieldPersistence
    implements QuickFixWorker.FieldPersistence {
        private BooleanObjectFieldPersistence() {
        }

        @Override
        public String[] formatWrite(@NotNull PsiField field, @NotNull String parcelVariableName, @NotNull String flagsVariableName) {
            if (field == null) {
                BooleanObjectFieldPersistence.$$$reportNull$$$0(0);
            }
            if (parcelVariableName == null) {
                BooleanObjectFieldPersistence.$$$reportNull$$$0(1);
            }
            if (flagsVariableName == null) {
                BooleanObjectFieldPersistence.$$$reportNull$$$0(2);
            }
            return new String[]{String.format("%1$s.writeByte((byte)(%2$s == null ? 0 : %2$s ? 1 : 2));\n", parcelVariableName, field.getName())};
        }

        @Override
        public String[] formatRead(@NotNull PsiField field, @NotNull String parcelVariableName) {
            if (field == null) {
                BooleanObjectFieldPersistence.$$$reportNull$$$0(3);
            }
            if (parcelVariableName == null) {
                BooleanObjectFieldPersistence.$$$reportNull$$$0(4);
            }
            String fieldName = field.getName();
            assert (fieldName != null);
            String var = "tmp" + StringUtil.capitalize((String)fieldName);
            return new String[]{String.format("byte %1$s = %2$s.readByte();", var, parcelVariableName), String.format("%1$s = %2$s == 0 ? null : %2$s == 1;\n", fieldName, var)};
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parcelVariableName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flagsVariableName";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/lint/ParcelableQuickFix$BooleanObjectFieldPersistence";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "formatWrite";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "formatRead";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class QuickFixWorker {
        private final Project myProject;
        private final JavaPsiFacade myFacade;
        private final PsiElementFactory myFactory;
        private final PsiClass myParcelable;
        private final PsiClassType myParcelableType;
        private final PsiClassType myListType;
        private final PsiClass myList;
        private final PsiClassType myTType;
        private final PsiClassType myTArrayType;
        private final PsiClassType myTListType;
        private final Map<PsiType, FieldPersistence> myPersistenceMap;
        private final Set<String> myIgnoredMethods;

        private QuickFixWorker(@NotNull PsiClass parcelable) {
            if (parcelable == null) {
                QuickFixWorker.$$$reportNull$$$0(0);
            }
            this.myProject = parcelable.getProject();
            this.myFacade = JavaPsiFacade.getInstance((Project)this.myProject);
            this.myFactory = this.myFacade.getElementFactory();
            this.myParcelable = parcelable;
            this.myParcelableType = PsiType.getTypeByName((String)"android.os.Parcelable", (Project)this.myProject, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject));
            this.myListType = PsiType.getTypeByName((String)"java.util.List", (Project)this.myProject, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject));
            this.myList = this.myListType.resolve();
            assert (this.myList != null);
            this.myTType = PsiType.getTypeByName((String)ParcelableQuickFix.CLASS_T, (Project)this.myProject, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject));
            this.myTArrayType = PsiType.getTypeByName((String)ParcelableQuickFix.CLASS_T_ARRAY, (Project)this.myProject, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject));
            this.myTListType = this.myFactory.createType(this.myList, (PsiType)this.myTType);
            this.myPersistenceMap = new HashMap();
            this.myIgnoredMethods = new HashSet();
            this.populateIgnoredMethods();
            this.populateFieldPersistenceByType();
        }

        private void implement() {
            this.findOrCreateParcelableFromImplementsList();
            PsiMethod constructor = this.findOrCreateConstructor();
            this.addFieldReadsToConstructor(constructor);
            PsiMethod writeToParcel = this.findOrCreateWriteToParcel();
            this.addFieldWrites(writeToParcel);
            PsiMethod describeContents = this.findOrCreateDescribeContents();
            PsiField creator = this.findOrCreateCreator();
            PsiElement insertionPoint = this.findInsertionPoint();
            QuickFixWorker.addBefore((PsiElement)this.myParcelable, (PsiElement)constructor, insertionPoint);
            QuickFixWorker.addBefore((PsiElement)this.myParcelable, (PsiElement)writeToParcel, insertionPoint);
            QuickFixWorker.addBefore((PsiElement)this.myParcelable, (PsiElement)describeContents, insertionPoint);
            QuickFixWorker.addBefore((PsiElement)this.myParcelable, (PsiElement)creator, insertionPoint);
            this.save();
        }

        private void remove() {
            QuickFixWorker.delete((PsiElement)this.findConstructor());
            QuickFixWorker.delete((PsiElement)this.findWriteToParcel());
            QuickFixWorker.delete((PsiElement)this.findDescribeContents());
            QuickFixWorker.delete((PsiElement)this.findCreator());
            QuickFixWorker.delete(ParcelableQuickFix.findParcelableFromImplementsList(this.myParcelable));
            QuickFixWorker.delete(this.findImportOfClass("android.os.Parcel"));
            QuickFixWorker.delete(this.findImportOfClass("android.os.Parcelable"));
            this.save();
        }

        private void reimplement() {
            QuickFixWorker.delete((PsiElement)this.findConstructor());
            QuickFixWorker.delete((PsiElement)this.findWriteToParcel());
            QuickFixWorker.delete((PsiElement)this.findDescribeContents());
            QuickFixWorker.delete((PsiElement)this.findCreator());
            this.implement();
            this.save();
        }

        private void save() {
            Document document = FileDocumentManager.getInstance().getDocument(this.myParcelable.getContainingFile().getVirtualFile());
            if (document != null) {
                PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(document);
            }
        }

        @Nullable
        private PsiField findCreator() {
            return this.myParcelable.findFieldByName("CREATOR", false);
        }

        @NotNull
        private PsiField findOrCreateCreator() {
            PsiField field = this.findCreator();
            if (field == null) {
                field = this.myFactory.createFieldFromText(String.format(ParcelableQuickFix.CREATOR, this.myParcelable.getName()), (PsiElement)this.myParcelable);
            }
            JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences((PsiElement)field);
            PsiField psiField = field;
            if (psiField == null) {
                QuickFixWorker.$$$reportNull$$$0(1);
            }
            return psiField;
        }

        @Nullable
        private PsiMethod findConstructor() {
            for (PsiMethod method : this.myParcelable.getConstructors()) {
                if (!QuickFixWorker.isConstructorWithParcelParameter(method)) continue;
                return method;
            }
            return null;
        }

        @NotNull
        private PsiMethod findOrCreateConstructor() {
            PsiMethod method = this.findConstructor();
            if (method == null) {
                String fmt = this.doesSuperClassImplementParcelable() ? ParcelableQuickFix.CONSTRUCTOR_WITH_SUPER : ParcelableQuickFix.CONSTRUCTOR;
                method = this.createMethodWithShortClassReferences(String.format(fmt, this.myParcelable.getName()));
            }
            PsiMethod psiMethod = method;
            if (psiMethod == null) {
                QuickFixWorker.$$$reportNull$$$0(2);
            }
            return psiMethod;
        }

        @Nullable
        private PsiMethod findDescribeContents() {
            for (PsiMethod method : this.myParcelable.getMethods()) {
                PsiParameterList params = method.getParameterList();
                if (!method.getName().equals("describeContents") || params.getParametersCount() != 0) continue;
                return method;
            }
            return null;
        }

        @NotNull
        private PsiMethod findOrCreateDescribeContents() {
            PsiMethod method = this.findDescribeContents();
            if (method == null) {
                method = this.createMethodWithShortClassReferences(ParcelableQuickFix.DESCRIBE_CONTENTS);
            }
            PsiMethod psiMethod = method;
            if (psiMethod == null) {
                QuickFixWorker.$$$reportNull$$$0(3);
            }
            return psiMethod;
        }

        @Nullable
        private PsiMethod findWriteToParcel() {
            for (PsiMethod method : this.myParcelable.getMethods()) {
                if (!QuickFixWorker.isWriteToParcelMethod(method)) continue;
                return method;
            }
            return null;
        }

        @NotNull
        private PsiMethod findOrCreateWriteToParcel() {
            PsiMethod method = this.findWriteToParcel();
            if (method == null) {
                String text = this.doesSuperClassImplementParcelable() ? ParcelableQuickFix.WRITE_TO_PARCEL_WITH_SUPER : ParcelableQuickFix.WRITE_TO_PARCEL;
                method = this.createMethodWithShortClassReferences(text);
            }
            PsiMethod psiMethod = method;
            if (psiMethod == null) {
                QuickFixWorker.$$$reportNull$$$0(4);
            }
            return psiMethod;
        }

        private void findOrCreateParcelableFromImplementsList() {
            PsiReferenceList implementsList;
            PsiElement element = ParcelableQuickFix.findParcelableFromImplementsList(this.myParcelable);
            if (element == null && (implementsList = this.myParcelable.getImplementsList()) != null) {
                PsiJavaCodeReferenceElement implementsParcelable = this.myFactory.createReferenceElementByFQClassName("android.os.Parcelable", this.myParcelable.getResolveScope());
                implementsList.add((PsiElement)implementsParcelable);
            }
        }

        @Nullable
        private PsiElement findImportOfClass(@NotNull String className) {
            PsiImportList importList;
            PsiFile file;
            if (className == null) {
                QuickFixWorker.$$$reportNull$$$0(5);
            }
            if ((file = this.myParcelable.getContainingFile()) != null && file instanceof PsiJavaFile && (importList = ((PsiJavaFile)file).getImportList()) != null) {
                return importList.findSingleClassImportStatement(className);
            }
            return null;
        }

        private PsiMethod createMethodWithShortClassReferences(@NotNull String text) {
            if (text == null) {
                QuickFixWorker.$$$reportNull$$$0(6);
            }
            PsiMethod method = this.myFactory.createMethodFromText(text, (PsiElement)this.myParcelable);
            JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences((PsiElement)method);
            return method;
        }

        private static boolean isConstructorWithParcelParameter(@NotNull PsiMethod method) {
            if (method == null) {
                QuickFixWorker.$$$reportNull$$$0(7);
            }
            PsiParameterList params = method.getParameterList();
            return method.isConstructor() && params.getParametersCount() == 1 && params.getParameters()[0].getType().equalsToText("android.os.Parcel");
        }

        private static boolean isWriteToParcelMethod(@NotNull PsiMethod method) {
            if (method == null) {
                QuickFixWorker.$$$reportNull$$$0(8);
            }
            PsiParameterList params = method.getParameterList();
            return method.getName().equals("writeToParcel") && params.getParametersCount() == 2 && params.getParameters()[0].getType().equalsToText("android.os.Parcel") && params.getParameters()[1].getType().equalsToText(PsiType.INT.getCanonicalText());
        }

        private boolean doesSuperClassImplementParcelable() {
            PsiClass superClass = this.myParcelable.getSuperClass();
            if (superClass == null) {
                return false;
            }
            return ParcelableQuickFix.findParcelableFromImplementsList(superClass) != null;
        }

        private void addFieldReadsToConstructor(@NotNull PsiMethod constructor) {
            if (constructor == null) {
                QuickFixWorker.$$$reportNull$$$0(9);
            }
            assert (QuickFixWorker.isConstructorWithParcelParameter(constructor));
            if (!this.isEmptyMethod(constructor)) {
                return;
            }
            this.removeInitialBlankLines(constructor);
            String paramName = constructor.getParameterList().getParameters()[0].getName();
            PsiCodeBlock body = constructor.getBody();
            assert (body != null);
            assert (paramName != null);
            for (PsiField field : this.myParcelable.getFields()) {
                FieldPersistence persistence = this.findFieldPersistence(field);
                if (persistence == null) continue;
                this.createStatements(persistence.formatRead(field, paramName), body, constructor);
            }
            JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences((PsiElement)constructor);
        }

        private void addFieldWrites(@NotNull PsiMethod writeToParcel) {
            if (writeToParcel == null) {
                QuickFixWorker.$$$reportNull$$$0(10);
            }
            assert (QuickFixWorker.isWriteToParcelMethod(writeToParcel));
            if (!this.isEmptyMethod(writeToParcel)) {
                return;
            }
            this.removeInitialBlankLines(writeToParcel);
            String parcelName = writeToParcel.getParameterList().getParameters()[0].getName();
            String flagsName = writeToParcel.getParameterList().getParameters()[1].getName();
            PsiCodeBlock body = writeToParcel.getBody();
            assert (body != null);
            assert (parcelName != null);
            assert (flagsName != null);
            for (PsiField field : this.myParcelable.getFields()) {
                FieldPersistence persistence = this.findFieldPersistence(field);
                if (persistence == null) continue;
                this.createStatements(persistence.formatWrite(field, parcelName, flagsName), body, writeToParcel);
            }
        }

        private boolean isEmptyMethod(@NotNull PsiMethod method) {
            if (method == null) {
                QuickFixWorker.$$$reportNull$$$0(11);
            }
            int expectedStatementCount = this.doesSuperClassImplementParcelable() ? 1 : 0;
            return method.getBody() == null || method.getBody().getStatements().length <= expectedStatementCount;
        }

        private void removeInitialBlankLines(@NotNull PsiMethod method) {
            PsiWhiteSpace whiteSpace;
            if (method == null) {
                QuickFixWorker.$$$reportNull$$$0(12);
            }
            if ((whiteSpace = (PsiWhiteSpace)PsiTreeUtil.getChildOfType((PsiElement)method.getBody(), PsiWhiteSpace.class)) != null && whiteSpace.getText().startsWith("\n\n")) {
                method.getBody().replace((PsiElement)this.myFactory.createCodeBlock());
            }
        }

        private void createStatements(@NotNull String[] stmtText, @NotNull PsiCodeBlock body, @NotNull PsiMethod method) {
            if (stmtText == null) {
                QuickFixWorker.$$$reportNull$$$0(13);
            }
            if (body == null) {
                QuickFixWorker.$$$reportNull$$$0(14);
            }
            if (method == null) {
                QuickFixWorker.$$$reportNull$$$0(15);
            }
            for (String text : stmtText) {
                PsiStatement stmt = this.myFactory.createStatementFromText(text, (PsiElement)method);
                body.add((PsiElement)stmt);
            }
        }

        @Nullable
        private FieldPersistence findFieldPersistence(@NotNull PsiField field) {
            String qualifiedName;
            PsiType elemType;
            if (field == null) {
                QuickFixWorker.$$$reportNull$$$0(16);
            }
            if (field.hasModifierProperty("transient") || field.hasModifierProperty("static")) {
                return null;
            }
            PsiType type = field.getType();
            FieldPersistence persistence = this.myPersistenceMap.get(type);
            if (persistence != null) {
                return persistence;
            }
            if (this.myParcelableType.isAssignableFrom(type.getDeepComponentType()) && !this.myParcelableType.equals((Object)type.getDeepComponentType())) {
                PsiArrayType arrayType;
                if (type.equals(type.getDeepComponentType())) {
                    return this.myPersistenceMap.get(this.myTType);
                }
                if (type instanceof PsiArrayType && (arrayType = (PsiArrayType)type).getComponentType().equals(type.getDeepComponentType())) {
                    return this.myPersistenceMap.get(this.myTArrayType);
                }
            }
            if ((elemType = QuickFixWorker.getListElementType(type)) != null && this.myParcelableType.isAssignableFrom(elemType) && !this.myParcelableType.equals((Object)elemType)) {
                return this.myPersistenceMap.get(this.myTListType);
            }
            switch (qualifiedName = type.getCanonicalText()) {
                case "java.lang.Byte": {
                    return new NumberObjectPersistence("Byte");
                }
                case "java.lang.Double": {
                    return new NumberObjectPersistence("Double");
                }
                case "java.lang.Float": {
                    return new NumberObjectPersistence("Float");
                }
                case "java.lang.Integer": {
                    return new NumberObjectPersistence("Int");
                }
                case "java.lang.Long": {
                    return new NumberObjectPersistence("Long");
                }
                case "java.lang.Character": {
                    return new ShortOrCharObjectFieldPersistence("char");
                }
                case "java.lang.Short": {
                    return new ShortOrCharObjectFieldPersistence("short");
                }
                case "short": {
                    return new ShortOrCharFieldPersistence("short");
                }
                case "char": {
                    return new ShortOrCharFieldPersistence("char");
                }
                case "java.lang.Boolean": {
                    return new BooleanObjectFieldPersistence();
                }
            }
            return null;
        }

        @Nullable
        private PsiElement findInsertionPoint() {
            for (PsiMethod method : this.myParcelable.getMethods()) {
                if (method.isConstructor()) continue;
                return method;
            }
            return null;
        }

        private static void addBefore(@NotNull PsiElement parent, @NotNull PsiElement element, @Nullable PsiElement insertionPoint) {
            if (parent == null) {
                QuickFixWorker.$$$reportNull$$$0(17);
            }
            if (element == null) {
                QuickFixWorker.$$$reportNull$$$0(18);
            }
            if (element.getParent() == parent) {
                return;
            }
            parent.addBefore(element, insertionPoint);
        }

        private static void delete(@Nullable PsiElement element) {
            if (element != null) {
                element.delete();
            }
        }

        private void populateIgnoredMethods() {
            this.myIgnoredMethods.add("writeParcelable");
            this.myIgnoredMethods.add("readParcelable");
            this.myIgnoredMethods.add("writeParcelableArray");
            this.myIgnoredMethods.add("readParcelableArray");
            this.myIgnoredMethods.add("readSerializable");
            this.myIgnoredMethods.add("writeSerializable");
            this.myIgnoredMethods.add("readValue");
            this.myIgnoredMethods.add("writeValue");
            this.myIgnoredMethods.add("readArray");
            this.myIgnoredMethods.add("writeArray");
        }

        private void populateFieldPersistenceByType() {
            PsiClass parcel = this.myFacade.findClass("android.os.Parcel", GlobalSearchScope.allScope((Project)this.myProject));
            if (parcel == null) {
                return;
            }
            HashMap setters = new HashMap();
            HashMap getters = new HashMap();
            for (PsiMethod method : parcel.getMethods()) {
                PsiType type;
                if (this.myIgnoredMethods.contains(method.getName())) continue;
                if (QuickFixWorker.isSimpleWrite(method) || QuickFixWorker.isWriteWithParcelableFlags(method)) {
                    type = method.getParameterList().getParameters()[0].getType();
                    setters.put(type, method);
                    continue;
                }
                if (!QuickFixWorker.isSimpleRead(method)) continue;
                type = method.getReturnType();
                getters.put(type, method);
            }
            for (PsiType type : getters.keySet()) {
                SimpleFieldPersistence persistence;
                PsiType setterType = this.getTypicalSetterType(type);
                PsiMethod getter = (PsiMethod)getters.get(type);
                PsiMethod setter = (PsiMethod)setters.get(setterType);
                if (getter == null || setter == null) continue;
                if (QuickFixWorker.isSimpleWrite(setter)) {
                    persistence = new SimpleFieldPersistence(setter.getName(), getter.getName());
                } else {
                    if (!QuickFixWorker.isWriteWithParcelableFlags(setter)) continue;
                    persistence = new SimpleWithFlagsFieldPersistence(setter.getName(), getter.getName());
                }
                this.myPersistenceMap.put(type, persistence);
                this.myPersistenceMap.put(setterType, persistence);
            }
            this.myPersistenceMap.put((PsiType)this.myTType, new ParcelableFieldPersistence());
            this.myPersistenceMap.put((PsiType)this.myTArrayType, new EfficientParcelableArrayFieldPersistence());
            this.myPersistenceMap.put((PsiType)this.myTListType, new EfficientParcelableListFieldPersistence());
            this.myPersistenceMap.put((PsiType)PsiType.BOOLEAN, new BooleanFieldPersistence());
        }

        @NotNull
        private PsiType getTypicalSetterType(@NotNull PsiType type) {
            PsiType elemType;
            if (type == null) {
                QuickFixWorker.$$$reportNull$$$0(19);
            }
            Object object = (elemType = QuickFixWorker.getListElementType(type)) == null ? type : this.myFactory.createType(this.myList, elemType);
            if (object == null) {
                QuickFixWorker.$$$reportNull$$$0(20);
            }
            return object;
        }

        @Nullable
        private static PsiType getListElementType(@NotNull PsiType type) {
            PsiClassReferenceType refType;
            PsiType[] elemTypes;
            if (type == null) {
                QuickFixWorker.$$$reportNull$$$0(21);
            }
            if (type instanceof PsiClassReferenceType && (elemTypes = (refType = (PsiClassReferenceType)type).getParameters()).length == 1 && (type.getCanonicalText().startsWith("java.util.List") || type.getCanonicalText().startsWith("java.util.ArrayList"))) {
                return elemTypes[0];
            }
            return null;
        }

        private static boolean isSimpleWrite(@NotNull PsiMethod method) {
            if (method == null) {
                QuickFixWorker.$$$reportNull$$$0(22);
            }
            return method.getName().startsWith("write") && method.getParameterList().getParametersCount() == 1;
        }

        private static boolean isWriteWithParcelableFlags(@NotNull PsiMethod method) {
            if (method == null) {
                QuickFixWorker.$$$reportNull$$$0(23);
            }
            if (!method.getName().startsWith("write") || method.getParameterList().getParametersCount() != 2) {
                return false;
            }
            PsiParameter param = method.getParameterList().getParameters()[1];
            return param.getType().equals(PsiType.INT) && Objects.equals(param.getName(), "parcelableFlags");
        }

        private static boolean isSimpleRead(@NotNull PsiMethod method) {
            if (method == null) {
                QuickFixWorker.$$$reportNull$$$0(24);
            }
            return (method.getName().startsWith("read") || method.getName().startsWith("create")) && method.getParameterList().getParametersCount() == 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 20: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 20: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parcelable";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/lint/ParcelableQuickFix$QuickFixWorker";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "className";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 7: 
                case 8: 
                case 11: 
                case 12: 
                case 15: 
                case 22: 
                case 23: 
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constructor";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "writeToParcel";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stmtText";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "body";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 19: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/lint/ParcelableQuickFix$QuickFixWorker";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findOrCreateCreator";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findOrCreateConstructor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findOrCreateDescribeContents";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findOrCreateWriteToParcel";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypicalSetterType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 20: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "findImportOfClass";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createMethodWithShortClassReferences";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isConstructorWithParcelParameter";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "isWriteToParcelMethod";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "addFieldReadsToConstructor";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "addFieldWrites";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "isEmptyMethod";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "removeInitialBlankLines";
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "createStatements";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "findFieldPersistence";
                    break;
                }
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "addBefore";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "getTypicalSetterType";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "getListElementType";
                    break;
                }
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "isSimpleWrite";
                    break;
                }
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "isWriteWithParcelableFlags";
                    break;
                }
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "isSimpleRead";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 20: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class NumberObjectPersistence
        implements FieldPersistence {
            private String myMethodSuffix;

            NumberObjectPersistence(String methodSuffix) {
                this.myMethodSuffix = methodSuffix;
            }

            @Override
            public String[] formatWrite(@NotNull PsiField field, @NotNull String parcelVariableName, @NotNull String flagsVariableName) {
                if (field == null) {
                    NumberObjectPersistence.$$$reportNull$$$0(0);
                }
                if (parcelVariableName == null) {
                    NumberObjectPersistence.$$$reportNull$$$0(1);
                }
                if (flagsVariableName == null) {
                    NumberObjectPersistence.$$$reportNull$$$0(2);
                }
                return new String[]{String.format("if (%2$s == null) { %1$s.writeByte((byte)0); } else { %1$s.writeByte((byte)1); %1$s.write%3$s(%2$s); }", parcelVariableName, field.getName(), this.myMethodSuffix)};
            }

            @Override
            public String[] formatRead(@NotNull PsiField field, @NotNull String parcelVariableName) {
                if (field == null) {
                    NumberObjectPersistence.$$$reportNull$$$0(3);
                }
                if (parcelVariableName == null) {
                    NumberObjectPersistence.$$$reportNull$$$0(4);
                }
                return new String[]{String.format("if (%2$s.readByte() == 0) { %1$s = null; } else { %1$s = %2$s.read%3$s(); }", field.getName(), parcelVariableName, this.myMethodSuffix)};
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "field";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parcelVariableName";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "flagsVariableName";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/lint/ParcelableQuickFix$QuickFixWorker$NumberObjectPersistence";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "formatWrite";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "formatRead";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static class BooleanFieldPersistence
        implements FieldPersistence {
            private BooleanFieldPersistence() {
            }

            @Override
            public String[] formatWrite(@NotNull PsiField field, @NotNull String parcelVariableName, @NotNull String flagsVariableName) {
                if (field == null) {
                    BooleanFieldPersistence.$$$reportNull$$$0(0);
                }
                if (parcelVariableName == null) {
                    BooleanFieldPersistence.$$$reportNull$$$0(1);
                }
                if (flagsVariableName == null) {
                    BooleanFieldPersistence.$$$reportNull$$$0(2);
                }
                return new String[]{String.format("%1$s.writeByte((byte)(%2$s ? 1 : 0));\n", parcelVariableName, field.getName())};
            }

            @Override
            public String[] formatRead(@NotNull PsiField field, @NotNull String parcelVariableName) {
                if (field == null) {
                    BooleanFieldPersistence.$$$reportNull$$$0(3);
                }
                if (parcelVariableName == null) {
                    BooleanFieldPersistence.$$$reportNull$$$0(4);
                }
                return new String[]{String.format("%1$s = %2$s.readByte() != 0;\n", field.getName(), parcelVariableName)};
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "field";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parcelVariableName";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "flagsVariableName";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/lint/ParcelableQuickFix$QuickFixWorker$BooleanFieldPersistence";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "formatWrite";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "formatRead";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static class EfficientParcelableListFieldPersistence
        implements FieldPersistence {
            private EfficientParcelableListFieldPersistence() {
            }

            @Override
            public String[] formatWrite(@NotNull PsiField field, @NotNull String parcelVariableName, @NotNull String flagsVariableName) {
                if (field == null) {
                    EfficientParcelableListFieldPersistence.$$$reportNull$$$0(0);
                }
                if (parcelVariableName == null) {
                    EfficientParcelableListFieldPersistence.$$$reportNull$$$0(1);
                }
                if (flagsVariableName == null) {
                    EfficientParcelableListFieldPersistence.$$$reportNull$$$0(2);
                }
                return new String[]{String.format("%1$s.writeTypedList(%2$s);\n", parcelVariableName, field.getName())};
            }

            @Override
            public String[] formatRead(@NotNull PsiField field, @NotNull String parcelVariableName) {
                if (field == null) {
                    EfficientParcelableListFieldPersistence.$$$reportNull$$$0(3);
                }
                if (parcelVariableName == null) {
                    EfficientParcelableListFieldPersistence.$$$reportNull$$$0(4);
                }
                PsiType elemType = QuickFixWorker.getListElementType(field.getType());
                assert (elemType != null);
                return new String[]{String.format("%1$s = %2$s.createTypedArrayList(%3$s.CREATOR);\n", field.getName(), parcelVariableName, elemType.getCanonicalText())};
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "field";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parcelVariableName";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "flagsVariableName";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/lint/ParcelableQuickFix$QuickFixWorker$EfficientParcelableListFieldPersistence";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "formatWrite";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "formatRead";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static class EfficientParcelableArrayFieldPersistence
        implements FieldPersistence {
            private EfficientParcelableArrayFieldPersistence() {
            }

            @Override
            public String[] formatWrite(@NotNull PsiField field, @NotNull String parcelVariableName, @NotNull String flagsVariableName) {
                if (field == null) {
                    EfficientParcelableArrayFieldPersistence.$$$reportNull$$$0(0);
                }
                if (parcelVariableName == null) {
                    EfficientParcelableArrayFieldPersistence.$$$reportNull$$$0(1);
                }
                if (flagsVariableName == null) {
                    EfficientParcelableArrayFieldPersistence.$$$reportNull$$$0(2);
                }
                return new String[]{String.format("%1$s.writeTypedArray(%2$s, %3$s);\n", parcelVariableName, field.getName(), flagsVariableName)};
            }

            @Override
            public String[] formatRead(@NotNull PsiField field, @NotNull String parcelVariableName) {
                if (field == null) {
                    EfficientParcelableArrayFieldPersistence.$$$reportNull$$$0(3);
                }
                if (parcelVariableName == null) {
                    EfficientParcelableArrayFieldPersistence.$$$reportNull$$$0(4);
                }
                String typeName = field.getType().getDeepComponentType().getCanonicalText();
                return new String[]{String.format("%1$s = %2$s.createTypedArray(%3$s.CREATOR);\n", field.getName(), parcelVariableName, typeName)};
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "field";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parcelVariableName";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "flagsVariableName";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/lint/ParcelableQuickFix$QuickFixWorker$EfficientParcelableArrayFieldPersistence";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "formatWrite";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "formatRead";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static class ParcelableFieldPersistence
        implements FieldPersistence {
            private ParcelableFieldPersistence() {
            }

            @Override
            public String[] formatWrite(@NotNull PsiField field, @NotNull String parcelVariableName, @NotNull String flagsVariableName) {
                if (field == null) {
                    ParcelableFieldPersistence.$$$reportNull$$$0(0);
                }
                if (parcelVariableName == null) {
                    ParcelableFieldPersistence.$$$reportNull$$$0(1);
                }
                if (flagsVariableName == null) {
                    ParcelableFieldPersistence.$$$reportNull$$$0(2);
                }
                return new String[]{String.format("%1$s.writeParcelable(%2$s, %3$s);\n", parcelVariableName, field.getName(), flagsVariableName)};
            }

            @Override
            public String[] formatRead(@NotNull PsiField field, @NotNull String parcelVariableName) {
                if (field == null) {
                    ParcelableFieldPersistence.$$$reportNull$$$0(3);
                }
                if (parcelVariableName == null) {
                    ParcelableFieldPersistence.$$$reportNull$$$0(4);
                }
                return new String[]{String.format("%1$s = %2$s.readParcelable(%3$s.class.getClassLoader());\n", field.getName(), parcelVariableName, field.getType().getCanonicalText())};
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "field";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parcelVariableName";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "flagsVariableName";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/lint/ParcelableQuickFix$QuickFixWorker$ParcelableFieldPersistence";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "formatWrite";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "formatRead";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static class SimpleWithFlagsFieldPersistence
        extends SimpleFieldPersistence {
            SimpleWithFlagsFieldPersistence(@NotNull String writeMethod, @NotNull String readMethod) {
                if (writeMethod == null) {
                    SimpleWithFlagsFieldPersistence.$$$reportNull$$$0(0);
                }
                if (readMethod == null) {
                    SimpleWithFlagsFieldPersistence.$$$reportNull$$$0(1);
                }
                super(writeMethod, readMethod);
            }

            @Override
            public String[] formatWrite(@NotNull PsiField field, @NotNull String parcelVariableName, @NotNull String flagsVariableName) {
                if (field == null) {
                    SimpleWithFlagsFieldPersistence.$$$reportNull$$$0(2);
                }
                if (parcelVariableName == null) {
                    SimpleWithFlagsFieldPersistence.$$$reportNull$$$0(3);
                }
                if (flagsVariableName == null) {
                    SimpleWithFlagsFieldPersistence.$$$reportNull$$$0(4);
                }
                return new String[]{String.format("%1$s.%2$s(%3$s, %4$s);\n", parcelVariableName, this.myWriteMethodName, field.getName(), flagsVariableName)};
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "writeMethod";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "readMethod";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "field";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parcelVariableName";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "flagsVariableName";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/lint/ParcelableQuickFix$QuickFixWorker$SimpleWithFlagsFieldPersistence";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "formatWrite";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static class SimpleFieldPersistence
        implements FieldPersistence {
            protected String myWriteMethodName;
            protected String myReadMethodName;

            SimpleFieldPersistence(@NotNull String writeMethod, @NotNull String readMethod) {
                if (writeMethod == null) {
                    SimpleFieldPersistence.$$$reportNull$$$0(0);
                }
                if (readMethod == null) {
                    SimpleFieldPersistence.$$$reportNull$$$0(1);
                }
                this.myWriteMethodName = writeMethod;
                this.myReadMethodName = readMethod;
            }

            @Override
            public String[] formatWrite(@NotNull PsiField field, @NotNull String parcelVariableName, @NotNull String flagsVariableName) {
                if (field == null) {
                    SimpleFieldPersistence.$$$reportNull$$$0(2);
                }
                if (parcelVariableName == null) {
                    SimpleFieldPersistence.$$$reportNull$$$0(3);
                }
                if (flagsVariableName == null) {
                    SimpleFieldPersistence.$$$reportNull$$$0(4);
                }
                return new String[]{String.format("%1$s.%2$s(%3$s);\n", parcelVariableName, this.myWriteMethodName, field.getName())};
            }

            @Override
            public String[] formatRead(@NotNull PsiField field, @NotNull String parcelVariableName) {
                if (field == null) {
                    SimpleFieldPersistence.$$$reportNull$$$0(5);
                }
                if (parcelVariableName == null) {
                    SimpleFieldPersistence.$$$reportNull$$$0(6);
                }
                return new String[]{String.format("%1$s = %2$s.%3$s();\n", field.getName(), parcelVariableName, this.myReadMethodName)};
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "writeMethod";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "readMethod";
                        break;
                    }
                    case 2: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "field";
                        break;
                    }
                    case 3: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parcelVariableName";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "flagsVariableName";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/lint/ParcelableQuickFix$QuickFixWorker$SimpleFieldPersistence";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "formatWrite";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "formatRead";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static interface FieldPersistence {
            public String[] formatWrite(@NotNull PsiField var1, @NotNull String var2, @NotNull String var3);

            public String[] formatRead(@NotNull PsiField var1, @NotNull String var2);
        }
    }

    public static enum Operation {
        IMPLEMENT,
        REMOVE,
        REIMPLEMENT;

    }
}

