/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.lint.detector.api.Position;

public abstract class LintIdePosition
extends Position {
    private final int myOffset;
    protected int myLine;
    protected int myColumn;
    private boolean myInitialized;

    public LintIdePosition(int offset) {
        this.myOffset = offset;
    }

    public int getOffset() {
        return this.myOffset;
    }

    public int getLine() {
        this.ensureLineInitialized();
        return this.myLine;
    }

    public int getColumn() {
        this.ensureLineInitialized();
        return this.myColumn;
    }

    private void ensureLineInitialized() {
        if (this.myInitialized) {
            return;
        }
        this.myInitialized = true;
        this.initializeLineColumn();
    }

    protected abstract void initializeLineColumn();

    protected void initializeFromText(String contents) {
        int offset = this.myOffset;
        this.myLine = 0;
        offset = Math.min(offset, contents.length());
        int lineOffset = 0;
        char prev = '\u0000';
        for (int currentOffset = 0; currentOffset < offset; ++currentOffset) {
            char c = contents.charAt(currentOffset);
            if (c == '\n') {
                lineOffset = currentOffset + 1;
                if (prev != '\r') {
                    ++this.myLine;
                }
            } else if (c == '\r') {
                ++this.myLine;
                lineOffset = currentOffset + 1;
            }
            prev = c;
        }
        this.myColumn = offset - lineOffset;
    }
}

