/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.instantapp.provision;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.instantapp.provision.ProvisionException;
import com.android.instantapp.provision.ProvisionListener;
import com.android.instantapp.provision.ProvisionRunner;
import com.android.tools.idea.instantapp.InstantApps;
import com.android.tools.idea.instantapp.provision.ProvisionEditTaskDialog;
import com.android.tools.idea.run.AndroidRunConfigContext;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.DeviceFutures;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import icons.AndroidIcons;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProvisionBeforeRunTaskProvider
extends BeforeRunTaskProvider<ProvisionBeforeRunTask> {
    @NotNull
    public static final Key<ProvisionBeforeRunTask> ID = Key.create((String)"com.android.instantApps.provision.BeforeRunTask");
    @NotNull
    private static final String TASK_NAME = "Instant App Provision";

    @NotNull
    public Key<ProvisionBeforeRunTask> getId() {
        Key<ProvisionBeforeRunTask> key = ID;
        if (key == null) {
            ProvisionBeforeRunTaskProvider.$$$reportNull$$$0(0);
        }
        return key;
    }

    @NotNull
    public String getName() {
        if (TASK_NAME == null) {
            ProvisionBeforeRunTaskProvider.$$$reportNull$$$0(1);
        }
        return TASK_NAME;
    }

    @NotNull
    public String getDescription(ProvisionBeforeRunTask task) {
        if (TASK_NAME == null) {
            ProvisionBeforeRunTaskProvider.$$$reportNull$$$0(2);
        }
        return TASK_NAME;
    }

    @Nullable
    public Icon getIcon() {
        return AndroidIcons.Android;
    }

    @Nullable
    public Icon getTaskIcon(ProvisionBeforeRunTask task) {
        return AndroidIcons.Android;
    }

    public boolean isSingleton() {
        return true;
    }

    public boolean isConfigurable() {
        return true;
    }

    @Nullable
    public ProvisionBeforeRunTask createTask(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            ProvisionBeforeRunTaskProvider.$$$reportNull$$$0(3);
        }
        if (runConfiguration instanceof AndroidRunConfigurationBase && InstantApps.isInstantAppSdkEnabled()) {
            ProvisionBeforeRunTask task = new ProvisionBeforeRunTask(runConfiguration.getProject());
            task.setEnabled(true);
            return task;
        }
        return null;
    }

    public boolean configureTask(@NotNull RunConfiguration runConfiguration, @NotNull ProvisionBeforeRunTask task) {
        ProvisionEditTaskDialog dialog;
        if (runConfiguration == null) {
            ProvisionBeforeRunTaskProvider.$$$reportNull$$$0(4);
        }
        if (task == null) {
            ProvisionBeforeRunTaskProvider.$$$reportNull$$$0(5);
        }
        if (!(dialog = new ProvisionEditTaskDialog(runConfiguration.getProject(), task.isClearCache(), task.isClearProvisionedDevices())).showAndGet()) {
            return false;
        }
        task.setClearCache(dialog.isClearCache());
        task.setClearProvisionedDevices(dialog.isClearProvisionedDevices());
        return true;
    }

    public boolean canExecuteTask(@NotNull RunConfiguration configuration, @NotNull ProvisionBeforeRunTask task) {
        if (configuration == null) {
            ProvisionBeforeRunTaskProvider.$$$reportNull$$$0(6);
        }
        if (task == null) {
            ProvisionBeforeRunTaskProvider.$$$reportNull$$$0(7);
        }
        return this.isInstantAppContext((AndroidRunConfigurationBase)configuration);
    }

    public boolean executeTask(DataContext context, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment env, final @NotNull ProvisionBeforeRunTask task) {
        DeviceFutures deviceFutures;
        if (configuration == null) {
            ProvisionBeforeRunTaskProvider.$$$reportNull$$$0(8);
        }
        if (env == null) {
            ProvisionBeforeRunTaskProvider.$$$reportNull$$$0(9);
        }
        if (task == null) {
            ProvisionBeforeRunTaskProvider.$$$reportNull$$$0(10);
        }
        if (!this.isInstantAppContext((AndroidRunConfigurationBase)configuration)) {
            return true;
        }
        AndroidRunConfigContext runConfigContext = (AndroidRunConfigContext)env.getCopyableUserData(AndroidRunConfigContext.KEY);
        DeviceFutures deviceFutures2 = deviceFutures = runConfigContext == null ? null : runConfigContext.getTargetDevices();
        if (deviceFutures == null) {
            return false;
        }
        ProgressManager progressManager = ProgressManager.getInstance();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final AtomicBoolean result = new AtomicBoolean(true);
        progressManager.run((Task)new Task.Backgroundable(configuration.getProject(), this.getDescription(task), true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(final @NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                AtomicBoolean tryAgain = new AtomicBoolean(true);
                try {
                    ProvisionRunner provisionRunner = new ProvisionRunner(InstantApps.getInstantAppSdk(), new ProvisionListener(){

                        public void printMessage(String message) {
                            indicator.setText2(message);
                        }

                        public void logMessage(String message, ProvisionException e) {
                            if (e == null) {
                                ProvisionBeforeRunTaskProvider.getLogger().info(message);
                            } else {
                                ProvisionBeforeRunTaskProvider.getLogger().warn(message, (Throwable)e);
                            }
                        }

                        public void setProgress(double fraction) {
                            indicator.setFraction(fraction);
                        }

                        public boolean isCancelled() {
                            return indicator.isCanceled();
                        }
                    });
                    indicator.setIndeterminate(true);
                    indicator.setText("Provisioning device");
                    if (task.isClearProvisionedDevices()) {
                        task.clearProvisionedDevices();
                    }
                    while (tryAgain.get()) {
                        try {
                            for (ListenableFuture<IDevice> deviceListenableFuture : deviceFutures.get()) {
                                IDevice device = ProvisionBeforeRunTaskProvider.waitForDevice((ListenableFuture<IDevice>)deviceListenableFuture, indicator);
                                if (device == null) {
                                    result.set(false);
                                    return;
                                }
                                if (task.isProvisioned(device)) continue;
                                indicator.setIndeterminate(false);
                                provisionRunner.runProvision(device);
                                if (task.isClearCache()) {
                                    try {
                                        device.executeShellCommand("pm clear com.google.android.instantapps.supervisor", NullOutputReceiver.getReceiver());
                                        device.executeShellCommand("pm clear com.google.android.instantapps.devman", NullOutputReceiver.getReceiver());
                                    }
                                    catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | com.android.ddmlib.TimeoutException | IOException e) {
                                        ProvisionBeforeRunTaskProvider.getLogger().warn("Error while clearing supervisor or devman cache on device", e);
                                    }
                                }
                                task.addProvisionedDevice(device);
                            }
                            tryAgain.set(false);
                        }
                        catch (ProvisionException e) {
                            ApplicationManager.getApplication().invokeAndWait(() -> {
                                int choice = Messages.showYesNoDialog((String)("Provision failed with message: " + e.getMessage() + " Do you want to retry?"), (String)"Instant Apps", null);
                                if (choice == 0) {
                                    provisionRunner.clearCache();
                                } else {
                                    if (e.getErrorType() != ProvisionException.ErrorType.NO_GOOGLE_ACCOUNT && e.getErrorType() != ProvisionException.ErrorType.CANCELLED) {
                                        ProvisionBeforeRunTaskProvider.getLogger().error((Throwable)e);
                                    }
                                    tryAgain.set(false);
                                    result.set(false);
                                }
                            });
                        }
                    }
                    return;
                }
                catch (FileNotFoundException e) {
                    result.set(false);
                    return;
                }
                catch (ProvisionException e) {
                    ProvisionBeforeRunTaskProvider.getLogger().error("Error while provisioning devices", (Throwable)e);
                    result.set(false);
                    return;
                }
                finally {
                    countDownLatch.countDown();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/instantapp/provision/ProvisionBeforeRunTaskProvider$1", "run"));
            }
        });
        try {
            return countDownLatch.await(deviceFutures.get().size() * 300, TimeUnit.SECONDS) && result.get();
        }
        catch (InterruptedException e) {
            ProvisionBeforeRunTaskProvider.getLogger().error("Background thread interrupted", (Throwable)e);
            return false;
        }
    }

    @VisibleForTesting
    boolean isInstantAppContext(@NotNull AndroidRunConfigurationBase runConfiguration) {
        if (runConfiguration == null) {
            ProvisionBeforeRunTaskProvider.$$$reportNull$$$0(11);
        }
        Module module = ((JavaRunConfigurationModule)runConfiguration.getConfigurationModule()).getModule();
        return InstantApps.isInstantAppSdkEnabled() && module != null && InstantApps.isInstantAppApplicationModule(module);
    }

    @Nullable
    private static IDevice waitForDevice(@NotNull ListenableFuture<IDevice> deviceFuture, @NotNull ProgressIndicator indicator) {
        if (deviceFuture == null) {
            ProvisionBeforeRunTaskProvider.$$$reportNull$$$0(12);
        }
        if (indicator == null) {
            ProvisionBeforeRunTaskProvider.$$$reportNull$$$0(13);
        }
        while (true) {
            try {
                return (IDevice)deviceFuture.get(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException e) {
                return null;
            }
            catch (TimeoutException timeoutException) {
                if (!indicator.isCanceled()) continue;
                return null;
            }
            break;
        }
    }

    private static Logger getLogger() {
        return Logger.getInstance(ProvisionBeforeRunTaskProvider.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/instantapp/provision/ProvisionBeforeRunTaskProvider";
                break;
            }
            case 3: 
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceFuture";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/instantapp/provision/ProvisionBeforeRunTaskProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createTask";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "configureTask";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canExecuteTask";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "executeTask";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isInstantAppContext";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "waitForDevice";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ProvisionBeforeRunTask
    extends BeforeRunTask<ProvisionBeforeRunTask> {
        @NotNull
        private static final String TIMESTAMP_PROPERTY_NAME = ProvisionBeforeRunTaskProvider.class.getName() + ".myTimeStamp";
        private static final ImmutableList<String> INSTANT_APP_PACKAGES = ImmutableList.of((Object)"com.google.android.instantapps.supervisor", (Object)"com.google.android.instantapps.devman");
        private boolean myClearCache;
        private boolean myClearProvisionedDevices;
        private long myTimestamp;
        @NotNull
        private final Project myProject;
        @NotNull
        private final Set<String> myProvisionedDevices;

        public ProvisionBeforeRunTask(@NotNull Project project) {
            if (project == null) {
                ProvisionBeforeRunTask.$$$reportNull$$$0(0);
            }
            super(ID);
            this.myProject = project;
            this.myClearCache = false;
            this.myTimestamp = 0L;
            this.myClearProvisionedDevices = false;
            this.myProvisionedDevices = new HashSet<String>();
        }

        @VisibleForTesting
        void setClearCache(boolean clearCache) {
            this.myClearCache = clearCache;
        }

        @VisibleForTesting
        boolean isClearCache() {
            return this.myClearCache;
        }

        @VisibleForTesting
        void setClearProvisionedDevices(boolean clearProvisionedDevices) {
            this.myClearProvisionedDevices = clearProvisionedDevices;
        }

        @VisibleForTesting
        boolean isClearProvisionedDevices() {
            return this.myClearProvisionedDevices;
        }

        private void addProvisionedDevice(@NotNull String deviceSerial) {
            if (deviceSerial == null) {
                ProvisionBeforeRunTask.$$$reportNull$$$0(1);
            }
            this.myProvisionedDevices.add(deviceSerial);
        }

        @VisibleForTesting
        void addProvisionedDevice(@NotNull IDevice device) {
            if (device == null) {
                ProvisionBeforeRunTask.$$$reportNull$$$0(2);
            }
            this.addProvisionedDevice(ProvisionBeforeRunTask.getHash(device));
        }

        @VisibleForTesting
        boolean isProvisioned(@NotNull IDevice device) {
            if (device == null) {
                ProvisionBeforeRunTask.$$$reportNull$$$0(3);
            }
            if (!this.myProvisionedDevices.contains(ProvisionBeforeRunTask.getHash(device))) {
                return false;
            }
            for (String pkgName : INSTANT_APP_PACKAGES) {
                if (this.isPackageInstalled(device, pkgName)) continue;
                return false;
            }
            return true;
        }

        @NotNull
        private static String getHash(@NotNull IDevice device) {
            if (device == null) {
                ProvisionBeforeRunTask.$$$reportNull$$$0(4);
            }
            if (device.getAvdName() != null) {
                String string = device.getSerialNumber() + device.getAvdName();
                if (string == null) {
                    ProvisionBeforeRunTask.$$$reportNull$$$0(5);
                }
                return string;
            }
            String string = device.getSerialNumber();
            if (string == null) {
                ProvisionBeforeRunTask.$$$reportNull$$$0(6);
            }
            return string;
        }

        @VisibleForTesting
        boolean isPackageInstalled(IDevice device, String pkgName) {
            CountDownLatch latch = new CountDownLatch(1);
            CollectingOutputReceiver receiver = new CollectingOutputReceiver(latch);
            try {
                device.executeShellCommand("pm path " + pkgName, (IShellOutputReceiver)receiver);
                if (!latch.await(500L, TimeUnit.MILLISECONDS)) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
            return !receiver.getOutput().isEmpty();
        }

        private void clearProvisionedDevices() {
            this.myProvisionedDevices.clear();
        }

        @VisibleForTesting
        long getTimestamp() {
            return this.myTimestamp;
        }

        public void writeExternal(@NotNull Element element) {
            if (element == null) {
                ProvisionBeforeRunTask.$$$reportNull$$$0(7);
            }
            super.writeExternal(element);
            element.setAttribute("clearCache", String.valueOf(this.myClearCache));
            element.setAttribute("clearProvisionedDevices", String.valueOf(this.myClearProvisionedDevices));
            for (String deviceId : this.myProvisionedDevices) {
                element.addContent(new Element("provisionedDevices").setAttribute("provisionedDevice", deviceId));
            }
            PropertiesComponent.getInstance((Project)this.myProject).setValue(TIMESTAMP_PROPERTY_NAME, Long.toString(System.currentTimeMillis()));
        }

        public void readExternal(@NotNull Element element) {
            if (element == null) {
                ProvisionBeforeRunTask.$$$reportNull$$$0(8);
            }
            super.readExternal(element);
            this.myClearCache = Boolean.valueOf(element.getAttributeValue("clearCache"));
            this.myClearProvisionedDevices = Boolean.valueOf(element.getAttributeValue("clearProvisionedDevices"));
            List children = element.getChildren("provisionedDevices");
            for (Element child : children) {
                this.addProvisionedDevice(child.getAttributeValue("provisionedDevice"));
            }
            try {
                this.myTimestamp = Long.parseLong(PropertiesComponent.getInstance((Project)this.myProject).getValue(TIMESTAMP_PROPERTY_NAME));
            }
            catch (NumberFormatException e) {
                this.myTimestamp = 0L;
            }
            long timeDiff = System.currentTimeMillis() - this.myTimestamp;
            if (this.myTimestamp != 0L && (timeDiff < 0L || timeDiff > 3600000L)) {
                this.clearProvisionedDevices();
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ProvisionBeforeRunTask that = (ProvisionBeforeRunTask)((Object)o);
            return this.myClearCache == that.myClearCache && this.myClearProvisionedDevices == that.myClearProvisionedDevices && this.myTimestamp == that.myTimestamp && Objects.equals(this.myProvisionedDevices, that.myProvisionedDevices);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.myClearCache, this.myClearProvisionedDevices, this.myTimestamp, this.myProvisionedDevices);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deviceSerial";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "device";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/instantapp/provision/ProvisionBeforeRunTaskProvider$ProvisionBeforeRunTask";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/instantapp/provision/ProvisionBeforeRunTaskProvider$ProvisionBeforeRunTask";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHash";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addProvisionedDevice";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isProvisioned";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getHash";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "writeExternal";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "readExternal";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

