/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.view;

import com.android.builder.model.level2.Library;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.ui.LabeledComboBoxAction;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.mxgraph.canvas.mxICanvas;
import com.mxgraph.canvas.mxImageCanvas;
import com.mxgraph.layout.mxCircleLayout;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxGraphTransferable;
import com.mxgraph.swing.view.mxInteractiveCanvas;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

class ModuleVariantsInfoGraph
extends DialogWrapper {
    @NotNull
    private final Module myModule;
    @NotNull
    private final AndroidModuleModel myAndroidModel;
    @NotNull
    private IdeVariant mySelectedVariant;
    private mxGraphComponent myGraphComponent;
    private VariantGraph myGraph;

    ModuleVariantsInfoGraph(@NotNull Module module) {
        if (module == null) {
            ModuleVariantsInfoGraph.$$$reportNull$$$0(0);
        }
        super(module.getProject());
        this.myModule = module;
        AndroidModuleModel androidModel = AndroidModuleModel.get(this.myModule);
        assert (androidModel != null);
        this.myAndroidModel = androidModel;
        this.mySelectedVariant = this.myAndroidModel.getSelectedVariant();
        this.setTitle(String.format("Dependency Details for Module '%1$s'", this.myModule.getName()));
        this.init();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setPreferredSize((Dimension)JBUI.size((int)600, (int)400));
        DefaultActionGroup group = new DefaultActionGroup(new AnAction[]{new VariantsComboBoxAction(), Separator.getInstance(), new ResetLayoutAction(), new ShowGridAction(), Separator.getInstance(), new ZoomInAction(), new ZoomOutAction(), new ZoomActualAction()});
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("TOP", (ActionGroup)group, true);
        mainPanel.add((Component)toolbar.getComponent(), "North");
        this.myGraph = new VariantGraph();
        this.myGraphComponent = new mxGraphComponent(this.myGraph){

            public mxInteractiveCanvas createCanvas() {
                return new CustomCanvas(ModuleVariantsInfoGraph.this.myModule.getProject(), this);
            }
        };
        this.myGraphComponent.setGridVisible(true);
        this.myGraphComponent.setToolTips(false);
        mainPanel.add((Component)this.myGraphComponent, "Center");
        this.myGraph.render(this.myModule, this.myAndroidModel, this.mySelectedVariant);
        JPanel jPanel = mainPanel;
        if (jPanel == null) {
            ModuleVariantsInfoGraph.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/variant/view/ModuleVariantsInfoGraph";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/variant/view/ModuleVariantsInfoGraph";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ZoomActualAction
    extends DumbAwareAction {
        ZoomActualAction() {
            super("Actual Size", null, AllIcons.Graph.ActualZoom);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ZoomActualAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(ModuleVariantsInfoGraph.this.myGraphComponent != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ZoomActualAction.$$$reportNull$$$0(1);
            }
            if (ModuleVariantsInfoGraph.this.myGraphComponent != null) {
                ModuleVariantsInfoGraph.this.myGraphComponent.zoomActual();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/android/tools/idea/gradle/variant/view/ModuleVariantsInfoGraph$ZoomActualAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ZoomOutAction
    extends DumbAwareAction {
        ZoomOutAction() {
            super("Zoom Out", null, AllIcons.Graph.ZoomOut);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ZoomOutAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(ModuleVariantsInfoGraph.this.myGraphComponent != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ZoomOutAction.$$$reportNull$$$0(1);
            }
            if (ModuleVariantsInfoGraph.this.myGraphComponent != null) {
                ModuleVariantsInfoGraph.this.myGraphComponent.zoomOut();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/android/tools/idea/gradle/variant/view/ModuleVariantsInfoGraph$ZoomOutAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ZoomInAction
    extends DumbAwareAction {
        ZoomInAction() {
            super("Zoom In", null, AllIcons.Graph.ZoomIn);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ZoomInAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(ModuleVariantsInfoGraph.this.myGraphComponent != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ZoomInAction.$$$reportNull$$$0(1);
            }
            if (ModuleVariantsInfoGraph.this.myGraphComponent != null) {
                ModuleVariantsInfoGraph.this.myGraphComponent.zoomIn();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/android/tools/idea/gradle/variant/view/ModuleVariantsInfoGraph$ZoomInAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ResetLayoutAction
    extends DumbAwareAction {
        ResetLayoutAction() {
            super("Reset Layout", null, AllIcons.Graph.Layout);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ResetLayoutAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(ModuleVariantsInfoGraph.this.myGraph != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ResetLayoutAction.$$$reportNull$$$0(1);
            }
            if (ModuleVariantsInfoGraph.this.myGraph != null) {
                ModuleVariantsInfoGraph.this.myGraph.resetLayout();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/android/tools/idea/gradle/variant/view/ModuleVariantsInfoGraph$ResetLayoutAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ShowGridAction
    extends ToggleAction {
        ShowGridAction() {
            super("Show/Hide Grid", null, AllIcons.Graph.Grid);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowGridAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            e.getPresentation().setEnabled(ModuleVariantsInfoGraph.this.myGraphComponent != null);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowGridAction.$$$reportNull$$$0(1);
            }
            return ModuleVariantsInfoGraph.this.myGraphComponent != null && ModuleVariantsInfoGraph.this.myGraphComponent.isGridVisible();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ShowGridAction.$$$reportNull$$$0(2);
            }
            if (ModuleVariantsInfoGraph.this.myGraphComponent != null) {
                ModuleVariantsInfoGraph.this.myGraphComponent.setGridVisible(state);
                ModuleVariantsInfoGraph.this.myGraphComponent.refresh();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/android/tools/idea/gradle/variant/view/ModuleVariantsInfoGraph$ShowGridAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class VariantSelectionAction
    extends DumbAwareAction {
        @NotNull
        private final IdeVariant myVariant;

        VariantSelectionAction(IdeVariant variant) {
            if (variant == null) {
                VariantSelectionAction.$$$reportNull$$$0(0);
            }
            super(variant.getName());
            this.myVariant = variant;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                VariantSelectionAction.$$$reportNull$$$0(1);
            }
            ModuleVariantsInfoGraph.this.mySelectedVariant = this.myVariant;
            ModuleVariantsInfoGraph.this.myGraph.render(ModuleVariantsInfoGraph.this.myModule, ModuleVariantsInfoGraph.this.myAndroidModel, ModuleVariantsInfoGraph.this.mySelectedVariant);
            ModuleVariantsInfoGraph.this.myGraphComponent.refresh();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variant";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/gradle/variant/view/ModuleVariantsInfoGraph$VariantSelectionAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class VariantsComboBoxAction
    extends LabeledComboBoxAction {
        VariantsComboBoxAction() {
            super("Variant: ");
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                VariantsComboBoxAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setText(ModuleVariantsInfoGraph.this.mySelectedVariant.getName());
        }

        @NotNull
        protected DefaultActionGroup createPopupActionGroup(JComponent button) {
            ArrayList actions2 = Lists.newArrayList();
            ModuleVariantsInfoGraph.this.myAndroidModel.getAndroidProject().forEachVariant(variant -> actions2.add(new VariantSelectionAction((IdeVariant)variant)));
            DefaultActionGroup defaultActionGroup = new DefaultActionGroup((List)actions2);
            if (defaultActionGroup == null) {
                VariantsComboBoxAction.$$$reportNull$$$0(1);
            }
            return defaultActionGroup;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/variant/view/ModuleVariantsInfoGraph$VariantsComboBoxAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/variant/view/ModuleVariantsInfoGraph$VariantsComboBoxAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPopupActionGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class CustomCanvas
    extends mxInteractiveCanvas {
        @NotNull
        private final Project myProject;
        @NotNull
        private final mxGraphComponent myGraphComponent;
        @NotNull
        private final JBLabel myVertexRenderer;

        CustomCanvas(@NotNull Project project, @NotNull mxGraphComponent graphComponent) {
            if (project == null) {
                CustomCanvas.$$$reportNull$$$0(0);
            }
            if (graphComponent == null) {
                CustomCanvas.$$$reportNull$$$0(1);
            }
            this.myVertexRenderer = new JBLabel();
            this.myProject = project;
            this.myGraphComponent = graphComponent;
            this.myVertexRenderer.setOpaque(true);
            this.myVertexRenderer.setBackground(JBColor.background());
            this.myVertexRenderer.setForeground(JBColor.foreground());
            this.myVertexRenderer.setBorder(BorderFactory.createLineBorder(JBColor.border(), 1));
            this.myVertexRenderer.setHorizontalTextPosition(4);
            this.myVertexRenderer.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        }

        void drawVertex(@NotNull mxCellState cellState, boolean drawLabel) {
            String text;
            if (cellState == null) {
                CustomCanvas.$$$reportNull$$$0(2);
            }
            mxCell cell = (mxCell)cellState.getCell();
            Object value = cell.getValue();
            Icon icon = null;
            if (value instanceof ModuleVertexModel) {
                ModuleVertexModel model = (ModuleVertexModel)value;
                text = drawLabel ? model.name : "";
                Module module = ModuleManager.getInstance((Project)this.myProject).findModuleByName(model.name);
                assert (module != null);
                icon = GradleUtil.getModuleIcon(module);
            } else {
                text = drawLabel ? cellState.getLabel() : "";
            }
            int w = (int)cellState.getWidth();
            int h = (int)cellState.getHeight();
            float scale = JBUI.scale((float)((float)this.getScale()));
            float defaultFontSize = UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL);
            Font newFont = this.myVertexRenderer.getFont().deriveFont(defaultFontSize * scale);
            this.myVertexRenderer.setFont(newFont);
            if (icon instanceof ScalableIcon) {
                ScalableIcon scalableIcon = (ScalableIcon)icon;
                icon = scalableIcon.scale(scale);
            }
            this.myVertexRenderer.setText(text);
            this.myVertexRenderer.setIcon(icon);
            this.myVertexRenderer.setSize(w, h);
            this.rendererPane.paintComponent(this.g, (Component)this.myVertexRenderer, (Container)this.myGraphComponent, (int)cellState.getX() + this.translate.x, (int)cellState.getY() + this.translate.y, w, h, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "graphComponent";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cellState";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/gradle/variant/view/ModuleVariantsInfoGraph$CustomCanvas";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "drawVertex";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ModuleVertexModel
    implements Serializable {
        @NotNull
        String name;

        ModuleVertexModel(@NotNull String name) {
            if (name == null) {
                ModuleVertexModel.$$$reportNull$$$0(0);
            }
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/variant/view/ModuleVariantsInfoGraph$ModuleVertexModel", "<init>"));
        }
    }

    private static class VariantGraph
    extends mxGraph {
        private static final double VERTEX_WIDTH = 100.0;
        private static final double VERTEX_HEIGHT = 30.0;

        VariantGraph() {
            this.setCellsCloneable(false);
            this.setCellsDeletable(false);
            this.setCellsDisconnectable(false);
            this.setCellsEditable(false);
            this.setCellsResizable(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void render(@NotNull Module module, @NotNull AndroidModuleModel androidModel, @NotNull IdeVariant variant) {
            if (module == null) {
                VariantGraph.$$$reportNull$$$0(0);
            }
            if (androidModel == null) {
                VariantGraph.$$$reportNull$$$0(1);
            }
            if (variant == null) {
                VariantGraph.$$$reportNull$$$0(2);
            }
            this.setModel((mxIGraphModel)new mxGraphModel());
            mxIGraphModel model = this.getModel();
            model.beginUpdate();
            try {
                mxCell parent = (mxCell)this.getDefaultParent();
                mxCell moduleVertex = this.createVertex(module);
                moduleVertex.setConnectable(false);
                for (Library library : GradleUtil.getModuleDependencies(variant)) {
                    Module dependency;
                    String gradlePath = library.getProjectPath();
                    if (gradlePath == null || (dependency = GradleUtil.findModuleByGradlePath(module.getProject(), gradlePath)) == null) continue;
                    mxCell dependencyVertex = this.createVertex(dependency);
                    dependencyVertex.setConnectable(false);
                    String projectVariant = StringUtil.notNullize((String)library.getVariant());
                    this.insertEdge(parent, null, projectVariant, moduleVertex, dependencyVertex);
                }
            }
            finally {
                model.endUpdate();
            }
            this.resetLayout();
        }

        @NotNull
        private mxCell createVertex(@NotNull Module module) {
            if (module == null) {
                VariantGraph.$$$reportNull$$$0(3);
            }
            ModuleVertexModel model = new ModuleVertexModel(module.getName());
            mxCell mxCell2 = (mxCell)this.insertVertex(this.getDefaultParent(), null, model, 0.0, 0.0, 100.0, 30.0);
            if (mxCell2 == null) {
                VariantGraph.$$$reportNull$$$0(4);
            }
            return mxCell2;
        }

        void resetLayout() {
            mxCircleLayout layout = new mxCircleLayout((mxGraph)this);
            layout.setDisableEdgeStyle(false);
            layout.execute(this.getDefaultParent());
        }

        public void drawState(mxICanvas canvas, mxCellState state, boolean drawLabel) {
            mxIGraphModel model = this.getModel();
            boolean vertex = model.isVertex(state.getCell());
            if (vertex && canvas instanceof mxImageCanvas && ((mxImageCanvas)canvas).getGraphicsCanvas() != null) {
                ((CustomCanvas)((mxImageCanvas)canvas).getGraphicsCanvas()).drawVertex(state, drawLabel);
                return;
            }
            if (vertex && canvas instanceof CustomCanvas) {
                ((CustomCanvas)canvas).drawVertex(state, drawLabel);
                return;
            }
            super.drawState(canvas, state, drawLabel);
        }

        static {
            mxGraphTransferable.enableImageSupport = false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "androidModel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variant";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/variant/view/ModuleVariantsInfoGraph$VariantGraph";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/variant/view/ModuleVariantsInfoGraph$VariantGraph";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createVertex";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "render";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createVertex";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

