/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.util.ProxySettings;
import com.android.tools.idea.util.PropertiesFiles;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleProperties {
    @NonNls
    private static final String JVM_ARGS_PROPERTY_NAME = "org.gradle.jvmargs";
    @NotNull
    private final File myPath;
    private final Properties myProperties;

    public GradleProperties(@NotNull Project project) throws IOException {
        if (project == null) {
            GradleProperties.$$$reportNull$$$0(0);
        }
        this(new File(Projects.getBaseDirPath((Project)project), "gradle.properties"));
    }

    public GradleProperties(@NotNull File path) throws IOException {
        if (path == null) {
            GradleProperties.$$$reportNull$$$0(1);
        }
        this.myPath = path;
        this.myProperties = PropertiesFiles.getProperties(this.myPath);
    }

    @VisibleForTesting
    String getProperty(@NotNull String name) {
        if (name == null) {
            GradleProperties.$$$reportNull$$$0(2);
        }
        return this.myProperties.getProperty(name);
    }

    @NotNull
    public ProxySettings getHttpProxySettings() {
        ProxySettings proxySettings = new ProxySettings(this.myProperties, "http");
        if (proxySettings == null) {
            GradleProperties.$$$reportNull$$$0(3);
        }
        return proxySettings;
    }

    @NotNull
    public ProxySettings getHttpsProxySettings() {
        ProxySettings proxySettings = new ProxySettings(this.myProperties, "https");
        if (proxySettings == null) {
            GradleProperties.$$$reportNull$$$0(4);
        }
        return proxySettings;
    }

    public void save() throws IOException {
        PropertiesFiles.savePropertiesToFile(this.myProperties, this.myPath, GradleProperties.getHeaderComment());
    }

    @NotNull
    private static String getHeaderComment() {
        Object[] lines = new String[]{"# For more details on how to configure your build environment visit", "# http://www.gradle.org/docs/current/userguide/build_environment.html", "", "# Specifies the JVM arguments used for the daemon process.", "# The setting is particularly useful for tweaking memory settings.", "# Default value: -Xmx1024m -XX:MaxPermSize=256m", "# org.gradle.jvmargs=-Xmx2048m -XX:MaxPermSize=512m -XX:+HeapDumpOnOutOfMemoryError -Dfile.encoding=UTF-8", "", "# When configured, Gradle will run in incubating parallel mode.", "# This option should only be used with decoupled projects. More details, visit", "# http://www.gradle.org/docs/current/userguide/multi_project_builds.html#sec:decoupled_projects", "# org.gradle.parallel=true"};
        String string = Joiner.on((String)SystemProperties.getLineSeparator()).join(lines);
        if (string == null) {
            GradleProperties.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void setJvmArgs(@NotNull String jvmArgs) {
        if (jvmArgs == null) {
            GradleProperties.$$$reportNull$$$0(6);
        }
        this.myProperties.setProperty(JVM_ARGS_PROPERTY_NAME, jvmArgs);
    }

    public void clear() {
        this.myProperties.clear();
    }

    @Nullable
    public String getJvmArgs() {
        return this.myProperties.getProperty(JVM_ARGS_PROPERTY_NAME);
    }

    public Properties getProperties() {
        return this.myProperties;
    }

    @NotNull
    public File getPath() {
        File file = this.myPath;
        if (file == null) {
            GradleProperties.$$$reportNull$$$0(7);
        }
        return file;
    }

    @NotNull
    public static File getUserGradlePropertiesFile() {
        String home = System.getProperty("user.home");
        File file = new File(new File(home), FileUtil.toSystemDependentName((String)".gradle/gradle.properties"));
        if (file == null) {
            GradleProperties.$$$reportNull$$$0(8);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/util/GradleProperties";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmArgs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/util/GradleProperties";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHttpProxySettings";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHttpsProxySettings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderComment";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserGradlePropertiesFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getProperty";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setJvmArgs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

