/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.utils.FileUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class BuildFileProcessor {
    @NotNull
    public static BuildFileProcessor getInstance() {
        BuildFileProcessor buildFileProcessor = (BuildFileProcessor)ServiceManager.getService(BuildFileProcessor.class);
        if (buildFileProcessor == null) {
            BuildFileProcessor.$$$reportNull$$$0(0);
        }
        return buildFileProcessor;
    }

    public void processRecursively(@NotNull Project project, @NotNull Processor<GradleBuildModel> processor, boolean processCompositeBuilds) {
        if (project == null) {
            BuildFileProcessor.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            BuildFileProcessor.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            VirtualFile projectRootFolder;
            if (project == null) {
                BuildFileProcessor.$$$reportNull$$$0(8);
            }
            if (processor == null) {
                BuildFileProcessor.$$$reportNull$$$0(9);
            }
            if ((projectRootFolder = project.getBaseDir()) == null) {
                return;
            }
            ArrayList<VirtualFile> projectRootFolders = new ArrayList<VirtualFile>();
            projectRootFolders.add(projectRootFolder);
            if (processCompositeBuilds) {
                List<File> compositeBuildFolders = BuildFileProcessor.getCompositeBuildFolderPaths(project);
                projectRootFolders.addAll(compositeBuildFolders.stream().map(file -> VfsUtil.findFileByIoFile((File)file, (boolean)true)).filter(Objects::nonNull).collect(Collectors.toList()));
            }
            for (VirtualFile rootFolder : projectRootFolders) {
                VfsUtil.processFileRecursivelyWithoutIgnored((VirtualFile)rootFolder, virtualFile -> {
                    if (project == null) {
                        BuildFileProcessor.$$$reportNull$$$0(10);
                    }
                    if (processor == null) {
                        BuildFileProcessor.$$$reportNull$$$0(11);
                    }
                    if ("build.gradle".equals(virtualFile.getName())) {
                        GradleBuildModel buildModel = GradleBuildModel.parseBuildFile(virtualFile, project);
                        return processor.process((Object)buildModel);
                    }
                    return true;
                });
            }
        });
    }

    @NotNull
    public static List<File> getCompositeBuildFolderPaths(@NotNull Project project) {
        String projectBasePath;
        if (project == null) {
            BuildFileProcessor.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmpty((String)(projectBasePath = project.getBasePath()))) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                BuildFileProcessor.$$$reportNull$$$0(4);
            }
            return list;
        }
        GradleProjectSettings projectSettings = (GradleProjectSettings)GradleSettings.getInstance((Project)project).getLinkedProjectSettings(projectBasePath);
        if (projectSettings == null) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                BuildFileProcessor.$$$reportNull$$$0(5);
            }
            return list;
        }
        GradleProjectSettings.CompositeBuild compositeBuild = projectSettings.getCompositeBuild();
        if (compositeBuild == null) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                BuildFileProcessor.$$$reportNull$$$0(6);
            }
            return list;
        }
        List<File> list = compositeBuild.getCompositeParticipants().stream().map(p -> new File(FileUtils.toSystemDependentPath((String)p.getRootPath()))).collect(Collectors.toList());
        if (list == null) {
            BuildFileProcessor.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/util/BuildFileProcessor";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/util/BuildFileProcessor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompositeBuildFolderPaths";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processRecursively";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCompositeBuildFolderPaths";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processRecursively$2";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

