/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model;

import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.structure.model.PsModel;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.java.PsJavaModule;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsProject
extends PsModel {
    @NotNull
    private final Project myProject;
    @NotNull
    private final List<PsModule> myModules;
    private boolean myModified;

    public PsProject(@NotNull Project project) {
        if (project == null) {
            PsProject.$$$reportNull$$$0(0);
        }
        super(null);
        this.myModules = Lists.newArrayList();
        this.myProject = project;
        for (Module resolvedModel : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            String gradlePath = GradleUtil.getGradlePath(resolvedModel);
            GradleBuildModel parsedModel = GradleBuildModel.get(resolvedModel);
            if (gradlePath == null || parsedModel == null) continue;
            PsModule module = null;
            AndroidModuleModel gradleModel = AndroidModuleModel.get(resolvedModel);
            if (gradleModel != null) {
                module = new PsAndroidModule(this, resolvedModel, gradlePath, gradleModel, parsedModel);
            } else {
                JavaModuleModel javaModuleModel = JavaModuleModel.get(resolvedModel);
                if (javaModuleModel != null && javaModuleModel.isBuildable()) {
                    module = new PsJavaModule(this, resolvedModel, gradlePath, javaModuleModel, parsedModel);
                }
            }
            if (module == null) continue;
            this.myModules.add(module);
        }
    }

    @Nullable
    public PsModule findModuleByName(@NotNull String moduleName) {
        if (moduleName == null) {
            PsProject.$$$reportNull$$$0(1);
        }
        for (PsModule model : this.myModules) {
            if (!moduleName.equals(model.getName())) continue;
            return model;
        }
        return null;
    }

    @Nullable
    public PsModule findModuleByGradlePath(@NotNull String gradlePath) {
        if (gradlePath == null) {
            PsProject.$$$reportNull$$$0(2);
        }
        for (PsModule model : this.myModules) {
            if (!gradlePath.equals(model.getGradlePath())) continue;
            return model;
        }
        return null;
    }

    @NotNull
    public Project getResolvedModel() {
        Project project = this.myProject;
        if (project == null) {
            PsProject.$$$reportNull$$$0(3);
        }
        return project;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myProject.getName();
        if (string == null) {
            PsProject.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void forEachModule(@NotNull Consumer<PsModule> consumer) {
        if (consumer == null) {
            PsProject.$$$reportNull$$$0(5);
        }
        this.myModules.forEach(consumer);
    }

    @Override
    @Nullable
    public PsModel getParent() {
        return null;
    }

    @Override
    public boolean isDeclared() {
        return true;
    }

    @Override
    public boolean isModified() {
        return this.myModified;
    }

    @Override
    public void setModified(boolean value) {
        this.myModified = value;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return null;
    }

    public int getModelCount() {
        return this.myModules.size();
    }

    public void applyChanges() {
        this.forEachModule(PsModule::applyChanges);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradlePath";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/model/PsProject";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/model/PsProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findModuleByName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findModuleByGradlePath";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "forEachModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

