/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model;

import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.api.repositories.MavenRepositoryModel;
import com.android.tools.idea.gradle.dsl.api.repositories.RepositoryModel;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsChildModel;
import com.android.tools.idea.gradle.structure.model.PsDependency;
import com.android.tools.idea.gradle.structure.model.PsParsedDependencies;
import com.android.tools.idea.gradle.structure.model.PsProject;
import com.android.tools.idea.gradle.structure.model.repositories.search.ArtifactRepository;
import com.android.tools.idea.gradle.structure.model.repositories.search.JCenterRepository;
import com.android.tools.idea.gradle.structure.model.repositories.search.LocalMavenRepository;
import com.android.tools.idea.gradle.structure.model.repositories.search.MavenCentralRepository;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import icons.StudioIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsModule
extends PsChildModel {
    @Nullable
    private String myGradlePath;
    @Nullable
    private final Module myResolvedModel;
    private GradleBuildModel myParsedModel;
    private String myModuleName;
    private PsParsedDependencies myParsedDependencies;
    private final EventDispatcher<DependenciesChangeListener> myDependenciesChangeEventDispatcher;

    protected PsModule(@NotNull PsProject parent, @NotNull Module resolvedModel, @NotNull String gradlePath, @NotNull GradleBuildModel parsedModel) {
        if (parent == null) {
            PsModule.$$$reportNull$$$0(0);
        }
        if (resolvedModel == null) {
            PsModule.$$$reportNull$$$0(1);
        }
        if (gradlePath == null) {
            PsModule.$$$reportNull$$$0(2);
        }
        if (parsedModel == null) {
            PsModule.$$$reportNull$$$0(3);
        }
        super(parent);
        this.myDependenciesChangeEventDispatcher = EventDispatcher.create(DependenciesChangeListener.class);
        this.myResolvedModel = resolvedModel;
        this.myGradlePath = gradlePath;
        this.myModuleName = resolvedModel.getName();
        this.myParsedModel = parsedModel;
    }

    protected PsModule(@NotNull PsProject parent, @NotNull String name) {
        if (parent == null) {
            PsModule.$$$reportNull$$$0(4);
        }
        if (name == null) {
            PsModule.$$$reportNull$$$0(5);
        }
        super(parent);
        this.myDependenciesChangeEventDispatcher = EventDispatcher.create(DependenciesChangeListener.class);
        this.myResolvedModel = null;
        this.myModuleName = name;
    }

    @Override
    @NotNull
    public PsProject getParent() {
        PsProject psProject = (PsProject)super.getParent();
        if (psProject == null) {
            PsModule.$$$reportNull$$$0(6);
        }
        return psProject;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myModuleName;
        if (string == null) {
            PsModule.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    public boolean isDeclared() {
        return this.myParsedModel != null;
    }

    @NotNull
    public PsParsedDependencies getParsedDependencies() {
        PsParsedDependencies psParsedDependencies = this.myParsedDependencies == null ? (this.myParsedDependencies = new PsParsedDependencies(this.getParsedModel())) : this.myParsedDependencies;
        if (psParsedDependencies == null) {
            PsModule.$$$reportNull$$$0(8);
        }
        return psParsedDependencies;
    }

    @Nullable
    public GradleBuildModel getParsedModel() {
        return this.myParsedModel;
    }

    protected void addLibraryDependencyToParsedModel(@NotNull List<String> configurationNames, @NotNull String compactNotation) {
        GradleBuildModel parsedModel;
        if (configurationNames == null) {
            PsModule.$$$reportNull$$$0(9);
        }
        if (compactNotation == null) {
            PsModule.$$$reportNull$$$0(10);
        }
        if ((parsedModel = this.getParsedModel()) != null) {
            DependenciesModel dependencies = parsedModel.dependencies();
            configurationNames.forEach(configurationName -> {
                if (compactNotation == null) {
                    PsModule.$$$reportNull$$$0(18);
                }
                dependencies.addArtifact((String)configurationName, compactNotation);
            });
            this.getParsedDependencies().reset(this.getParsedModel());
        }
    }

    public void add(@NotNull DependenciesChangeListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            PsModule.$$$reportNull$$$0(11);
        }
        if (parentDisposable == null) {
            PsModule.$$$reportNull$$$0(12);
        }
        this.myDependenciesChangeEventDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    protected void fireLibraryDependencyAddedEvent(@NotNull PsArtifactDependencySpec spec) {
        if (spec == null) {
            PsModule.$$$reportNull$$$0(13);
        }
        ((DependenciesChangeListener)this.myDependenciesChangeEventDispatcher.getMulticaster()).dependencyChanged(new LibraryDependencyAddedEvent(spec));
    }

    public void fireDependencyModifiedEvent(@NotNull PsDependency dependency) {
        if (dependency == null) {
            PsModule.$$$reportNull$$$0(14);
        }
        ((DependenciesChangeListener)this.myDependenciesChangeEventDispatcher.getMulticaster()).dependencyChanged(new DependencyModifiedEvent(dependency));
    }

    @Nullable
    public String getGradlePath() {
        return this.myGradlePath;
    }

    @Nullable
    public Module getResolvedModel() {
        return this.myResolvedModel;
    }

    @Override
    public Icon getIcon() {
        return StudioIcons.Shell.Filetree.ANDROID_MODULE;
    }

    @NotNull
    public List<ArtifactRepository> getArtifactRepositories() {
        ArrayList repositories = Lists.newArrayList();
        this.populateRepositories(repositories);
        ArrayList arrayList = repositories;
        if (arrayList == null) {
            PsModule.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    protected final void populateRepositories(@NotNull List<ArtifactRepository> repositories) {
        GradleBuildModel parsedModel;
        if (repositories == null) {
            PsModule.$$$reportNull$$$0(16);
        }
        if ((parsedModel = this.getParsedModel()) != null) {
            for (RepositoryModel repositoryModel : parsedModel.repositories().repositories()) {
                switch (repositoryModel.getType()) {
                    case JCENTER_DEFAULT: {
                        repositories.add(new JCenterRepository());
                        break;
                    }
                    case MAVEN_CENTRAL: {
                        repositories.add(new MavenCentralRepository());
                        break;
                    }
                    case MAVEN: {
                        LocalMavenRepository localMavenRepository = PsModule.maybeCreateLocalMavenRepository((MavenRepositoryModel)repositoryModel);
                        if (localMavenRepository == null) break;
                        repositories.add(localMavenRepository);
                    }
                }
            }
        }
    }

    public boolean canDependOn(@NotNull PsModule module) {
        if (module == null) {
            PsModule.$$$reportNull$$$0(17);
        }
        return false;
    }

    public void applyChanges() {
        GradleBuildModel parsedModel;
        if (this.isModified() && (parsedModel = this.getParsedModel()) != null && parsedModel.isModified()) {
            String name = String.format("Applying changes to module '%1$s'", this.getName());
            new WriteCommandAction(this.getParent().getResolvedModel(), name, new PsiFile[0]){

                protected void run(@NotNull Result result) throws Throwable {
                    if (result == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    parsedModel.applyChanges();
                    PsModule.this.setModified(false);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/gradle/structure/model/PsModule$1", "run"));
                }
            }.execute();
        }
    }

    @Nullable
    private static LocalMavenRepository maybeCreateLocalMavenRepository(MavenRepositoryModel mavenRepositoryModel) {
        String repositoryPath;
        File repositoryRootFile;
        String repositoryUrl = mavenRepositoryModel.url().value();
        Url parsedRepositoryUrl = Urls.parse((String)repositoryUrl, (boolean)false);
        if (parsedRepositoryUrl != null && parsedRepositoryUrl.isInLocalFileSystem() && (repositoryRootFile = new File(repositoryPath = parsedRepositoryUrl.getPath())).isAbsolute()) {
            return new LocalMavenRepository(repositoryRootFile, mavenRepositoryModel.name().value());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradlePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parsedModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/model/PsModule";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationNames";
                break;
            }
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compactNotation";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/model/PsModule";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getParent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getParsedDependencies";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactRepositories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 15: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addLibraryDependencyToParsedModel";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "fireLibraryDependencyAddedEvent";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fireDependencyModifiedEvent";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "populateRepositories";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "canDependOn";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addLibraryDependencyToParsedModel$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DependencyModifiedEvent
    implements DependencyChangedEvent {
        @NotNull
        private final PsDependency myDependency;

        DependencyModifiedEvent(@NotNull PsDependency dependency) {
            if (dependency == null) {
                DependencyModifiedEvent.$$$reportNull$$$0(0);
            }
            this.myDependency = dependency;
        }

        @NotNull
        public PsDependency getDependency() {
            PsDependency psDependency = this.myDependency;
            if (psDependency == null) {
                DependencyModifiedEvent.$$$reportNull$$$0(1);
            }
            return psDependency;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependency";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/structure/model/PsModule$DependencyModifiedEvent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/structure/model/PsModule$DependencyModifiedEvent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependency";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class LibraryDependencyAddedEvent
    implements DependencyChangedEvent {
        @NotNull
        private final PsArtifactDependencySpec mySpec;

        LibraryDependencyAddedEvent(@NotNull PsArtifactDependencySpec spec) {
            if (spec == null) {
                LibraryDependencyAddedEvent.$$$reportNull$$$0(0);
            }
            this.mySpec = spec;
        }

        @NotNull
        public PsArtifactDependencySpec getSpec() {
            PsArtifactDependencySpec psArtifactDependencySpec = this.mySpec;
            if (psArtifactDependencySpec == null) {
                LibraryDependencyAddedEvent.$$$reportNull$$$0(1);
            }
            return psArtifactDependencySpec;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "spec";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/structure/model/PsModule$LibraryDependencyAddedEvent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/structure/model/PsModule$LibraryDependencyAddedEvent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSpec";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface DependencyChangedEvent {
    }

    public static interface DependenciesChangeListener
    extends EventListener {
        public void dependencyChanged(@NotNull DependencyChangedEvent var1);
    }
}

