/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.editors;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.plugin.AndroidPluginGeneration;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectStructureUsageTracker;
import com.android.tools.idea.gradle.structure.editors.DslNotSupportedPanel;
import com.android.tools.idea.gradle.structure.editors.GenericEditor;
import com.android.tools.idea.gradle.structure.editors.ModuleDependenciesPanel;
import com.android.tools.idea.gradle.structure.editors.NamedObjectPanel;
import com.android.tools.idea.gradle.structure.editors.SingleObjectPanel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.stats.AnonymizerUtil;
import com.google.common.collect.ImmutableList;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleConfigurationEditor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidModuleEditor
implements Place.Navigator,
Disposable {
    public static final ImmutableList<BuildFileKey> BUILD_FILE_GENERIC_PROPERTIES = ImmutableList.of((Object)((Object)BuildFileKey.COMPILE_SDK_VERSION), (Object)((Object)BuildFileKey.BUILD_TOOLS_VERSION), (Object)((Object)BuildFileKey.LIBRARY_REPOSITORY), (Object)((Object)BuildFileKey.IGNORE_ASSETS_PATTERN), (Object)((Object)BuildFileKey.INCREMENTAL_DEX), (Object)((Object)BuildFileKey.SOURCE_COMPATIBILITY), (Object)((Object)BuildFileKey.TARGET_COMPATIBILITY));
    private static final String SIGNING_TAB_TITLE = "Signing";
    private static final String BUILD_TYPES_TAB_TITLE = "Build Types";
    private static final String FLAVORS_TAB_TITLE = "Flavors";
    private final Project myProject;
    private final String myName;
    private final List<ModuleConfigurationEditor> myEditors;
    private JBTabbedPane myTabbedPane;
    private JComponent myGenericSettingsPanel;

    public AndroidModuleEditor(@NotNull Project project, @NotNull String moduleName) {
        if (project == null) {
            AndroidModuleEditor.$$$reportNull$$$0(0);
        }
        if (moduleName == null) {
            AndroidModuleEditor.$$$reportNull$$$0(1);
        }
        this.myEditors = new ArrayList<ModuleConfigurationEditor>();
        this.myProject = project;
        this.myName = moduleName;
    }

    @NotNull
    public JComponent getPanel() {
        Module module = GradleUtil.findModuleByGradlePath(this.myProject, this.myName);
        if (module == null || GradleUtil.getGradleBuildFile(module) == null) {
            JPanel jPanel = new JPanel();
            if (jPanel == null) {
                AndroidModuleEditor.$$$reportNull$$$0(2);
            }
            return jPanel;
        }
        NamedObjectPanel.PanelGroup panelGroup = new NamedObjectPanel.PanelGroup();
        if (this.myGenericSettingsPanel == null) {
            this.myEditors.clear();
            if (AndroidPluginGeneration.find(module) == AndroidPluginGeneration.COMPONENT) {
                this.myEditors.add(new GenericEditor<DslNotSupportedPanel>("Information", DslNotSupportedPanel::new));
            } else {
                AndroidFacet facet = AndroidFacet.getInstance(module);
                if (facet != null && facet.requiresAndroidModel() && GradleFacet.isAppliedTo(module)) {
                    this.myEditors.add(new GenericEditor<SingleObjectPanel>("Properties", () -> {
                        SingleObjectPanel panel = new SingleObjectPanel(this.myProject, this.myName, null, (List<BuildFileKey>)BUILD_FILE_GENERIC_PROPERTIES);
                        panel.init();
                        return panel;
                    }));
                    this.myEditors.add(new GenericEditor<NamedObjectPanel>(SIGNING_TAB_TITLE, () -> {
                        NamedObjectPanel panel = new NamedObjectPanel(this.myProject, this.myName, BuildFileKey.SIGNING_CONFIGS, "config", panelGroup);
                        panel.init();
                        return panel;
                    }));
                    this.myEditors.add(new GenericEditor<NamedObjectPanel>(FLAVORS_TAB_TITLE, () -> {
                        NamedObjectPanel panel = new NamedObjectPanel(this.myProject, this.myName, BuildFileKey.FLAVORS, "flavor", panelGroup);
                        panel.init();
                        return panel;
                    }));
                    this.myEditors.add(new GenericEditor<NamedObjectPanel>(BUILD_TYPES_TAB_TITLE, () -> {
                        NamedObjectPanel panel = new NamedObjectPanel(this.myProject, this.myName, BuildFileKey.BUILD_TYPES, "buildType", panelGroup);
                        panel.init();
                        return panel;
                    }));
                }
            }
            this.myEditors.add(new GenericEditor<ModuleDependenciesPanel>(ProjectBundle.message((String)"modules.classpath.title", (Object[])new Object[0]), () -> new ModuleDependenciesPanel(this.myProject, this.myName)));
            this.myTabbedPane = new JBTabbedPane(1);
            for (ModuleConfigurationEditor editor : this.myEditors) {
                JComponent component2 = editor.createComponent();
                if (component2 == null) continue;
                this.myTabbedPane.addTab(editor.getDisplayName(), (Component)component2);
                editor.reset();
            }
            this.myTabbedPane.addChangeListener(e -> {
                String tabName = this.myEditors.get(this.myTabbedPane.getSelectedIndex()).getDisplayName();
                String appId = ProjectStructureUsageTracker.getApplicationId(this.myProject);
                if (appId != null) {
                    UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.PROJECT_STRUCTURE_DIALOG).setKind(AndroidStudioEvent.EventKind.PROJECT_STRUCTURE_DIALOG_TOP_TAB_CLICK).setProjectId(AnonymizerUtil.anonymizeUtf8((String)appId)));
                }
            });
            this.myGenericSettingsPanel = this.myTabbedPane;
        }
        JComponent jComponent = this.myGenericSettingsPanel;
        if (jComponent == null) {
            AndroidModuleEditor.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    public void dispose() {
        for (ModuleConfigurationEditor myEditor : this.myEditors) {
            myEditor.disposeUIResources();
        }
        this.myEditors.clear();
        this.myGenericSettingsPanel = null;
    }

    public boolean isModified() {
        for (ModuleConfigurationEditor moduleElementsEditor : this.myEditors) {
            if (!moduleElementsEditor.isModified()) continue;
            return true;
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        String appId = ProjectStructureUsageTracker.getApplicationId(this.myProject);
        for (ModuleConfigurationEditor editor : this.myEditors) {
            if (appId != null) {
                UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.PROJECT_STRUCTURE_DIALOG).setKind(AndroidStudioEvent.EventKind.PROJECT_STRUCTURE_DIALOG_TOP_TAB_SAVE).setProjectId(AnonymizerUtil.anonymizeUtf8((String)appId)));
            }
            editor.saveData();
            editor.apply();
        }
    }

    public String getName() {
        return this.myName;
    }

    public void selectBuildTypesTab() {
        this.selectAndGetTabComponent(BUILD_TYPES_TAB_TITLE);
    }

    public void selectFlavorsTab() {
        this.selectAndGetTabComponent(FLAVORS_TAB_TITLE);
    }

    public void selectDependency(@NotNull GradleCoordinate dependency) {
        Component selected;
        if (dependency == null) {
            AndroidModuleEditor.$$$reportNull$$$0(4);
        }
        if ((selected = this.selectAndGetDependenciesTab()) instanceof ModuleDependenciesPanel) {
            ModuleDependenciesPanel dependenciesPanel = (ModuleDependenciesPanel)selected;
            dependenciesPanel.select(dependency);
        }
    }

    public void selectDependenciesTab() {
        this.selectAndGetDependenciesTab();
    }

    @Nullable
    private Component selectAndGetDependenciesTab() {
        return this.selectAndGetTabComponent(ProjectBundle.message((String)"modules.classpath.title", (Object[])new Object[0]));
    }

    @Nullable
    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        return null;
    }

    public void queryPlace(@NotNull Place place) {
        if (place == null) {
            AndroidModuleEditor.$$$reportNull$$$0(5);
        }
    }

    public void setHistory(History history) {
    }

    public void openSigningConfiguration() {
        this.selectAndGetTabComponent(SIGNING_TAB_TITLE);
    }

    @Nullable
    private Component selectAndGetTabComponent(@NotNull String tabTitle) {
        if (tabTitle == null) {
            AndroidModuleEditor.$$$reportNull$$$0(6);
        }
        int tabCount = this.myTabbedPane.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            Component component2 = this.myTabbedPane.getTabComponentAt(i);
            if (!(component2 instanceof JLabel) || !tabTitle.equals(((JLabel)component2).getText())) continue;
            this.myTabbedPane.setSelectedIndex(i);
            return this.myTabbedPane.getSelectedComponent();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/editors/AndroidModuleEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/editors/AndroidModuleEditor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectDependency";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "queryPlace";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "selectAndGetTabComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

