/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui.properties;

import com.android.tools.idea.gradle.structure.configurables.ui.properties.ModelPropertyEditor;
import com.android.tools.idea.gradle.structure.model.meta.ModelSimpleProperty;
import com.android.tools.idea.gradle.structure.model.meta.ParsedValue;
import com.android.tools.idea.gradle.structure.model.meta.PropertyValue;
import com.android.tools.idea.gradle.structure.model.meta.ResolvedValue;
import com.android.tools.idea.gradle.structure.model.meta.ValueDescriptor;
import com.intellij.openapi.ui.ComboBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u0003*\u0016\b\u0002\u0010\u0004 \u0001*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00052\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0012\u0004\u0012\u0002H\u00010\bB\u0015\u0012\u0006\u0010\t\u001a\u00028\u0000\u0012\u0006\u0010\n\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00010\u001eH\u0002J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00010\u001eH\u0002J\b\u0010 \u001a\u00020!H\u0016J\u0016\u0010\"\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00010#H\u0002J \u0010$\u001a\u00020\u001c2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'H\u0002J\u0010\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u0007H\u0002J\u0017\u0010*\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00018\u0001H\u0002\u00a2\u0006\u0002\u0010+R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\t\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\n\u001a\u00028\u0002\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00010\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00070\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/android/tools/idea/gradle/structure/configurables/ui/properties/SimplePropertyEditor;", "ModelT", "PropertyT", "", "ModelPropertyT", "Lcom/android/tools/idea/gradle/structure/model/meta/ModelSimpleProperty;", "Lcom/intellij/openapi/ui/ComboBox;", "", "Lcom/android/tools/idea/gradle/structure/configurables/ui/properties/ModelPropertyEditor;", "model", "property", "(Ljava/lang/Object;Lcom/android/tools/idea/gradle/structure/model/meta/ModelSimpleProperty;)V", "beingLoaded", "", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "getModel", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getProperty", "()Lcom/android/tools/idea/gradle/structure/model/meta/ModelSimpleProperty;", "Lcom/android/tools/idea/gradle/structure/model/meta/ModelSimpleProperty;", "textToValue", "", "valueToText", "applyChanges", "", "value", "Lcom/android/tools/idea/gradle/structure/model/meta/ParsedValue;", "getParsedValue", "getPreferredSize", "Ljava/awt/Dimension;", "loadValue", "Lcom/android/tools/idea/gradle/structure/model/meta/PropertyValue;", "setColorAndTooltip", "toolTipText", "background", "Ljava/awt/Color;", "setText", "text", "setValue", "(Ljava/lang/Object;)V", "intellij.android"})
public final class SimplePropertyEditor<ModelT, PropertyT, ModelPropertyT extends ModelSimpleProperty<? super ModelT, PropertyT>>
extends ComboBox<String>
implements ModelPropertyEditor<ModelT> {
    private final Map<String, PropertyT> textToValue;
    private final Map<PropertyT, String> valueToText;
    private boolean beingLoaded;
    @NotNull
    private final JComponent component;
    private final ModelT model;
    @NotNull
    private final ModelPropertyT property;

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.component;
    }

    @NotNull
    public Dimension getPreferredSize() {
        Dimension dimension2;
        Dimension dimensions = super.getPreferredSize();
        if (dimensions.width < 200) {
            dimension2 = new Dimension(200, dimensions.height);
        } else {
            Dimension dimension3 = dimensions;
            dimension2 = dimension3;
            Intrinsics.checkExpressionValueIsNotNull((Object)dimension3, (String)"dimensions");
        }
        return dimension2;
    }

    private final ParsedValue<PropertyT> getParsedValue() {
        ParsedValue parsedValue;
        ComboBoxEditor comboBoxEditor = this.editor;
        Intrinsics.checkExpressionValueIsNotNull((Object)comboBoxEditor, (String)"editor");
        String text = comboBoxEditor.getItem().toString();
        PropertyT PropertyT = this.textToValue.get(text);
        if (PropertyT != null) {
            PropertyT PropertyT2;
            PropertyT it = PropertyT2 = PropertyT;
            parsedValue = new ParsedValue.Set.Parsed(it, null, 2, null);
        } else {
            parsedValue = this.property.parse(text);
        }
        return parsedValue;
    }

    private final void setText(String text) {
        this.setSelectedItem(text);
    }

    private final void setValue(PropertyT value) {
        String string;
        if (value == null) {
            string = "";
        } else {
            string = this.valueToText.get(value);
            if (string == null) {
                string = value.toString();
            }
        }
        this.setSelectedItem(string);
    }

    private final void setColorAndTooltip(String toolTipText, Color background) {
        JTextField jTextField;
        ComboBoxEditor comboBoxEditor = this.editor;
        Intrinsics.checkExpressionValueIsNotNull((Object)comboBoxEditor, (String)"editor");
        Component component2 = comboBoxEditor.getEditorComponent();
        if (!(component2 instanceof JTextField)) {
            component2 = null;
        }
        if ((jTextField = (JTextField)component2) != null) {
            if (toolTipText != null) {
                jTextField.setToolTipText(toolTipText);
            }
            if (background != null) {
                jTextField.setBackground(background);
            }
        }
    }

    static /* synthetic */ void setColorAndTooltip$default(SimplePropertyEditor simplePropertyEditor, String string, Color color, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            color = null;
        }
        simplePropertyEditor.setColorAndTooltip(string, color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loadValue(PropertyValue<? extends PropertyT> value) {
        this.beingLoaded = true;
        try {
            ParsedValue<? extends PropertyT> parsedValue = value.getParsedValue();
            if (parsedValue instanceof ParsedValue.NotSet) {
                this.setText("");
            } else if (parsedValue instanceof ParsedValue.Set.Parsed) {
                this.setValue(((ParsedValue.Set.Parsed)value.getParsedValue()).getValue());
            } else if (parsedValue instanceof ParsedValue.Set.Invalid) {
                this.setText(((ParsedValue.Set.Invalid)value.getParsedValue()).getDslText());
            }
            Object defaultValue = this.property.getDefaultValue(this.model);
            if (value.getResolved() instanceof ResolvedValue.NotResolved && value.getParsedValue() instanceof ParsedValue.Set) {
                this.setColorAndTooltip("[Set but not resolved - not yet synced?]", Color.GREEN);
            } else if (value.getResolved() instanceof ResolvedValue.Set && (value.getParsedValue() instanceof ParsedValue.Set.Parsed && Intrinsics.areEqual(((ResolvedValue.Set)value.getResolved()).getResolved(), ((ParsedValue.Set.Parsed)value.getParsedValue()).getValue()) ^ true || value.getParsedValue() instanceof ParsedValue.NotSet && Intrinsics.areEqual(((ResolvedValue.Set)value.getResolved()).getResolved(), defaultValue) ^ true)) {
                this.setColorAndTooltip("[Set does not match resolved?]", Color.YELLOW);
            } else if (value.getParsedValue() instanceof ParsedValue.Set.Invalid) {
                this.setColorAndTooltip("[Invalid?]", Color.RED);
            } else if (value.getParsedValue() instanceof ParsedValue.Set.Parsed) {
                String string = ((ParsedValue.Set.Parsed)value.getParsedValue()).getDslText();
                SimplePropertyEditor simplePropertyEditor = this;
                String string2 = string;
                if (string2 == null) {
                    string2 = "";
                }
                String string3 = string2;
                SimplePropertyEditor.setColorAndTooltip$default(simplePropertyEditor, string3, null, 2, null);
            }
        }
        finally {
            this.beingLoaded = false;
        }
    }

    private final void applyChanges(ParsedValue<? extends PropertyT> value) {
        ParsedValue<? extends PropertyT> parsedValue = value;
        if (!(parsedValue instanceof ParsedValue.Set.Invalid)) {
            ModelT ModelT = this.model;
            if (ModelT == null) {
                Intrinsics.throwNpe();
            }
            this.property.setValue(ModelT, value);
        }
    }

    public final ModelT getModel() {
        return this.model;
    }

    @NotNull
    public final ModelPropertyT getProperty() {
        return this.property;
    }

    public SimplePropertyEditor(ModelT model, @NotNull ModelPropertyT property2) {
        DefaultComboBoxModel<String> defaultComboBoxModel;
        Pair pair;
        ValueDescriptor it;
        Map map;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(property2, (String)"property");
        this.model = model;
        this.property = property2;
        this.component = (JComponent)((Object)this);
        this.setMinLength(60);
        this.setEditable(true);
        List list = this.property.getKnownValues(this.model);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List possibleValues = list;
        Iterable iterable = possibleValues;
        SimplePropertyEditor simplePropertyEditor = this;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        void var6_8 = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            map = destination$iv$iv;
            it = (ValueDescriptor)element$iv$iv;
            pair = TuplesKt.to((Object)it.getDescription(), it.getValue());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Object object = destination$iv$iv;
        simplePropertyEditor.textToValue = object;
        $receiver$iv = possibleValues;
        simplePropertyEditor = this;
        capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            map = destination$iv$iv;
            it = (ValueDescriptor)element$iv$iv;
            pair = TuplesKt.to(it.getValue(), (Object)it.getDescription());
            map.put(pair.getFirst(), pair.getSecond());
        }
        object = destination$iv$iv;
        simplePropertyEditor.valueToText = object;
        $receiver$iv = this.textToValue.keySet();
        DefaultComboBoxModel<String> defaultComboBoxModel2 = defaultComboBoxModel;
        object = defaultComboBoxModel;
        simplePropertyEditor = this;
        Iterable iterable2 = $receiver$iv;
        if (iterable2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Iterable thisCollection$iv = iterable2;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] stringArray2 = stringArray;
        defaultComboBoxModel2(stringArray2);
        super.setModel((ComboBoxModel)object);
        this.loadValue(this.property.getValue(this.model));
        this.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                if (!beingLoaded) {
                    this.applyChanges(this.getParsedValue());
                }
            }
        });
    }

    public static final /* synthetic */ void access$setBeingLoaded$p(SimplePropertyEditor $this, boolean bl) {
        $this.beingLoaded = bl;
    }
}

