/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeEventDispatcher;
import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeListener;
import com.android.tools.idea.gradle.structure.model.repositories.search.ArtifactRepository;
import com.android.tools.idea.gradle.structure.model.repositories.search.ArtifactRepositorySearch;
import com.android.tools.idea.gradle.structure.model.repositories.search.FoundArtifact;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchRequest;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchResult;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactRepositorySearchForm {
    private static final String SEARCHING_EMPTY_TEXT = "Searching...";
    private static final String NOTHING_TO_SHOW_EMPTY_TEXT = "Nothing to show";
    @NotNull
    private final ArtifactRepositorySearch mySearch;
    private JBLabel myArtifactNameLabel;
    private JBTextField myArtifactNameTextField;
    private JBLabel myGroupIdLabel;
    private JBTextField myGroupIdTextField;
    private JButton mySearchButton;
    private JPanel myResultsPanel;
    private TableView<FoundArtifact> myResultsTable;
    private AvailableVersionsPanel myVersionsPanel;
    private JPanel myPanel;
    @NotNull
    private final SelectionChangeEventDispatcher<String> myEventDispatcher;
    @NotNull
    private final List<Exception> mySearchErrors;

    public ArtifactRepositorySearchForm(@NotNull List<ArtifactRepository> repositories) {
        if (repositories == null) {
            ArtifactRepositorySearchForm.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        this.myEventDispatcher = new SelectionChangeEventDispatcher();
        this.mySearchErrors = Lists.newArrayList();
        this.mySearch = new ArtifactRepositorySearch(repositories);
        this.myArtifactNameTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                ArtifactRepositorySearchForm.this.clearResults();
                ArtifactRepositorySearchForm.this.showSearchStopped();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/structure/configurables/ui/ArtifactRepositorySearchForm$1", "textChanged"));
            }
        });
        ActionListener actionListener = e -> {
            if (this.mySearchButton.isEnabled()) {
                this.performSearch();
            }
        };
        this.mySearchButton.addActionListener(actionListener);
        this.myArtifactNameLabel.setLabelFor((Component)this.myArtifactNameTextField);
        this.myArtifactNameTextField.addActionListener(actionListener);
        this.myArtifactNameTextField.getEmptyText().setText("Example: \"guava\"");
        this.myGroupIdLabel.setLabelFor((Component)this.myGroupIdTextField);
        this.myGroupIdTextField.addActionListener(actionListener);
        this.myGroupIdTextField.getEmptyText().setText("Example: \"com.google.guava\"");
        this.myResultsTable = new TableView((ListTableModel)new ResultsTableModel());
        this.myResultsTable.setPreferredSize(new Dimension(520, 320));
        this.myResultsTable.setSelectionMode(0);
        this.myResultsTable.setAutoCreateRowSorter(true);
        this.myResultsTable.setShowGrid(false);
        this.myResultsTable.getTableHeader().setReorderingAllowed(false);
        this.myResultsTable.getSelectionModel().addListSelectionListener(e -> {
            FoundArtifact artifact = this.getSelection();
            if (artifact != null) {
                this.myVersionsPanel.setVersions(artifact.getVersions());
            } else {
                this.notifySelectionChanged(null, null);
            }
        });
        this.myVersionsPanel = new AvailableVersionsPanel();
        OnePixelSplitter splitter = new OnePixelSplitter(false, 0.7f);
        splitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane(this.myResultsTable));
        splitter.setSecondComponent((JComponent)this.myVersionsPanel);
        this.myResultsPanel.add((Component)splitter, "Center");
        new TableSpeedSearch(this.myResultsTable);
    }

    @Nullable
    private FoundArtifact getSelection() {
        Collection selection = this.myResultsTable.getSelection();
        FoundArtifact artifact = null;
        if (selection.size() == 1) {
            artifact = (FoundArtifact)ContainerUtil.getFirstItem((Collection)selection);
        }
        return artifact;
    }

    private void notifySelectionChanged(@Nullable FoundArtifact artifact, @Nullable String version) {
        String selected = null;
        if (artifact != null) {
            String groupId = artifact.getGroupId();
            String name = artifact.getName();
            if (version == null) {
                List<GradleVersion> versions = artifact.getVersions();
                version = versions.isEmpty() ? "" : versions.get(0).toString();
            }
            selected = groupId + ":" + name;
            if (StringUtil.isNotEmpty((String)version)) {
                selected = selected + ":" + version;
            }
        }
        this.myEventDispatcher.selectionChanged(selected);
    }

    private void performSearch() {
        this.mySearchButton.setEnabled(false);
        this.myVersionsPanel.setEmptyText(SEARCHING_EMPTY_TEXT);
        this.myResultsTable.getEmptyText().setText(SEARCHING_EMPTY_TEXT);
        this.myResultsTable.setPaintBusy(true);
        this.clearResults();
        SearchRequest request = new SearchRequest(this.getArtifactName(), this.getGroupId(), 50, 0);
        ArtifactRepositorySearch.Callback callback = this.mySearch.start(request);
        callback.doWhenDone(() -> UIUtil.invokeLaterIfNeeded(() -> {
            ArrayList foundArtifacts = Lists.newArrayList();
            List<Exception> errors = callback.getErrors();
            if (!errors.isEmpty()) {
                this.showSearchStopped();
                this.mySearchErrors.addAll(errors);
                return;
            }
            for (SearchResult result : callback.getSearchResults()) {
                foundArtifacts.addAll(result.getArtifacts());
            }
            if (foundArtifacts.size() > 1) {
                Collections.sort(foundArtifacts);
            }
            this.myResultsTable.getListTableModel().setItems((List)foundArtifacts);
            this.myResultsTable.updateColumnSizes();
            this.showSearchStopped();
            if (!foundArtifacts.isEmpty()) {
                this.myResultsTable.changeSelection(0, 0, false, false);
            }
            this.myResultsTable.requestFocusInWindow();
        }));
    }

    private void clearResults() {
        this.myResultsTable.getListTableModel().setItems(Collections.emptyList());
        this.mySearchErrors.clear();
        this.myVersionsPanel.clear();
    }

    private void showSearchStopped() {
        this.mySearchButton.setEnabled(this.getArtifactName().length() >= 3);
        this.myResultsTable.setPaintBusy(false);
        this.myResultsTable.getEmptyText().setText(NOTHING_TO_SHOW_EMPTY_TEXT);
        this.myVersionsPanel.clear();
        this.myVersionsPanel.setEmptyText(NOTHING_TO_SHOW_EMPTY_TEXT);
    }

    @NotNull
    private String getArtifactName() {
        String string = this.myArtifactNameTextField.getText().trim();
        if (string == null) {
            ArtifactRepositorySearchForm.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    private String getGroupId() {
        String groupId = this.myGroupIdTextField.getText().trim();
        return StringUtil.isNotEmpty((String)groupId) ? groupId : null;
    }

    public void add(@NotNull SelectionChangeListener<String> listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            ArtifactRepositorySearchForm.$$$reportNull$$$0(2);
        }
        if (parentDisposable == null) {
            ArtifactRepositorySearchForm.$$$reportNull$$$0(3);
        }
        this.myEventDispatcher.addListener(listener, parentDisposable);
    }

    @NotNull
    public JPanel getPanel() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            ArtifactRepositorySearchForm.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JBTextField jBTextField = this.myArtifactNameTextField;
        if (jBTextField == null) {
            ArtifactRepositorySearchForm.$$$reportNull$$$0(5);
        }
        return jBTextField;
    }

    @NotNull
    public List<Exception> getSearchErrors() {
        List<Exception> list = this.mySearchErrors;
        if (list == null) {
            ArtifactRepositorySearchForm.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/configurables/ui/ArtifactRepositorySearchForm";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/configurables/ui/ArtifactRepositorySearchForm";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchErrors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JButton jButton;
        JBTextField jBTextField;
        JBLabel jBLabel;
        JBTextField jBTextField2;
        JBLabel jBLabel2;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.setPreferredSize(new Dimension(420, 220));
        this.myArtifactNameLabel = jBLabel2 = new JBLabel();
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel2.setText("Name:");
        jBLabel2.setDisplayedMnemonic('N');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myArtifactNameTextField = jBTextField2 = new JBTextField();
        jPanel2.add((Component)jBTextField2, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, new Dimension(150, -1), null));
        this.myGroupIdLabel = jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel.setText("Group ID:");
        jBLabel.setDisplayedMnemonic('G');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myGroupIdTextField = jBTextField = new JBTextField();
        jPanel2.add((Component)jBTextField, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, new Dimension(150, -1), null));
        this.mySearchButton = jButton = new JButton();
        ((Component)jButton).setEnabled(false);
        jButton.setText("Search");
        jButton.setMnemonic('S');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 4, 0, 3, 0, null, null, null));
        this.myResultsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(3, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jPanel2.add((Component)jBLabel3, new GridConstraints(2, 1, 1, 1, 0, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private class AvailableVersionsPanel
    extends JPanel {
        private final TableView<GradleVersion> myVersionsTable;

        AvailableVersionsPanel() {
            super(new BorderLayout());
            this.myVersionsTable = new TableView();
            this.myVersionsTable.setShowGrid(false);
            this.myVersionsTable.setSelectionMode(0);
            this.myVersionsTable.getListTableModel().setColumnInfos(new ColumnInfo[]{new ColumnInfo<GradleVersion, String>("Versions"){

                @Nullable
                public String valueOf(GradleVersion version) {
                    return version.toString();
                }
            }});
            this.myVersionsTable.getSelectionModel().addListSelectionListener(e -> {
                FoundArtifact artifact = ArtifactRepositorySearchForm.this.getSelection();
                GradleVersion version = (GradleVersion)this.myVersionsTable.getSelectedObject();
                ArtifactRepositorySearchForm.this.notifySelectionChanged(artifact, version != null ? version.toString() : null);
            });
            JScrollPane scrollPane = ScrollPaneFactory.createScrollPane(this.myVersionsTable);
            this.add((Component)scrollPane, "Center");
        }

        void setVersions(@NotNull List<GradleVersion> versions) {
            if (versions == null) {
                AvailableVersionsPanel.$$$reportNull$$$0(0);
            }
            this.clear();
            this.myVersionsTable.getListTableModel().setItems(versions);
            if (!versions.isEmpty()) {
                this.myVersionsTable.getSelectionModel().setSelectionInterval(0, 0);
            }
        }

        void setEmptyText(@NotNull String text) {
            if (text == null) {
                AvailableVersionsPanel.$$$reportNull$$$0(1);
            }
            this.myVersionsTable.getEmptyText().setText(text);
        }

        void clear() {
            this.myVersionsTable.getListTableModel().setItems(Collections.emptyList());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "versions";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/gradle/structure/configurables/ui/ArtifactRepositorySearchForm$AvailableVersionsPanel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setVersions";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setEmptyText";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ResultsTableModel
    extends ListTableModel<FoundArtifact> {
        ResultsTableModel() {
            super(new ColumnInfo[0]);
            this.createAndSetColumnInfos();
            this.setSortable(true);
        }

        private void createAndSetColumnInfos() {
            ColumnInfo<FoundArtifact, String> groupId = new ColumnInfo<FoundArtifact, String>("Group ID"){

                @Nullable
                public String valueOf(FoundArtifact found) {
                    return found.getGroupId();
                }

                @NonNls
                @NotNull
                public String getPreferredStringValue() {
                    if ("abcdefghijklmno" == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return "abcdefghijklmno";
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/ui/ArtifactRepositorySearchForm$ResultsTableModel$1", "getPreferredStringValue"));
                }
            };
            ColumnInfo<FoundArtifact, String> artifactName = new ColumnInfo<FoundArtifact, String>("Artifact Name"){

                @Nullable
                public String valueOf(FoundArtifact found) {
                    return found.getName();
                }

                @NonNls
                @NotNull
                public String getPreferredStringValue() {
                    if ("abcdefg" == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return "abcdefg";
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/ui/ArtifactRepositorySearchForm$ResultsTableModel$2", "getPreferredStringValue"));
                }
            };
            ColumnInfo<FoundArtifact, String> repository = new ColumnInfo<FoundArtifact, String>("Repository"){

                @Nullable
                public String valueOf(FoundArtifact found) {
                    return found.getRepositoryName();
                }
            };
            this.setColumnInfos(new ColumnInfo[]{groupId, artifactName, repository});
        }
    }
}

