/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.android.dependencies.module;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.details.ModuleDependencyDetails;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.details.SingleLibraryDependencyDetails;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.AbstractDependencyNode;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.AbstractPsNodeTreeBuilder;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.GoToModuleAction;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.ModuleDependencyNode;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.SelectNodesMatchingCurrentSelectionAction;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.graph.DependenciesTreeBuilder;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.graph.DependenciesTreeRootNode;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.graph.DependenciesTreeStructure;
import com.android.tools.idea.gradle.structure.configurables.issues.IssuesViewer;
import com.android.tools.idea.gradle.structure.configurables.issues.SingleModuleIssuesRenderer;
import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeEventDispatcher;
import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeListener;
import com.android.tools.idea.gradle.structure.configurables.ui.UiUtil;
import com.android.tools.idea.gradle.structure.configurables.ui.dependencies.AbstractDependenciesPanel;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractBaseCollapseAllAction;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractBaseExpandAllAction;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractPsModelNode;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.NodeHyperlinkSupport;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsBaseDependency;
import com.android.tools.idea.gradle.structure.model.PsDependency;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidDependency;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.android.PsLibraryAndroidDependency;
import com.android.tools.idea.gradle.structure.model.android.PsModuleAndroidDependency;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.TreeVisitor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.navigation.Place;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.Tree;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependencyGraphPanel
extends AbstractDependenciesPanel {
    @NotNull
    private final Tree myTree;
    @NotNull
    private final DependenciesTreeBuilder myTreeBuilder;
    @NotNull
    private final PsContext myContext;
    @NotNull
    private final String myPlaceName;
    @NotNull
    private final NodeHyperlinkSupport<ModuleDependencyNode> myHyperlinkSupport;
    @NotNull
    private final SelectionChangeEventDispatcher<AbstractDependencyNode<? extends PsAndroidDependency>> myEventDispatcher;

    public DependencyGraphPanel(@NotNull PsAndroidModule module, @NotNull PsContext context) {
        if (module == null) {
            DependencyGraphPanel.$$$reportNull$$$0(0);
        }
        if (context == null) {
            DependencyGraphPanel.$$$reportNull$$$0(1);
        }
        super("Dependency Graph", context, module);
        this.myEventDispatcher = new SelectionChangeEventDispatcher();
        this.myContext = context;
        this.myPlaceName = DependencyGraphPanel.createPlaceName(module.getName());
        this.initializeDependencyDetails();
        this.setIssuesViewer(new IssuesViewer(this.myContext, new SingleModuleIssuesRenderer(this.myContext)));
        DefaultTreeModel treeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.myTree = new Tree(treeModel){

            protected void processMouseEvent(MouseEvent e) {
                ModuleDependencyNode node;
                int id = e.getID();
                if (id == 501 && (node = (ModuleDependencyNode)((Object)DependencyGraphPanel.this.myHyperlinkSupport.getIfHyperlink(e))) != null) {
                    PsModuleAndroidDependency moduleDependency = (PsModuleAndroidDependency)node.getFirstModel();
                    String name = moduleDependency.getName();
                    DependencyGraphPanel.this.myContext.setSelectedModule(name, DependencyGraphPanel.this);
                    return;
                }
                super.processMouseEvent(e);
            }
        };
        this.getContentsPanel().add((Component)this.createActionsPanel(), "North");
        DependenciesTreeStructure treeStructure = new DependenciesTreeStructure(DependencyGraphPanel.createRootNode(module));
        this.myTreeBuilder = new DependenciesTreeBuilder((JTree)this.myTree, treeModel, treeStructure);
        module.add((PsModule.DependencyChangedEvent event) -> {
            PsDependency dependency;
            this.myTreeBuilder.reset(null);
            PsBaseDependency toSelect = null;
            if (event instanceof PsModule.LibraryDependencyAddedEvent) {
                PsArtifactDependencySpec spec = ((PsModule.LibraryDependencyAddedEvent)event).getSpec();
                this.selectDependency(spec);
            } else if (event instanceof PsModule.DependencyModifiedEvent && (dependency = ((PsModule.DependencyModifiedEvent)event).getDependency()) instanceof PsAndroidDependency) {
                toSelect = (PsAndroidDependency)dependency;
            }
            if (toSelect != null) {
                this.selectDependency(toSelect.toText(PsDependency.TextType.FOR_NAVIGATION));
            }
        }, this);
        JScrollPane scrollPane = UiUtil.setUp(this.myTreeBuilder);
        this.getContentsPanel().add((Component)scrollPane, "Center");
        TreeSelectionListener treeSelectionListener = e -> {
            List<AbstractDependencyNode<? extends PsAndroidDependency>> selection = this.getMatchingSelection();
            AbstractDependencyNode<? extends PsAndroidDependency> selectedNode = selection.size() == 1 ? selection.get(0) : null;
            this.notifySelectionChanged(selectedNode);
            this.updateDetails(selectedNode);
            this.updateIssues(selection);
        };
        this.myTree.addTreeSelectionListener(treeSelectionListener);
        this.myTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                DependencyGraphPanel.this.popupInvoked(x, y);
            }
        });
        this.myTreeBuilder.getInitialized().doWhenDone(() -> {
            AbstractPsModelNode<?> selectedNode = this.myTreeBuilder.getSelectedNode();
            if (selectedNode == null) {
                this.selectFirstNode();
            }
        });
        this.myHyperlinkSupport = new NodeHyperlinkSupport<ModuleDependencyNode>(this.myTree, ModuleDependencyNode.class, this.myContext, true);
    }

    private void updateDetails(@Nullable AbstractDependencyNode<? extends PsAndroidDependency> selectedNode) {
        PsAndroidDependency selected = null;
        String configurationName = null;
        if (selectedNode != null) {
            selected = (PsAndroidDependency)selectedNode.getFirstModel();
            AbstractDependencyNode<? extends PsAndroidDependency> topDependencyNode = DependencyGraphPanel.findTopDependencyNode(selectedNode);
            configurationName = ((PsAndroidDependency)topDependencyNode.getFirstModel()).getJoinedConfigurationNames();
        }
        super.updateDetails(selected, configurationName);
    }

    @NotNull
    static AbstractDependencyNode<? extends PsAndroidDependency> findTopDependencyNode(@NotNull AbstractDependencyNode<?> node) {
        if (node == null) {
            DependencyGraphPanel.$$$reportNull$$$0(2);
        }
        AbstractDependencyNode current = node;
        while (true) {
            SimpleNode parent;
            if (!((parent = current.getParent()) instanceof AbstractDependencyNode)) {
                AbstractDependencyNode abstractDependencyNode = current;
                if (abstractDependencyNode == null) {
                    DependencyGraphPanel.$$$reportNull$$$0(3);
                }
                return abstractDependencyNode;
            }
            current = (AbstractDependencyNode)parent;
        }
    }

    private void selectDependency(final @NotNull PsArtifactDependencySpec spec) {
        if (spec == null) {
            DependencyGraphPanel.$$$reportNull$$$0(4);
        }
        final Ref nodeRef = new Ref();
        this.myTreeBuilder.accept(AbstractDependencyNode.class, (TreeVisitor)new TreeVisitor<AbstractDependencyNode>(){

            public boolean visit(@NotNull AbstractDependencyNode node) {
                PsLibraryAndroidDependency libraryDependency;
                if (node == null) {
                    3.$$$reportNull$$$0(0);
                }
                PsAndroidDependency dependency = (PsAndroidDependency)node.getFirstModel();
                if (DependencyGraphPanel.isTopLevel(node) && dependency instanceof PsLibraryAndroidDependency && spec.equals((libraryDependency = (PsLibraryAndroidDependency)dependency).getDeclaredSpec())) {
                    nodeRef.set((Object)node);
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/module/DependencyGraphPanel$3", "visit"));
            }
        });
        this.select((AbstractDependencyNode)((Object)nodeRef.get()));
    }

    @NotNull
    private static String createPlaceName(@NotNull String moduleName) {
        if (moduleName == null) {
            DependencyGraphPanel.$$$reportNull$$$0(5);
        }
        String string = "dependencies." + moduleName + ".place";
        if (string == null) {
            DependencyGraphPanel.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    private static DependenciesTreeRootNode<PsModule> createRootNode(@NotNull PsAndroidModule module) {
        if (module == null) {
            DependencyGraphPanel.$$$reportNull$$$0(7);
        }
        DependenciesTreeRootNode<PsModule> dependenciesTreeRootNode = new DependenciesTreeRootNode<PsModule>(module, new DependenciesTreeRootNode.DependencyCollectorFunction<PsModule>(){

            @Override
            public DependenciesTreeRootNode.DependencyCollector apply(PsModule module) {
                DependenciesTreeRootNode.DependencyCollector collector = new DependenciesTreeRootNode.DependencyCollector();
                this.collectDeclaredDependencies(module, collector);
                return collector;
            }
        });
        if (dependenciesTreeRootNode == null) {
            DependencyGraphPanel.$$$reportNull$$$0(8);
        }
        return dependenciesTreeRootNode;
    }

    private void initializeDependencyDetails() {
        this.addDetails(new SingleLibraryDependencyDetails());
        this.addDetails(new ModuleDependencyDetails(this.getContext(), false));
    }

    @NotNull
    private List<AbstractDependencyNode<? extends PsAndroidDependency>> getMatchingSelection() {
        ArrayList selection = Lists.newArrayList();
        List<AbstractDependencyNode> matchingSelection = this.myTreeBuilder.getMatchingSelection(AbstractDependencyNode.class);
        for (AbstractDependencyNode node : matchingSelection) {
            selection.add(node);
        }
        ArrayList arrayList = selection;
        if (arrayList == null) {
            DependencyGraphPanel.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    private void updateIssues(@NotNull List<AbstractDependencyNode<? extends PsAndroidDependency>> selection) {
        if (selection == null) {
            DependencyGraphPanel.$$$reportNull$$$0(10);
        }
        ArrayList issues = Lists.newArrayList();
        for (AbstractDependencyNode<? extends PsAndroidDependency> node : selection) {
            for (PsAndroidDependency dependency : node.getModels()) {
                issues.addAll(this.myContext.getAnalyzerDaemon().getIssues().findIssues(dependency, null));
            }
        }
        this.displayIssues(issues);
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        Tree tree = this.myTree;
        if (tree == null) {
            DependencyGraphPanel.$$$reportNull$$$0(11);
        }
        return tree;
    }

    public void add(@NotNull SelectionChangeListener<AbstractDependencyNode<? extends PsAndroidDependency>> listener) {
        if (listener == null) {
            DependencyGraphPanel.$$$reportNull$$$0(12);
        }
        this.myEventDispatcher.addListener(listener, this);
    }

    private void notifySelectionChanged(@Nullable AbstractDependencyNode<? extends PsAndroidDependency> selected) {
        this.myEventDispatcher.selectionChanged(selected);
    }

    @Override
    @NotNull
    protected List<AnAction> getExtraToolbarActions() {
        ArrayList actions2 = Lists.newArrayList();
        actions2.add(new SelectNodesMatchingCurrentSelectionAction(){

            @Override
            @NotNull
            protected AbstractPsNodeTreeBuilder getTreeBuilder() {
                DependenciesTreeBuilder dependenciesTreeBuilder = DependencyGraphPanel.this.myTreeBuilder;
                if (dependenciesTreeBuilder == null) {
                    5.$$$reportNull$$$0(0);
                }
                return dependenciesTreeBuilder;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/module/DependencyGraphPanel$5", "getTreeBuilder"));
            }
        });
        actions2.add(new Separator());
        actions2.add(new AbstractBaseExpandAllAction(this.myTree, AllIcons.Actions.Expandall){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                DependencyGraphPanel.this.myTree.requestFocusInWindow();
                DependencyGraphPanel.this.myTreeBuilder.expandAllNodes();
                DependencyGraphPanel.this.selectFirstNode();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/module/DependencyGraphPanel$6", "actionPerformed"));
            }
        });
        actions2.add(new AbstractBaseCollapseAllAction(this.myTree, AllIcons.Actions.Collapseall){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(0);
                }
                DependencyGraphPanel.this.myTreeBuilder.clearSelection();
                DependencyGraphPanel.this.myTree.requestFocusInWindow();
                DependencyGraphPanel.this.myTreeBuilder.collapseAllNodes();
                DependencyGraphPanel.this.selectFirstNode();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/module/DependencyGraphPanel$7", "actionPerformed"));
            }
        });
        ArrayList arrayList = actions2;
        if (arrayList == null) {
            DependencyGraphPanel.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    private void selectFirstNode() {
        final Ref nodeRef = new Ref();
        this.myTreeBuilder.accept(AbstractDependencyNode.class, (TreeVisitor)new TreeVisitor<AbstractDependencyNode>(){

            public boolean visit(@NotNull AbstractDependencyNode node) {
                if (node == null) {
                    8.$$$reportNull$$$0(0);
                }
                nodeRef.set((Object)node);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/module/DependencyGraphPanel$8", "visit"));
            }
        });
        this.myTreeBuilder.select(nodeRef.get());
    }

    private void popupInvoked(int x, int y) {
        ModuleDependencyNode node = this.myHyperlinkSupport.getNodeForLocation(x, y);
        if (node != null) {
            PsModuleAndroidDependency moduleDependency = (PsModuleAndroidDependency)node.getFirstModel();
            String name = moduleDependency.getName();
            DefaultActionGroup group = new DefaultActionGroup();
            group.add((AnAction)new GoToModuleAction(name, this.myContext, (JComponent)this.myTree));
            ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("", (ActionGroup)group);
            popupMenu.getComponent().show((Component)this.myTree, x, y);
        }
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myTreeBuilder);
        Disposer.dispose(this.myHyperlinkSupport);
    }

    @Override
    public void selectDependency(@Nullable String dependency) {
        if (StringUtil.isEmpty((String)dependency)) {
            this.myTreeBuilder.clearSelection();
            this.myTree.requestFocusInWindow();
            return;
        }
        this.doSelectDependency(dependency);
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        Object path;
        if (place != null && (path = place.getPath(this.myPlaceName)) instanceof String) {
            String pathText = (String)path;
            this.myTree.requestFocusInWindow();
            if (StringUtil.isNotEmpty((String)pathText)) {
                this.doSelectDependency(pathText);
            }
        }
        return ActionCallback.DONE;
    }

    private void doSelectDependency(final @NotNull String toSelect) {
        if (toSelect == null) {
            DependencyGraphPanel.$$$reportNull$$$0(14);
        }
        final Ref nodeRef = new Ref();
        this.myTreeBuilder.accept(AbstractDependencyNode.class, (TreeVisitor)new TreeVisitor<AbstractDependencyNode>(){

            public boolean visit(@NotNull AbstractDependencyNode node) {
                String dependencyAsText;
                if (node == null) {
                    9.$$$reportNull$$$0(0);
                }
                PsAndroidDependency dependency = (PsAndroidDependency)node.getFirstModel();
                if (DependencyGraphPanel.isTopLevel(node) && toSelect.equals(dependencyAsText = dependency.toText(PsDependency.TextType.FOR_NAVIGATION))) {
                    nodeRef.set((Object)node);
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/module/DependencyGraphPanel$9", "visit"));
            }
        });
        this.select((AbstractDependencyNode)((Object)nodeRef.get()));
    }

    private static boolean isTopLevel(@NotNull AbstractDependencyNode node) {
        if (node == null) {
            DependencyGraphPanel.$$$reportNull$$$0(15);
        }
        return !(node.getParent() instanceof AbstractDependencyNode);
    }

    private void select(@Nullable AbstractDependencyNode node) {
        this.myTreeBuilder.getInitialized().doWhenDone(() -> this.myTreeBuilder.select((Object)node));
        this.myTree.requestFocusInWindow();
    }

    @Override
    @NotNull
    public String getPlaceName() {
        String string = this.myPlaceName;
        if (string == null) {
            DependencyGraphPanel.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/configurables/android/dependencies/module/DependencyGraphPanel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSelect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/configurables/android/dependencies/module/DependencyGraphPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findTopDependencyNode";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createPlaceName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createRootNode";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatchingSelection";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraToolbarActions";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findTopDependencyNode";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 16: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectDependency";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPlaceName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createRootNode";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateIssues";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doSelectDependency";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isTopLevel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

