/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.projectView;

import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.ui.GuiTestingService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElementNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;

public class AndroidTreeStructureProvider
implements TreeStructureProvider {
    private final EventDispatcher<ChangeListener> myEventDispatcher = EventDispatcher.create(ChangeListener.class);

    @NotNull
    public Collection<AbstractTreeNode> modify(@NotNull AbstractTreeNode parent, @NotNull Collection<AbstractTreeNode> children, ViewSettings settings) {
        Project project;
        if (parent == null) {
            AndroidTreeStructureProvider.$$$reportNull$$$0(0);
        }
        if (children == null) {
            AndroidTreeStructureProvider.$$$reportNull$$$0(1);
        }
        if ((project = parent.getProject()) != null && AndroidProjectInfo.getInstance(project).requiresAndroidModel()) {
            if (parent instanceof NamedLibraryElementNode) {
                Sdk sdk;
                NamedLibraryElement value = (NamedLibraryElement)((NamedLibraryElementNode)parent).getValue();
                LibraryOrSdkOrderEntry orderEntry = value.getOrderEntry();
                if (orderEntry instanceof JdkOrderEntry && (sdk = ((JdkOrderEntry)orderEntry).getJdk()).getSdkType() instanceof JavaSdk) {
                    ArrayList newChildren = Lists.newArrayList();
                    for (AbstractTreeNode child : children) {
                        if (!AndroidTreeStructureProvider.isRtJar(child)) continue;
                        newChildren.add(child);
                    }
                    if (!newChildren.isEmpty()) {
                        ((ChangeListener)this.myEventDispatcher.getMulticaster()).nodeChanged(parent, newChildren);
                        ArrayList arrayList = newChildren;
                        if (arrayList == null) {
                            AndroidTreeStructureProvider.$$$reportNull$$$0(2);
                        }
                        return arrayList;
                    }
                }
            } else if (AndroidTreeStructureProvider.isRtJar(parent)) {
                ArrayList newChildren = Lists.newArrayList();
                for (AbstractTreeNode child : children) {
                    VirtualFile file;
                    if (!(child instanceof PsiDirectoryNode) || (file = ((PsiDirectoryNode)child).getVirtualFile()) == null || !"java".equals(file.getName()) && !"javax".equals(file.getName())) continue;
                    newChildren.add(child);
                }
                if (!newChildren.isEmpty()) {
                    ((ChangeListener)this.myEventDispatcher.getMulticaster()).nodeChanged(parent, newChildren);
                    ArrayList arrayList = newChildren;
                    if (arrayList == null) {
                        AndroidTreeStructureProvider.$$$reportNull$$$0(3);
                    }
                    return arrayList;
                }
            }
        }
        Collection<AbstractTreeNode> collection = children;
        if (collection == null) {
            AndroidTreeStructureProvider.$$$reportNull$$$0(4);
        }
        return collection;
    }

    private static boolean isRtJar(@NotNull AbstractTreeNode node) {
        if (node == null) {
            AndroidTreeStructureProvider.$$$reportNull$$$0(5);
        }
        if (node instanceof PsiDirectoryNode) {
            VirtualFile file = ((PsiDirectoryNode)node).getVirtualFile();
            return file != null && "rt.jar".equals(file.getName());
        }
        return false;
    }

    @VisibleForTesting
    public void addChangeListener(@NotNull ChangeListener changeListener) {
        if (changeListener == null) {
            AndroidTreeStructureProvider.$$$reportNull$$$0(6);
        }
        if (GuiTestingService.getInstance().isGuiTestingMode() || ApplicationManager.getApplication().isUnitTestMode()) {
            this.myEventDispatcher.addListener((EventListener)changeListener);
            return;
        }
        throw new UnsupportedOperationException("'addChangeListener' should only be used in tests");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/projectView/AndroidTreeStructureProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/projectView/AndroidTreeStructureProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "modify";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "modify";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isRtJar";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    public static interface ChangeListener
    extends EventListener {
        public void nodeChanged(@NotNull AbstractTreeNode var1, @NotNull Collection<AbstractTreeNode> var2);
    }
}

