/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.tools.idea.gradle.project.sync.ng.ModuleSetup;
import com.android.tools.idea.gradle.project.sync.ng.SyncProjectModels;
import com.android.tools.idea.gradle.project.sync.ng.caching.CachedProjectModels;
import com.android.tools.idea.gradle.project.sync.ng.caching.ModelNotFoundInCacheException;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

abstract class ProjectSetup {
    ProjectSetup() {
    }

    abstract void setUpProject(@NotNull SyncProjectModels var1, @NotNull ProgressIndicator var2);

    abstract void setUpProject(@NotNull CachedProjectModels var1, @NotNull ProgressIndicator var2) throws ModelNotFoundInCacheException;

    abstract void commit();

    @VisibleForTesting
    static class ProjectSetupImpl
    extends ProjectSetup {
        @NotNull
        private final Project myProject;
        @NotNull
        private final IdeModifiableModelsProvider myModelsProvider;
        @NotNull
        private final ModuleSetup.Factory myModuleSetupFactory;

        ProjectSetupImpl(@NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ModuleSetup.Factory moduleSetupFactory) {
            if (project == null) {
                ProjectSetupImpl.$$$reportNull$$$0(0);
            }
            if (modelsProvider == null) {
                ProjectSetupImpl.$$$reportNull$$$0(1);
            }
            if (moduleSetupFactory == null) {
                ProjectSetupImpl.$$$reportNull$$$0(2);
            }
            this.myProject = project;
            this.myModelsProvider = modelsProvider;
            this.myModuleSetupFactory = moduleSetupFactory;
        }

        @Override
        void setUpProject(@NotNull SyncProjectModels projectModels, @NotNull ProgressIndicator indicator) {
            if (projectModels == null) {
                ProjectSetupImpl.$$$reportNull$$$0(3);
            }
            if (indicator == null) {
                ProjectSetupImpl.$$$reportNull$$$0(4);
            }
            ModuleSetup moduleSetup = this.myModuleSetupFactory.create(this.myProject, this.myModelsProvider);
            try {
                moduleSetup.setUpModules(projectModels, indicator);
            }
            catch (Throwable e) {
                this.disposeChanges();
                throw e;
            }
        }

        @Override
        void setUpProject(@NotNull CachedProjectModels projectModels, @NotNull ProgressIndicator indicator) throws ModelNotFoundInCacheException {
            if (projectModels == null) {
                ProjectSetupImpl.$$$reportNull$$$0(5);
            }
            if (indicator == null) {
                ProjectSetupImpl.$$$reportNull$$$0(6);
            }
            ModuleSetup moduleSetup = this.myModuleSetupFactory.create(this.myProject, this.myModelsProvider);
            try {
                moduleSetup.setUpModules(projectModels, indicator);
            }
            catch (Throwable e) {
                this.disposeChanges();
                throw e;
            }
        }

        @Override
        void commit() {
            try {
                ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)this.myProject){

                    public void execute() {
                        myModelsProvider.commit();
                    }
                });
            }
            catch (Throwable e) {
                ProjectSetupImpl.getLog().warn("Exception thrown while committing project changes", e);
                this.disposeChanges();
                throw e;
            }
        }

        private void disposeChanges() {
            ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)this.myProject){

                public void execute() {
                    try {
                        myModelsProvider.dispose();
                    }
                    catch (Throwable e) {
                        ProjectSetupImpl.getLog().warn("Failed to dispose changes", e);
                    }
                }
            });
        }

        @NotNull
        private static Logger getLog() {
            Logger logger = Logger.getInstance(ProjectSetup.class);
            if (logger == null) {
                ProjectSetupImpl.$$$reportNull$$$0(7);
            }
            return logger;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modelsProvider";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleSetupFactory";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectModels";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/project/sync/ng/ProjectSetup$ProjectSetupImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/ProjectSetup$ProjectSetupImpl";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "setUpProject";
                    break;
                }
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class Factory {
        Factory() {
        }

        @NotNull
        ProjectSetup create(@NotNull Project project) {
            if (project == null) {
                Factory.$$$reportNull$$$0(0);
            }
            ProjectSetupImpl projectSetupImpl = new ProjectSetupImpl(project, (IdeModifiableModelsProvider)new IdeModifiableModelsProviderImpl(project), new ModuleSetup.Factory());
            if (projectSetupImpl == null) {
                Factory.$$$reportNull$$$0(1);
            }
            return projectSetupImpl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/project/sync/ng/ProjectSetup$Factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/ProjectSetup$Factory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

