/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.tools.idea.util.PositionInFile;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyLexer;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;

class DependencyPositionFinder {
    DependencyPositionFinder() {
    }

    @NotNull
    PositionInFile findDependencyPosition(@NotNull String dependency, @NotNull VirtualFile buildFile) {
        TextRange textRange;
        if (dependency == null) {
            DependencyPositionFinder.$$$reportNull$$$0(0);
        }
        if (buildFile == null) {
            DependencyPositionFinder.$$$reportNull$$$0(1);
        }
        int line = -1;
        int column = -1;
        Document document = (Document)ReadAction.compute(() -> {
            if (buildFile == null) {
                DependencyPositionFinder.$$$reportNull$$$0(5);
            }
            return FileDocumentManager.getInstance().getDocument(buildFile);
        });
        if (document != null && (textRange = DependencyPositionFinder.findDependency(dependency, document)) != null && (line = document.getLineNumber(textRange.getStartOffset())) > -1) {
            int lineStartOffset = document.getLineStartOffset(line);
            column = textRange.getStartOffset() - lineStartOffset;
        }
        PositionInFile positionInFile = new PositionInFile(buildFile, line, column);
        if (positionInFile == null) {
            DependencyPositionFinder.$$$reportNull$$$0(2);
        }
        return positionInFile;
    }

    @Nullable
    private static TextRange findDependency(@NotNull String dependency, @NotNull Document buildFile) {
        if (dependency == null) {
            DependencyPositionFinder.$$$reportNull$$$0(3);
        }
        if (buildFile == null) {
            DependencyPositionFinder.$$$reportNull$$$0(4);
        }
        Function consumer = pair -> {
            GroovyLexer lexer = (GroovyLexer)pair.getSecond();
            return TextRange.create((int)(lexer.getTokenStart() + 1), (int)(lexer.getTokenEnd() - 1));
        };
        GroovyLexer lexer = new GroovyLexer();
        lexer.start((CharSequence)buildFile.getText());
        while (lexer.getTokenType() != null) {
            String text;
            IElementType type = lexer.getTokenType();
            if ((type == GroovyElementTypes.STRING_SQ || type == GroovyElementTypes.STRING_TSQ) && (text = StringUtil.unquoteString((String)lexer.getTokenText())).startsWith(dependency)) {
                return (TextRange)consumer.fun((Object)Pair.create((Object)text, (Object)lexer));
            }
            lexer.advance();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/issues/DependencyPositionFinder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/issues/DependencyPositionFinder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findDependencyPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findDependencyPosition";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findDependency";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findDependencyPosition$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

