/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.data;

import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.java.JavaFacet;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.google.common.collect.Maps;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class DataNodeCaches {
    @NotNull
    private final Project myProject;

    @NotNull
    public static DataNodeCaches getInstance(@NotNull Project project) {
        if (project == null) {
            DataNodeCaches.$$$reportNull$$$0(0);
        }
        DataNodeCaches dataNodeCaches = (DataNodeCaches)ServiceManager.getService((Project)project, DataNodeCaches.class);
        if (dataNodeCaches == null) {
            DataNodeCaches.$$$reportNull$$$0(1);
        }
        return dataNodeCaches;
    }

    public DataNodeCaches(@NotNull Project project) {
        if (project == null) {
            DataNodeCaches.$$$reportNull$$$0(2);
        }
        this.myProject = project;
    }

    @Nullable
    public DataNode<ProjectData> getCachedProjectData() {
        String projectPath;
        ProjectDataManager dataManager = ProjectDataManager.getInstance();
        ExternalProjectInfo projectInfo = dataManager.getExternalProjectData(this.myProject, GradleConstants.SYSTEM_ID, projectPath = Projects.getBaseDirPath((Project)this.myProject).getPath());
        return projectInfo != null ? projectInfo.getExternalProjectStructure() : null;
    }

    public boolean isCacheMissingModels(@NotNull DataNode<ProjectData> cache) {
        Collection moduleDataNodes;
        if (cache == null) {
            DataNodeCaches.$$$reportNull$$$0(3);
        }
        if (!(moduleDataNodes = ExternalSystemApiUtil.findAll(cache, (Key)ProjectKeys.MODULE)).isEmpty()) {
            Map<String, DataNode<ModuleData>> moduleDataNodesByName = DataNodeCaches.indexByModuleName(moduleDataNodes);
            ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
            for (Module module : moduleManager.getModules()) {
                GradleFacet gradleFacet;
                DataNode<ModuleData> moduleDataNode = moduleDataNodesByName.get(module.getName());
                if (!(moduleDataNode == null ? (gradleFacet = GradleFacet.getInstance(module)) != null : DataNodeCaches.isCacheMissingModels(moduleDataNode, module))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @NotNull
    private static Map<String, DataNode<ModuleData>> indexByModuleName(@NotNull Collection<DataNode<ModuleData>> moduleDataNodes) {
        if (moduleDataNodes == null) {
            DataNodeCaches.$$$reportNull$$$0(4);
        }
        HashMap mapping = Maps.newHashMap();
        for (DataNode<ModuleData> moduleDataNode : moduleDataNodes) {
            ModuleData data = (ModuleData)moduleDataNode.getData();
            mapping.put(data.getExternalName(), moduleDataNode);
        }
        HashMap hashMap = mapping;
        if (hashMap == null) {
            DataNodeCaches.$$$reportNull$$$0(5);
        }
        return hashMap;
    }

    private static boolean isCacheMissingModels(@NotNull DataNode<ModuleData> cache, @NotNull Module module) {
        DataNode ndkModuleModelDataNode;
        NdkFacet ndkFacet;
        GradleFacet gradleFacet;
        if (cache == null) {
            DataNodeCaches.$$$reportNull$$$0(6);
        }
        if (module == null) {
            DataNodeCaches.$$$reportNull$$$0(7);
        }
        if ((gradleFacet = GradleFacet.getInstance(module)) != null) {
            DataNode javaProjectDataNode;
            JavaFacet javaFacet;
            DataNode androidDataNode;
            DataNode gradleDataNode = ExternalSystemApiUtil.find(cache, AndroidProjectKeys.GRADLE_MODULE_MODEL);
            if (gradleDataNode == null) {
                return true;
            }
            AndroidFacet androidFacet = AndroidFacet.getInstance(module);
            if (androidFacet != null ? (androidDataNode = ExternalSystemApiUtil.find(cache, AndroidProjectKeys.ANDROID_MODEL)) == null : (javaFacet = JavaFacet.getInstance(module)) != null && (javaProjectDataNode = ExternalSystemApiUtil.find(cache, AndroidProjectKeys.JAVA_MODULE_MODEL)) == null) {
                return true;
            }
        }
        return (ndkFacet = NdkFacet.getInstance(module)) != null && (ndkModuleModelDataNode = ExternalSystemApiUtil.find(cache, AndroidProjectKeys.NDK_MODEL)) == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/idea/data/DataNodeCaches";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleDataNodes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/idea/data/DataNodeCaches";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "indexByModuleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isCacheMissingModels";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "indexByModuleName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

