/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.setup.post.PostSyncProjectSetup;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaSyncPopulateProjectTask {
    @NotNull
    private final Project myProject;
    @NotNull
    private final PostSyncProjectSetup myProjectSetup;
    @NotNull
    private final GradleSyncState mySyncState;
    @NotNull
    private final ProjectDataManager myDataManager;

    public IdeaSyncPopulateProjectTask(@NotNull Project project) {
        if (project == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(0);
        }
        this(project, PostSyncProjectSetup.getInstance(project), GradleSyncState.getInstance(project), ProjectDataManager.getInstance());
    }

    @VisibleForTesting
    IdeaSyncPopulateProjectTask(@NotNull Project project, @NotNull PostSyncProjectSetup projectSetup, @NotNull GradleSyncState syncState, @NotNull ProjectDataManager dataManager) {
        if (project == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(1);
        }
        if (projectSetup == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(2);
        }
        if (syncState == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(3);
        }
        if (dataManager == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myProjectSetup = projectSetup;
        this.mySyncState = syncState;
        this.myDataManager = dataManager;
    }

    public void populateProject(@NotNull DataNode<ProjectData> projectInfo) {
        if (projectInfo == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(5);
        }
        this.populateProject(projectInfo, null, null);
    }

    public void populateProject(@NotNull DataNode<ProjectData> projectInfo, @Nullable PostSyncProjectSetup.Request setupRequest, @Nullable Runnable syncFinishedCallback) {
        if (projectInfo == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(6);
        }
        this.doPopulateProject(projectInfo, setupRequest, syncFinishedCallback);
    }

    private void doPopulateProject(final @NotNull DataNode<ProjectData> projectInfo, final @Nullable PostSyncProjectSetup.Request setupRequest, final @Nullable Runnable syncFinishedCallback) {
        if (projectInfo == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(7);
        }
        UIUtil.invokeAndWaitIfNeeded(() -> GradleSyncMessages.getInstance(this.myProject).removeProjectMessages());
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.populate(projectInfo, (ProgressIndicator)new EmptyProgressIndicator(), setupRequest, syncFinishedCallback);
            return;
        }
        Task.Backgroundable task = new Task.Backgroundable(this.myProject, "Project Setup", false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                IdeaSyncPopulateProjectTask.this.populate((DataNode<ProjectData>)projectInfo, indicator, setupRequest, syncFinishedCallback);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/gradle/project/sync/idea/IdeaSyncPopulateProjectTask$1", "run"));
            }
        };
        task.queue();
    }

    private void populate(@NotNull DataNode<ProjectData> projectInfo, @NotNull ProgressIndicator indicator, @Nullable PostSyncProjectSetup.Request setupRequest, @Nullable Runnable syncFinishedCallback) {
        if (projectInfo == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(8);
        }
        if (indicator == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(9);
        }
        this.doPopulateProject(projectInfo, this.myProject, setupRequest);
        if (syncFinishedCallback != null) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                syncFinishedCallback.run();
            } else {
                TransactionGuard.getInstance().submitTransactionLater((Disposable)this.myProject, syncFinishedCallback);
            }
        }
        if (setupRequest != null) {
            PostSyncProjectSetup.getInstance(this.myProject).setUpProject(setupRequest, indicator);
        }
    }

    @VisibleForTesting
    void doPopulateProject(@NotNull DataNode<ProjectData> projectInfo, @NotNull Project project, @Nullable PostSyncProjectSetup.Request setupRequest) {
        if (projectInfo == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(10);
        }
        if (project == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(11);
        }
        try {
            this.myDataManager.importData(projectInfo, project, true);
        }
        catch (Throwable unexpected) {
            String message = ExceptionUtil.getRootCause((Throwable)unexpected).getMessage();
            Logger.getInstance(this.getClass()).warn("Sync failed: " + message, unexpected);
            if (setupRequest != null && setupRequest.usingCachedGradleModels) {
                this.myProjectSetup.onCachedModelsSetupFailure(setupRequest);
                return;
            }
            this.mySyncState.syncFailed(message);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSetup";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncState";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataManager";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectInfo";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/idea/IdeaSyncPopulateProjectTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "populateProject";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "doPopulateProject";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "populate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

