/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.gradle.project.settings.AndroidStudioGradleIdeSettings;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class EnableEmbeddedRepoHyperlink
extends NotificationHyperlink {
    public EnableEmbeddedRepoHyperlink() {
        super("enable.embedded.maven.repository", "Enable embedded Maven repository and sync project");
    }

    @Override
    protected void execute(@NotNull Project project) {
        if (project == null) {
            EnableEmbeddedRepoHyperlink.$$$reportNull$$$0(0);
        }
        AndroidStudioGradleIdeSettings.getInstance().setEmbeddedMavenRepoEnabled(true);
        GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, GradleSyncStats.Trigger.TRIGGER_EMBEDDED_REPO_ENABLED_BY_QUICKFIX);
    }

    public static boolean shouldEnableEmbeddedRepo(@NotNull String missingDependency) {
        GradleCoordinate coordinate;
        if (missingDependency == null) {
            EnableEmbeddedRepoHyperlink.$$$reportNull$$$0(1);
        }
        if ((coordinate = GradleCoordinate.parseCoordinateString((String)missingDependency)) == null) {
            return false;
        }
        if (AndroidStudioGradleIdeSettings.getInstance().isEmbeddedMavenRepoEnabled()) {
            return false;
        }
        String subPathWithoutExtension = EnableEmbeddedRepoHyperlink.getPathWithoutExtensionFromCoordinate(coordinate);
        List<String> fileExtensions = Arrays.asList(".jar", ".aar");
        List<File> repoPaths = EmbeddedDistributionPaths.getInstance().findAndroidStudioLocalMavenRepoPaths();
        for (File repoPath : repoPaths) {
            for (String extension : fileExtensions) {
                File expectedPath = new File(repoPath, subPathWithoutExtension + extension);
                if (!expectedPath.exists()) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    static String getPathWithoutExtensionFromCoordinate(@NotNull GradleCoordinate coordinate) {
        if (coordinate == null) {
            EnableEmbeddedRepoHyperlink.$$$reportNull$$$0(2);
        }
        StringBuilder path = new StringBuilder();
        String groupId = coordinate.getGroupId();
        String artifactId = coordinate.getArtifactId();
        String revision = coordinate.getRevision();
        String fileNamePrefix = "";
        if (groupId != null) {
            path.append(groupId.replace(".", File.separator)).append(File.separator);
        }
        if (artifactId != null) {
            path.append(artifactId.replace(".", File.separator)).append(File.separator);
            fileNamePrefix = artifactId + "-";
        }
        path.append(revision).append(File.separator);
        path.append(fileNamePrefix).append(revision);
        String string = path.toString();
        if (string == null) {
            EnableEmbeddedRepoHyperlink.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "missingDependency";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coordinate";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/hyperlink/EnableEmbeddedRepoHyperlink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/hyperlink/EnableEmbeddedRepoHyperlink";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathWithoutExtensionFromCoordinate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "shouldEnableEmbeddedRepo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPathWithoutExtensionFromCoordinate";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

