/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddGoogleMavenRepositoryHyperlink
extends NotificationHyperlink {
    @Nullable
    private final VirtualFile myBuildFile;
    private final boolean mySyncAfterFix;

    public AddGoogleMavenRepositoryHyperlink(@Nullable VirtualFile buildFile) {
        this(buildFile, true);
    }

    public AddGoogleMavenRepositoryHyperlink(@Nullable VirtualFile buildFile, boolean syncAfterFix) {
        super("add.google.maven.repository", AddGoogleMavenRepositoryHyperlink.getText(buildFile, syncAfterFix));
        this.myBuildFile = buildFile;
        this.mySyncAfterFix = syncAfterFix;
    }

    @Override
    protected void execute(@NotNull Project project) {
        GradleBuildModel buildModel;
        if (project == null) {
            AddGoogleMavenRepositoryHyperlink.$$$reportNull$$$0(0);
        }
        if ((buildModel = this.myBuildFile != null ? GradleBuildModel.parseBuildFile(this.myBuildFile, project) : AddGoogleMavenRepositoryHyperlink.getBuildModelForPlugin(project)) != null) {
            AddGoogleMavenRepositoryHyperlink.addGoogleMavenRepository(buildModel);
        }
        if (this.mySyncAfterFix) {
            GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED);
        }
    }

    @NotNull
    private static String getText(@Nullable VirtualFile buildFile, boolean syncAfterFix) {
        String text = "Add Google Maven repository";
        if (buildFile == null) {
            text = text + " (if needed)";
        }
        if (syncAfterFix) {
            text = text + " and sync project";
        }
        String string = text;
        if (string == null) {
            AddGoogleMavenRepositoryHyperlink.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public VirtualFile getBuildFile() {
        return this.myBuildFile;
    }

    private static void addGoogleMavenRepository(@NotNull GradleBuildModel buildModel) {
        if (buildModel == null) {
            AddGoogleMavenRepositoryHyperlink.$$$reportNull$$$0(2);
        }
        Project project = buildModel.getProject();
        buildModel.repositories().addGoogleMavenRepository(project);
        buildModel.buildscript().repositories().addGoogleMavenRepository(project);
        WriteCommandAction.runWriteCommandAction((Project)project, buildModel::applyChanges);
        GradleBuildModel buildModelProject = GradleBuildModel.get(project);
        if (buildModelProject != null) {
            buildModelProject.buildscript().repositories().addGoogleMavenRepository(project);
            WriteCommandAction.runWriteCommandAction((Project)project, buildModelProject::applyChanges);
        }
    }

    @Nullable
    public static GradleBuildModel getBuildModelForPlugin(Project project) {
        VirtualFile buildFile;
        AndroidPluginInfo result = AndroidPluginInfo.searchInBuildFilesOnly(project);
        GradleBuildModel gradleBuildModel = null;
        if (result != null && (buildFile = result.getPluginBuildFile()) != null) {
            gradleBuildModel = GradleBuildModel.parseBuildFile(buildFile, project);
        }
        if (gradleBuildModel == null) {
            gradleBuildModel = GradleBuildModel.get(project);
        }
        return gradleBuildModel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/hyperlink/AddGoogleMavenRepositoryHyperlink";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/hyperlink/AddGoogleMavenRepositoryHyperlink";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addGoogleMavenRepository";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

