/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.compatibility;

import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.compatibility.CompatibilityCheck;
import com.android.tools.idea.gradle.project.sync.compatibility.CompatibilityChecksMetadata;
import com.android.tools.idea.gradle.project.sync.compatibility.CompatibilityChecksMetadataUpdater;
import com.android.tools.idea.gradle.project.sync.compatibility.Component;
import com.android.tools.idea.gradle.project.sync.compatibility.VersionIncompatibility;
import com.android.tools.idea.gradle.project.sync.compatibility.version.ComponentVersionReader;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.project.messages.MessageType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.intellij.lang.annotations.Language;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VersionCompatibilityChecker {
    public static final String VERSION_COMPATIBILITY_ISSUE_GROUP = "Version Compatibility Issues";
    @NotNull
    private CompatibilityChecksMetadata myMetadata = new CompatibilityChecksMetadata(1);

    @NotNull
    public static VersionCompatibilityChecker getInstance() {
        VersionCompatibilityChecker versionCompatibilityChecker = (VersionCompatibilityChecker)ServiceManager.getService(VersionCompatibilityChecker.class);
        if (versionCompatibilityChecker == null) {
            VersionCompatibilityChecker.$$$reportNull$$$0(0);
        }
        return versionCompatibilityChecker;
    }

    private VersionCompatibilityChecker() {
        new CompatibilityChecksMetadataUpdater().initiateUpdateIfNecessary();
        this.reloadMetadata();
    }

    public void reloadMetadata() {
        this.myMetadata = CompatibilityChecksMetadata.reload();
    }

    @VisibleForTesting
    void reloadMetadataForTesting(@NotNull @Language(value="XML") String metadata) throws JDOMException, IOException {
        if (metadata == null) {
            VersionCompatibilityChecker.$$$reportNull$$$0(1);
        }
        this.myMetadata = CompatibilityChecksMetadata.reloadForTesting(metadata);
    }

    boolean updateMetadata(@NotNull Element metadata) {
        if (metadata == null) {
            VersionCompatibilityChecker.$$$reportNull$$$0(2);
        }
        try {
            CompatibilityChecksMetadata updated = CompatibilityChecksMetadata.load(metadata);
            if (updated.getDataVersion() > this.myMetadata.getDataVersion()) {
                this.myMetadata = updated;
                File metadataFilePath = CompatibilityChecksMetadata.getSourceFilePath();
                JDOMUtil.write((Element)metadata, (File)metadataFilePath, (String)SystemProperties.getLineSeparator());
                VersionCompatibilityChecker.getLogger().info("Saved component version metadata to: " + metadataFilePath);
                return true;
            }
        }
        catch (Throwable e) {
            VersionCompatibilityChecker.getLogger().info("Failed to update component version metadata", e);
        }
        return false;
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(VersionCompatibilityChecker.class);
        if (logger == null) {
            VersionCompatibilityChecker.$$$reportNull$$$0(3);
        }
        return logger;
    }

    public void checkAndReportComponentIncompatibilities(@NotNull Project project) {
        Module[] modules;
        if (project == null) {
            VersionCompatibilityChecker.$$$reportNull$$$0(4);
        }
        GradleSyncMessages.getInstance(project).removeMessages(VERSION_COMPATIBILITY_ISSUE_GROUP);
        ComponentVersionAndReaderCache cache = new ComponentVersionAndReaderCache();
        HashMap incompatibilitiesByCheck = Maps.newHashMap();
        for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
            this.collectComponentIncompatibilities(module, incompatibilitiesByCheck, cache);
        }
        if (incompatibilitiesByCheck.isEmpty()) {
            return;
        }
        boolean hasErrors = false;
        for (VersionIncompatibility versionIncompatibility : incompatibilitiesByCheck.values()) {
            if (versionIncompatibility.getType() == MessageType.ERROR) {
                hasErrors = true;
            }
            versionIncompatibility.reportMessages(project);
        }
        if (hasErrors) {
            GradleSyncState.getInstance(project).getSummary().setSyncErrorsFound(true);
        }
    }

    private void collectComponentIncompatibilities(@NotNull Module module, @NotNull Map<String, VersionIncompatibility> incompatibilitiesByCheck, @NotNull ComponentVersionAndReaderCache cache) {
        if (module == null) {
            VersionCompatibilityChecker.$$$reportNull$$$0(5);
        }
        if (incompatibilitiesByCheck == null) {
            VersionCompatibilityChecker.$$$reportNull$$$0(6);
        }
        if (cache == null) {
            VersionCompatibilityChecker.$$$reportNull$$$0(7);
        }
        for (CompatibilityCheck check : this.myMetadata.getCompatibilityChecks()) {
            Component component2 = check.getComponent();
            Pair<ComponentVersionReader, String> readerAndVersion = this.getComponentVersion(component2, module, cache);
            if (readerAndVersion == null) continue;
            String version = (String)readerAndVersion.getSecond();
            if (!component2.getVersionRange().contains(version)) continue;
            for (Component requirement : component2.getRequirements()) {
                String msg;
                Pair<ComponentVersionReader, String> readerAndRequirementVersion = this.getComponentVersion(requirement, module, cache);
                if (readerAndRequirementVersion == null) continue;
                String requirementVersion = (String)readerAndRequirementVersion.getSecond();
                if (requirement.getVersionRange().contains(requirementVersion)) continue;
                boolean projectLevelCheck = ((ComponentVersionReader)readerAndVersion.getFirst()).isProjectLevel();
                String componentName = check.getComponent().getName();
                String id = projectLevelCheck ? componentName : module.getName() + "." + componentName;
                VersionIncompatibility versionIncompatibility = incompatibilitiesByCheck.get(id);
                if (versionIncompatibility == null) {
                    ComponentVersionReader reader = (ComponentVersionReader)readerAndRequirementVersion.getFirst();
                    versionIncompatibility = new VersionIncompatibility(module, check, readerAndVersion, requirement, reader);
                    incompatibilitiesByCheck.put(id, versionIncompatibility);
                }
                if (((ComponentVersionReader)readerAndRequirementVersion.getFirst()).isProjectLevel()) {
                    if (versionIncompatibility.hasMessages()) continue;
                    msg = String.format("but project is using version %1$s.", requirementVersion);
                    versionIncompatibility.addMessage(msg);
                    continue;
                }
                msg = String.format("Module '%1$s' is using version %2$s", module.getName(), requirementVersion);
                versionIncompatibility.addMessage(msg);
            }
        }
    }

    @Nullable
    private Pair<ComponentVersionReader, String> getComponentVersion(@NotNull Component component2, @NotNull Module module, @NotNull ComponentVersionAndReaderCache cache) {
        Map<String, Pair<ComponentVersionReader, String>> componentVersionsByModule;
        String componentName;
        Pair readerAndVersion;
        if (component2 == null) {
            VersionCompatibilityChecker.$$$reportNull$$$0(8);
        }
        if (module == null) {
            VersionCompatibilityChecker.$$$reportNull$$$0(9);
        }
        if (cache == null) {
            VersionCompatibilityChecker.$$$reportNull$$$0(10);
        }
        if ((readerAndVersion = cache.projectComponents.get(componentName = component2.getName())) == null && (componentVersionsByModule = cache.moduleComponents.get(componentName)) != null) {
            readerAndVersion = componentVersionsByModule.get(module.getName());
        }
        if (readerAndVersion != null) {
            return readerAndVersion;
        }
        ComponentVersionReader reader = this.myMetadata.findComponentVersionReader(componentName);
        if (reader == null) {
            VersionCompatibilityChecker.getLogger().info(String.format("Failed to find version reader for component '%1$s'", componentName));
            return null;
        }
        if (!reader.appliesTo(module)) {
            return null;
        }
        String version = reader.getComponentVersion(module);
        if (version != null) {
            readerAndVersion = Pair.create((Object)reader, (Object)version);
            if (reader.isProjectLevel()) {
                cache.projectComponents.put(componentName, (Pair<ComponentVersionReader, String>)readerAndVersion);
            } else {
                Map componentVersionsByModule2 = cache.moduleComponents.computeIfAbsent(componentName, k -> Maps.newHashMap());
                componentVersionsByModule2.put(module.getName(), readerAndVersion);
            }
            return readerAndVersion;
        }
        Project project = module.getProject();
        String msg = String.format("Failed to read version for component '%1$s'", componentName);
        msg = reader.isProjectLevel() ? msg + String.format(" for project '%1$s'", project.getName()) : msg + String.format(" for module '%1$s', in project '%2$s'", module.getName(), project.getName());
        VersionCompatibilityChecker.getLogger().info(msg);
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/compatibility/VersionCompatibilityChecker";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadata";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "incompatibilitiesByCheck";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/compatibility/VersionCompatibilityChecker";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reloadMetadataForTesting";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateMetadata";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkAndReportComponentIncompatibilities";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectComponentIncompatibilities";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getComponentVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ComponentVersionAndReaderCache {
        @NotNull
        final Map<String, Pair<ComponentVersionReader, String>> projectComponents = new HashMap<String, Pair<ComponentVersionReader, String>>();
        @NotNull
        final Map<String, Map<String, Pair<ComponentVersionReader, String>>> moduleComponents = new HashMap<String, Map<String, Pair<ComponentVersionReader, String>>>();

        private ComponentVersionAndReaderCache() {
        }
    }
}

