/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.builder.model.NativeAndroidProject;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.sync.ng.GradleModuleModels;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.android.tools.idea.gradle.project.sync.setup.module.ModuleFinder;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.concurrency.JobLauncher;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.Key;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleSetupContext {
    @VisibleForTesting
    static final Key<ModuleFinder> MODULES_BY_GRADLE_PATH_KEY = Key.create((String)"gradle.sync.modules.by.gradle.path");
    @NotNull
    private final Module myModule;
    @NotNull
    private final IdeModifiableModelsProvider myIdeModelsProvider;
    @Nullable
    private final GradleModuleModels myGradleModels;

    @VisibleForTesting
    ModuleSetupContext(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModelsProvider, @Nullable GradleModuleModels gradleModels) {
        if (module == null) {
            ModuleSetupContext.$$$reportNull$$$0(0);
        }
        if (ideModelsProvider == null) {
            ModuleSetupContext.$$$reportNull$$$0(1);
        }
        this.myModule = module;
        this.myIdeModelsProvider = ideModelsProvider;
        this.myGradleModels = gradleModels;
    }

    @Nullable
    public ModuleFinder getModuleFinder() {
        ModuleFinder moduleFinder = (ModuleFinder)this.myModule.getProject().getUserData(MODULES_BY_GRADLE_PATH_KEY);
        if (moduleFinder == null) {
            ModuleFinder temp = new ModuleFinder(this.myModule.getProject());
            List<Module> modules = Arrays.asList(this.myIdeModelsProvider.getModules());
            JobLauncher.getInstance().invokeConcurrentlyUnderProgress(modules, null, true, module -> {
                GradleFacet gradleFacet = GradleFacet.getInstance(module, this.myIdeModelsProvider);
                if (gradleFacet != null) {
                    temp.addModule((Module)module, ((GradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH);
                }
                return true;
            });
            moduleFinder = temp;
            this.store(moduleFinder);
        }
        return moduleFinder;
    }

    private void store(ModuleFinder moduleFinder) {
        this.myModule.getProject().putUserData(MODULES_BY_GRADLE_PATH_KEY, (Object)moduleFinder);
    }

    public boolean hasNativeModel() {
        if (this.myGradleModels != null) {
            return this.myGradleModels.findModel(NativeAndroidProject.class) != null;
        }
        NdkFacet facet = (NdkFacet)((Object)Facets.findFacet(this.myModule, this.myIdeModelsProvider, NdkFacet.getFacetType().getId()));
        return facet != null && facet.getNdkModuleModel() != null;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            ModuleSetupContext.$$$reportNull$$$0(2);
        }
        return module;
    }

    @NotNull
    public IdeModifiableModelsProvider getIdeModelsProvider() {
        IdeModifiableModelsProvider ideModifiableModelsProvider = this.myIdeModelsProvider;
        if (ideModifiableModelsProvider == null) {
            ModuleSetupContext.$$$reportNull$$$0(3);
        }
        return ideModifiableModelsProvider;
    }

    @NotNull
    public ModifiableRootModel getModifiableRootModel() {
        ModifiableRootModel modifiableRootModel = this.myIdeModelsProvider.getModifiableRootModel(this.myModule);
        if (modifiableRootModel == null) {
            ModuleSetupContext.$$$reportNull$$$0(4);
        }
        return modifiableRootModel;
    }

    public static void removeSyncContextDataFrom(@NotNull Project project) {
        if (project == null) {
            ModuleSetupContext.$$$reportNull$$$0(5);
        }
        project.putUserData(MODULES_BY_GRADLE_PATH_KEY, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModelsProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/ModuleSetupContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ModuleSetupContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeModelsProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableRootModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeSyncContextDataFrom";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Factory {
        @NotNull
        public ModuleSetupContext create(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModelsProvider) {
            if (module == null) {
                Factory.$$$reportNull$$$0(0);
            }
            if (ideModelsProvider == null) {
                Factory.$$$reportNull$$$0(1);
            }
            ModuleSetupContext moduleSetupContext = new ModuleSetupContext(module, ideModelsProvider, null);
            if (moduleSetupContext == null) {
                Factory.$$$reportNull$$$0(2);
            }
            return moduleSetupContext;
        }

        @NotNull
        public ModuleSetupContext create(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModelsProvider, @NotNull ModuleFinder moduleFinder, @NotNull GradleModuleModels gradleModels) {
            if (module == null) {
                Factory.$$$reportNull$$$0(3);
            }
            if (ideModelsProvider == null) {
                Factory.$$$reportNull$$$0(4);
            }
            if (moduleFinder == null) {
                Factory.$$$reportNull$$$0(5);
            }
            if (gradleModels == null) {
                Factory.$$$reportNull$$$0(6);
            }
            ModuleSetupContext context = new ModuleSetupContext(module, ideModelsProvider, gradleModels);
            context.store(moduleFinder);
            ModuleSetupContext moduleSetupContext = context;
            if (moduleSetupContext == null) {
                Factory.$$$reportNull$$$0(7);
            }
            return moduleSetupContext;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ideModelsProvider";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/project/sync/ModuleSetupContext$Factory";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleFinder";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gradleModels";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ModuleSetupContext$Factory";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 2: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

