/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.invoker;

import com.android.tools.idea.Projects;
import com.android.tools.idea.debug.AndroidNativeDebugProcess;
import com.android.tools.idea.gradle.filters.AndroidReRunBuildFilter;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.project.build.invoker.BuildStopper;
import com.android.tools.idea.gradle.project.build.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.project.build.invoker.GradleTaskFinder;
import com.android.tools.idea.gradle.project.build.invoker.GradleTasksExecutor;
import com.android.tools.idea.gradle.project.build.invoker.GradleTasksExecutorFactory;
import com.android.tools.idea.gradle.project.build.invoker.TestCompileType;
import com.android.tools.idea.gradle.project.build.output.GradleBuildOutputParser;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildViewManager;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FinishBuildEventImpl;
import com.intellij.build.events.impl.OutputBuildEventImpl;
import com.intellij.build.events.impl.SkippedResultImpl;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.build.output.BuildOutputInstantReaderImpl;
import com.intellij.build.output.BuildOutputParser;
import com.intellij.build.output.JavacOutputParser;
import com.intellij.build.output.KotlincOutputParser;
import com.intellij.execution.filters.Filter;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.Ref;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.gradle.tooling.BuildAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleBuildInvoker {
    @NotNull
    private final Project myProject;
    @NotNull
    private final FileDocumentManager myDocumentManager;
    @NotNull
    private final GradleTasksExecutorFactory myTaskExecutorFactory;
    @NotNull
    private final Set<AfterGradleInvocationTask> myAfterTasks;
    @NotNull
    private final List<String> myOneTimeGradleOptions;
    @NotNull
    private final Multimap<String, String> myLastBuildTasks;
    @NotNull
    private final BuildStopper myBuildStopper;

    @NotNull
    public static GradleBuildInvoker getInstance(@NotNull Project project) {
        if (project == null) {
            GradleBuildInvoker.$$$reportNull$$$0(0);
        }
        GradleBuildInvoker gradleBuildInvoker = (GradleBuildInvoker)ServiceManager.getService((Project)project, GradleBuildInvoker.class);
        if (gradleBuildInvoker == null) {
            GradleBuildInvoker.$$$reportNull$$$0(1);
        }
        return gradleBuildInvoker;
    }

    public GradleBuildInvoker(@NotNull Project project, @NotNull FileDocumentManager documentManager) {
        if (project == null) {
            GradleBuildInvoker.$$$reportNull$$$0(2);
        }
        if (documentManager == null) {
            GradleBuildInvoker.$$$reportNull$$$0(3);
        }
        this(project, documentManager, new GradleTasksExecutorFactory());
    }

    @VisibleForTesting
    protected GradleBuildInvoker(@NotNull Project project, @NotNull FileDocumentManager documentManager, @NotNull GradleTasksExecutorFactory tasksExecutorFactory) {
        if (project == null) {
            GradleBuildInvoker.$$$reportNull$$$0(4);
        }
        if (documentManager == null) {
            GradleBuildInvoker.$$$reportNull$$$0(5);
        }
        if (tasksExecutorFactory == null) {
            GradleBuildInvoker.$$$reportNull$$$0(6);
        }
        this.myAfterTasks = new LinkedHashSet<AfterGradleInvocationTask>();
        this.myOneTimeGradleOptions = new ArrayList<String>();
        this.myLastBuildTasks = ArrayListMultimap.create();
        this.myBuildStopper = new BuildStopper();
        this.myProject = project;
        this.myDocumentManager = documentManager;
        this.myTaskExecutorFactory = tasksExecutorFactory;
    }

    public void cleanProject() {
        Ref cancelClean = new Ref((Object)false);
        ApplicationManager.getApplication().invokeAndWait(() -> cancelClean.set((Object)this.stopNativeDebuggingOrCancel()), ModalityState.NON_MODAL);
        if (((Boolean)cancelClean.get()).booleanValue()) {
            return;
        }
        this.setProjectBuildMode(BuildMode.CLEAN);
        Module[] modules = ModuleManager.getInstance((Project)this.myProject).getModules();
        File projectPath = Projects.getBaseDirPath((Project)this.myProject);
        ListMultimap<Path, String> tasks = GradleTaskFinder.getInstance().findTasksToExecute(projectPath, modules, BuildMode.SOURCE_GEN, TestCompileType.NONE);
        tasks.keys().elementSet().forEach(key -> tasks.get(key).add(0, "clean"));
        for (Path rootPath : tasks.keySet()) {
            this.executeTasks(rootPath.toFile(), tasks.get((Object)rootPath), Collections.singletonList(GradleBuildInvoker.createGenerateSourcesOnlyProperty()));
        }
    }

    public void cleanAndGenerateSources() {
        this.generateSources(true);
    }

    public void generateSources() {
        this.generateSources(false);
    }

    private void generateSources(boolean cleanProject) {
        BuildMode buildMode = BuildMode.SOURCE_GEN;
        this.setProjectBuildMode(buildMode);
        Module[] modules = ModuleManager.getInstance((Project)this.myProject).getModules();
        File projectPath = Projects.getBaseDirPath((Project)this.myProject);
        ListMultimap<Path, String> tasks = GradleTaskFinder.getInstance().findTasksToExecute(projectPath, modules, buildMode, TestCompileType.NONE);
        if (cleanProject) {
            Ref cancelClean = new Ref((Object)false);
            ApplicationManager.getApplication().invokeAndWait(() -> cancelClean.set((Object)this.stopNativeDebuggingOrCancel()), ModalityState.NON_MODAL);
            if (((Boolean)cancelClean.get()).booleanValue()) {
                return;
            }
            tasks.keys().elementSet().forEach(key -> tasks.get(key).add(0, "clean"));
        }
        for (Path rootPath : tasks.keySet()) {
            this.executeTasks(rootPath.toFile(), tasks.get((Object)rootPath), Collections.singletonList(GradleBuildInvoker.createGenerateSourcesOnlyProperty()));
        }
    }

    @Nullable
    private XDebugSession getNativeDebugSession() {
        for (XDebugSession session : XDebuggerManager.getInstance((Project)this.myProject).getDebugSessions()) {
            XDebugProcess debugProcess = session.getDebugProcess();
            if (!(debugProcess instanceof AndroidNativeDebugProcess)) continue;
            return session;
        }
        return null;
    }

    private boolean stopNativeDebuggingOrCancel() {
        int res;
        XDebugSession session = this.getNativeDebugSession();
        if (session == null) {
            return false;
        }
        String propKey = "gradle.project.build.invoker.clean-terminates-debugger";
        String value = PropertiesComponent.getInstance().getValue("gradle.project.build.invoker.clean-terminates-debugger");
        if (value == null) {
            res = ((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.yesNoCancel((String)"Terminate debugging", (String)"Cleaning or rebuilding your project while debugging can lead to unexpected behavior.\nYou can choose to either terminate the debugger before cleaning your project or keep debugging while cleaning.\nClicking \"Cancel\" stops Gradle from cleaning or rebuilding your project, and preserves your debug process.").project(this.myProject)).yesText("Terminate")).noText("Do not terminate")).cancelText("Cancel").doNotAsk((DialogWrapper.DoNotAskOption)new DialogWrapper.DoNotAskOption.Adapter(){

                public void rememberChoice(boolean isSelected, int exitCode) {
                    if (isSelected) {
                        PropertiesComponent.getInstance().setValue("gradle.project.build.invoker.clean-terminates-debugger", Boolean.toString(exitCode == 0));
                    }
                }
            })).show();
        } else {
            GradleBuildInvoker.getLogger().info("gradle.project.build.invoker.clean-terminates-debugger: " + value);
            res = value.equals("true") ? 0 : 1;
        }
        switch (res) {
            case 0: {
                session.stop();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    @NotNull
    private static String createGenerateSourcesOnlyProperty() {
        String string = AndroidGradleSettings.createProjectProperty((String)"android.injected.generateSourcesOnly", (boolean)true);
        if (string == null) {
            GradleBuildInvoker.$$$reportNull$$$0(7);
        }
        return string;
    }

    public void compileJava(@NotNull Module[] modules, @NotNull TestCompileType testCompileType) {
        if (modules == null) {
            GradleBuildInvoker.$$$reportNull$$$0(8);
        }
        if (testCompileType == null) {
            GradleBuildInvoker.$$$reportNull$$$0(9);
        }
        BuildMode buildMode = BuildMode.COMPILE_JAVA;
        this.setProjectBuildMode(buildMode);
        File projectPath = Projects.getBaseDirPath((Project)this.myProject);
        ListMultimap<Path, String> tasks = GradleTaskFinder.getInstance().findTasksToExecute(projectPath, modules, buildMode, testCompileType);
        for (Path rootPath : tasks.keySet()) {
            this.executeTasks(rootPath.toFile(), tasks.get((Object)rootPath));
        }
    }

    public void assemble(@NotNull Module[] modules, @NotNull TestCompileType testCompileType) {
        if (modules == null) {
            GradleBuildInvoker.$$$reportNull$$$0(10);
        }
        if (testCompileType == null) {
            GradleBuildInvoker.$$$reportNull$$$0(11);
        }
        this.assemble(modules, testCompileType, Collections.emptyList(), null);
    }

    public void assemble(@NotNull Module[] modules, @NotNull TestCompileType testCompileType, @NotNull List<String> arguments, @Nullable BuildAction<?> buildAction) {
        if (modules == null) {
            GradleBuildInvoker.$$$reportNull$$$0(12);
        }
        if (testCompileType == null) {
            GradleBuildInvoker.$$$reportNull$$$0(13);
        }
        if (arguments == null) {
            GradleBuildInvoker.$$$reportNull$$$0(14);
        }
        BuildMode buildMode = BuildMode.ASSEMBLE;
        this.setProjectBuildMode(buildMode);
        File projectPath = Projects.getBaseDirPath((Project)this.myProject);
        ListMultimap<Path, String> tasks = GradleTaskFinder.getInstance().findTasksToExecute(projectPath, modules, buildMode, testCompileType);
        for (Path rootPath : tasks.keySet()) {
            this.executeTasks(rootPath.toFile(), tasks.get((Object)rootPath), arguments, buildAction);
        }
    }

    public void rebuild() {
        BuildMode buildMode = BuildMode.REBUILD;
        this.setProjectBuildMode(buildMode);
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        File projectPath = Projects.getBaseDirPath((Project)this.myProject);
        ListMultimap<Path, String> tasks = GradleTaskFinder.getInstance().findTasksToExecute(projectPath, moduleManager.getModules(), buildMode, TestCompileType.NONE);
        for (Path rootPath : tasks.keySet()) {
            this.executeTasks(rootPath.toFile(), tasks.get((Object)rootPath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildWithTempOptions(@NotNull File buildFilePath, @NotNull List<String> options) {
        if (buildFilePath == null) {
            GradleBuildInvoker.$$$reportNull$$$0(15);
        }
        if (options == null) {
            GradleBuildInvoker.$$$reportNull$$$0(16);
        }
        this.myOneTimeGradleOptions.addAll(options);
        try {
            Collection tasks = this.myLastBuildTasks.get((Object)buildFilePath.getPath());
            if (tasks.isEmpty()) {
                this.rebuild();
            } else {
                ArrayList<String> tasksFromLastBuild = new ArrayList<String>(tasks);
                this.executeTasks(buildFilePath, tasksFromLastBuild);
            }
        }
        finally {
            this.myOneTimeGradleOptions.clear();
        }
    }

    private void setProjectBuildMode(@NotNull BuildMode buildMode) {
        if (buildMode == null) {
            GradleBuildInvoker.$$$reportNull$$$0(17);
        }
        BuildSettings.getInstance(this.myProject).setBuildMode(buildMode);
    }

    public void executeTasks(@NotNull List<String> gradleTasks) {
        if (gradleTasks == null) {
            GradleBuildInvoker.$$$reportNull$$$0(18);
        }
        File path = Projects.getBaseDirPath((Project)this.myProject);
        this.executeTasks(path, gradleTasks, this.myOneTimeGradleOptions);
    }

    public void executeTasks(@NotNull File buildFilePath, @NotNull List<String> gradleTasks) {
        if (buildFilePath == null) {
            GradleBuildInvoker.$$$reportNull$$$0(19);
        }
        if (gradleTasks == null) {
            GradleBuildInvoker.$$$reportNull$$$0(20);
        }
        this.executeTasks(buildFilePath, gradleTasks, this.myOneTimeGradleOptions);
    }

    public void executeTasks(@NotNull ListMultimap<Path, String> tasks, @Nullable BuildMode buildMode, @NotNull List<String> commandLineArguments, @Nullable BuildAction buildAction) {
        if (tasks == null) {
            GradleBuildInvoker.$$$reportNull$$$0(21);
        }
        if (commandLineArguments == null) {
            GradleBuildInvoker.$$$reportNull$$$0(22);
        }
        if (buildMode != null) {
            this.setProjectBuildMode(buildMode);
        }
        tasks.keys().elementSet().forEach(path -> {
            if (tasks == null) {
                GradleBuildInvoker.$$$reportNull$$$0(38);
            }
            if (commandLineArguments == null) {
                GradleBuildInvoker.$$$reportNull$$$0(39);
            }
            this.executeTasks(path.toFile(), tasks.get(path), commandLineArguments, buildAction);
        });
    }

    public void executeTasks(@NotNull File buildFilePath, @NotNull List<String> gradleTasks, @NotNull List<String> commandLineArguments) {
        if (buildFilePath == null) {
            GradleBuildInvoker.$$$reportNull$$$0(23);
        }
        if (gradleTasks == null) {
            GradleBuildInvoker.$$$reportNull$$$0(24);
        }
        if (commandLineArguments == null) {
            GradleBuildInvoker.$$$reportNull$$$0(25);
        }
        this.executeTasks(buildFilePath, gradleTasks, commandLineArguments, null);
    }

    public void executeTasks(@NotNull File buildFilePath, @NotNull List<String> gradleTasks, @NotNull List<String> commandLineArguments, @Nullable BuildAction buildAction) {
        if (buildFilePath == null) {
            GradleBuildInvoker.$$$reportNull$$$0(26);
        }
        if (gradleTasks == null) {
            GradleBuildInvoker.$$$reportNull$$$0(27);
        }
        if (commandLineArguments == null) {
            GradleBuildInvoker.$$$reportNull$$$0(28);
        }
        ArrayList<String> jvmArguments = new ArrayList<String>();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            File androidHomePath;
            LocalProperties localProperties;
            try {
                localProperties = new LocalProperties(this.myProject);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (localProperties.getAndroidSdkPath() == null && (androidHomePath = IdeSdks.getInstance().getAndroidSdkPath()) != null) {
                jvmArguments.add(AndroidGradleSettings.createAndroidHomeJvmArg((String)androidHomePath.getPath()));
            }
        }
        Request request = new Request(this.myProject, buildFilePath, gradleTasks);
        ExternalSystemTaskNotificationListener buildTaskListener = this.createBuildTaskListener(request, "Build");
        request.setJvmArguments(jvmArguments).setCommandLineArguments(commandLineArguments).setBuildAction(buildAction).setTaskListener(buildTaskListener);
        this.executeTasks(request);
    }

    @NotNull
    public ExternalSystemTaskNotificationListener createBuildTaskListener(final @NotNull Request request, final String executionName) {
        ExternalSystemTaskNotificationListenerAdapter externalSystemTaskNotificationListenerAdapter;
        block3: {
            if (request == null) {
                GradleBuildInvoker.$$$reportNull$$$0(29);
            }
            final BuildViewManager buildViewManager = (BuildViewManager)ServiceManager.getService((Project)this.myProject, BuildViewManager.class);
            final List<BuildOutputParser> buildOutputParsers = Arrays.asList(new JavacOutputParser(), new KotlincOutputParser(), new GradleBuildOutputParser());
            final BuildOutputInstantReaderImpl buildOutputInstantReader = new BuildOutputInstantReaderImpl((Object)request.myTaskId, (BuildProgressListener)buildViewManager, buildOutputParsers);
            try {
                externalSystemTaskNotificationListenerAdapter = new ExternalSystemTaskNotificationListenerAdapter(){
                    @NotNull
                    private BuildOutputInstantReaderImpl myReader;
                    {
                        this.myReader = buildOutputInstantReader;
                    }

                    public void onStart(final @NotNull ExternalSystemTaskId id, String workingDir) {
                        if (id == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        AnAction restartAction = new AnAction(){

                            public void update(@NotNull AnActionEvent e) {
                                if (e == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                super.update(e);
                                e.getPresentation().setEnabled(!GradleBuildInvoker.this.myBuildStopper.contains(id));
                            }

                            public void actionPerformed(@NotNull AnActionEvent e) {
                                if (e == null) {
                                    1.$$$reportNull$$$0(1);
                                }
                                myReader.close();
                                myReader = new BuildOutputInstantReaderImpl((Object)request.myTaskId, (BuildProgressListener)buildViewManager, buildOutputParsers);
                                GradleBuildInvoker.this.executeTasks(request);
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                Object[] objectArray;
                                Object[] objectArray2 = new Object[3];
                                objectArray2[0] = "e";
                                objectArray2[1] = "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$2$1";
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "update";
                                        break;
                                    }
                                    case 1: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "actionPerformed";
                                        break;
                                    }
                                }
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                            }
                        };
                        Presentation presentation = restartAction.getTemplatePresentation();
                        presentation.setText("Restart");
                        presentation.setDescription("Restart");
                        presentation.setIcon(AllIcons.Actions.Compile);
                        long eventTime = System.currentTimeMillis();
                        StartBuildEventImpl event = new StartBuildEventImpl((BuildDescriptor)new DefaultBuildDescriptor((Object)id, executionName, workingDir, eventTime), "running...");
                        event.withRestartAction(restartAction).withExecutionFilter((Filter)new AndroidReRunBuildFilter(workingDir));
                        buildViewManager.onEvent((BuildEvent)event);
                    }

                    public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
                        if (event == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        if (event instanceof ExternalSystemTaskExecutionEvent) {
                            BuildEvent buildEvent = ExternalSystemUtil.convert((ExternalSystemTaskExecutionEvent)((ExternalSystemTaskExecutionEvent)event));
                            buildViewManager.onEvent(buildEvent);
                        }
                    }

                    public void onTaskOutput(@NotNull ExternalSystemTaskId id, @NotNull String text, boolean stdOut) {
                        if (id == null) {
                            2.$$$reportNull$$$0(2);
                        }
                        if (text == null) {
                            2.$$$reportNull$$$0(3);
                        }
                        buildViewManager.onEvent((BuildEvent)new OutputBuildEventImpl((Object)id, text, stdOut));
                        this.myReader.append((CharSequence)text);
                    }

                    public void onEnd(@NotNull ExternalSystemTaskId id) {
                        if (id == null) {
                            2.$$$reportNull$$$0(4);
                        }
                        this.myReader.close();
                    }

                    public void onSuccess(@NotNull ExternalSystemTaskId id) {
                        if (id == null) {
                            2.$$$reportNull$$$0(5);
                        }
                        FinishBuildEventImpl event = new FinishBuildEventImpl((Object)id, null, System.currentTimeMillis(), "completed successfully", (EventResult)new SuccessResultImpl());
                        buildViewManager.onEvent((BuildEvent)event);
                    }

                    public void onFailure(@NotNull ExternalSystemTaskId id, @NotNull Exception e) {
                        if (id == null) {
                            2.$$$reportNull$$$0(6);
                        }
                        if (e == null) {
                            2.$$$reportNull$$$0(7);
                        }
                        String title = executionName + " failed";
                        FailureResultImpl failureResult = ExternalSystemUtil.createFailureResult((String)title, (Exception)e, (ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (Project)GradleBuildInvoker.this.myProject);
                        buildViewManager.onEvent((BuildEvent)new FinishBuildEventImpl((Object)id, null, System.currentTimeMillis(), "build failed", (EventResult)failureResult));
                    }

                    public void onCancel(@NotNull ExternalSystemTaskId id) {
                        if (id == null) {
                            2.$$$reportNull$$$0(8);
                        }
                        super.onCancel(id);
                        FinishBuildEventImpl event = new FinishBuildEventImpl((Object)id, null, System.currentTimeMillis(), "cancelled", (EventResult)new SkippedResultImpl());
                        buildViewManager.onEvent((BuildEvent)event);
                        this.myReader.close();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "id";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "event";
                                break;
                            }
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "text";
                                break;
                            }
                            case 7: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "e";
                                break;
                            }
                        }
                        objectArray2[1] = "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$2";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onStart";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onStatusChange";
                                break;
                            }
                            case 2: 
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onTaskOutput";
                                break;
                            }
                            case 4: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onEnd";
                                break;
                            }
                            case 5: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onSuccess";
                                break;
                            }
                            case 6: 
                            case 7: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onFailure";
                                break;
                            }
                            case 8: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onCancel";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                if (externalSystemTaskNotificationListenerAdapter != null) break block3;
            }
            catch (Exception ignored) {
                buildOutputInstantReader.close();
                throw ignored;
            }
            GradleBuildInvoker.$$$reportNull$$$0(30);
        }
        return externalSystemTaskNotificationListenerAdapter;
    }

    public void executeTasks(@NotNull Request request) {
        if (request == null) {
            GradleBuildInvoker.$$$reportNull$$$0(31);
        }
        String buildFilePath = request.myBuildFilePath.getPath();
        this.myLastBuildTasks.removeAll((Object)buildFilePath);
        List<String> gradleTasks = request.getGradleTasks();
        this.myLastBuildTasks.putAll((Object)buildFilePath, gradleTasks);
        GradleBuildInvoker.getLogger().info("About to execute Gradle tasks: " + gradleTasks);
        if (gradleTasks.isEmpty()) {
            return;
        }
        GradleTasksExecutor executor = this.myTaskExecutorFactory.create(request, this.myBuildStopper);
        Runnable executeTasksTask = () -> {
            this.myDocumentManager.saveAllDocuments();
            executor.queue();
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            executeTasksTask.run();
        } else if (request.isWaitForCompletion()) {
            executor.queueAndWaitForCompletion();
        } else {
            TransactionGuard.getInstance().submitTransactionAndWait(executeTasksTask);
        }
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(GradleBuildInvoker.class);
        if (logger == null) {
            GradleBuildInvoker.$$$reportNull$$$0(32);
        }
        return logger;
    }

    public boolean stopBuild(@NotNull ExternalSystemTaskId id) {
        if (id == null) {
            GradleBuildInvoker.$$$reportNull$$$0(33);
        }
        if (this.myBuildStopper.contains(id)) {
            this.myBuildStopper.attemptToStopBuild(id, null);
            return true;
        }
        return false;
    }

    public void add(@NotNull AfterGradleInvocationTask task) {
        if (task == null) {
            GradleBuildInvoker.$$$reportNull$$$0(34);
        }
        this.myAfterTasks.add(task);
    }

    @VisibleForTesting
    @NotNull
    protected AfterGradleInvocationTask[] getAfterInvocationTasks() {
        AfterGradleInvocationTask[] afterGradleInvocationTaskArray = this.myAfterTasks.toArray(new AfterGradleInvocationTask[this.myAfterTasks.size()]);
        if (afterGradleInvocationTaskArray == null) {
            GradleBuildInvoker.$$$reportNull$$$0(35);
        }
        return afterGradleInvocationTaskArray;
    }

    public void remove(@NotNull AfterGradleInvocationTask task) {
        if (task == null) {
            GradleBuildInvoker.$$$reportNull$$$0(36);
        }
        this.myAfterTasks.remove(task);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            GradleBuildInvoker.$$$reportNull$$$0(37);
        }
        return project;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: 
            case 30: 
            case 32: 
            case 35: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: 
            case 30: 
            case 32: 
            case 35: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 30: 
            case 32: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasksExecutorFactory";
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testCompileType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 15: 
            case 19: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFilePath";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildMode";
                break;
            }
            case 18: 
            case 20: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleTasks";
                break;
            }
            case 21: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 22: 
            case 25: 
            case 28: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineArguments";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createGenerateSourcesOnlyProperty";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuildTaskListener";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getAfterInvocationTasks";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 7: 
            case 30: 
            case 32: 
            case 35: 
            case 37: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "compileJava";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "assemble";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "rebuildWithTempOptions";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setProjectBuildMode";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "executeTasks";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createBuildTaskListener";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "stopBuild";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "lambda$executeTasks$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: 
            case 30: 
            case 32: 
            case 35: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Request {
        @NotNull
        private final Project myProject;
        @NotNull
        private final File myBuildFilePath;
        @NotNull
        private final List<String> myGradleTasks;
        @NotNull
        private final List<String> myJvmArguments;
        @NotNull
        private final List<String> myCommandLineArguments;
        @NotNull
        private final Map<String, String> myEnv;
        private boolean myPassParentEnvs;
        @NotNull
        private final ExternalSystemTaskId myTaskId;
        @Nullable
        private ExternalSystemTaskNotificationListener myTaskListener;
        @Nullable
        private BuildAction myBuildAction;
        private boolean myWaitForCompletion;

        public Request(@NotNull Project project, @NotNull File buildFilePath, String ... gradleTasks) {
            if (project == null) {
                Request.$$$reportNull$$$0(0);
            }
            if (buildFilePath == null) {
                Request.$$$reportNull$$$0(1);
            }
            if (gradleTasks == null) {
                Request.$$$reportNull$$$0(2);
            }
            this(project, buildFilePath, Arrays.asList(gradleTasks));
        }

        public Request(@NotNull Project project, @NotNull File buildFilePath, @NotNull List<String> gradleTasks) {
            if (project == null) {
                Request.$$$reportNull$$$0(3);
            }
            if (buildFilePath == null) {
                Request.$$$reportNull$$$0(4);
            }
            if (gradleTasks == null) {
                Request.$$$reportNull$$$0(5);
            }
            this(project, buildFilePath, gradleTasks, ExternalSystemTaskId.create((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.EXECUTE_TASK, (Project)project));
        }

        public Request(@NotNull Project project, @NotNull File buildFilePath, @NotNull List<String> gradleTasks, @NotNull ExternalSystemTaskId taskId) {
            if (project == null) {
                Request.$$$reportNull$$$0(6);
            }
            if (buildFilePath == null) {
                Request.$$$reportNull$$$0(7);
            }
            if (gradleTasks == null) {
                Request.$$$reportNull$$$0(8);
            }
            if (taskId == null) {
                Request.$$$reportNull$$$0(9);
            }
            this.myPassParentEnvs = true;
            this.myProject = project;
            this.myBuildFilePath = buildFilePath;
            this.myGradleTasks = new ArrayList<String>(gradleTasks);
            this.myJvmArguments = new ArrayList<String>();
            this.myCommandLineArguments = new ArrayList<String>();
            this.myTaskId = taskId;
            this.myEnv = new LinkedHashMap<String, String>();
        }

        @NotNull
        Project getProject() {
            Project project = this.myProject;
            if (project == null) {
                Request.$$$reportNull$$$0(10);
            }
            return project;
        }

        @NotNull
        List<String> getGradleTasks() {
            List<String> list = this.myGradleTasks;
            if (list == null) {
                Request.$$$reportNull$$$0(11);
            }
            return list;
        }

        @NotNull
        List<String> getJvmArguments() {
            List<String> list = this.myJvmArguments;
            if (list == null) {
                Request.$$$reportNull$$$0(12);
            }
            return list;
        }

        @NotNull
        public Request setJvmArguments(@NotNull List<String> jvmArguments) {
            if (jvmArguments == null) {
                Request.$$$reportNull$$$0(13);
            }
            this.myJvmArguments.clear();
            this.myJvmArguments.addAll(jvmArguments);
            Request request = this;
            if (request == null) {
                Request.$$$reportNull$$$0(14);
            }
            return request;
        }

        @NotNull
        List<String> getCommandLineArguments() {
            List<String> list = this.myCommandLineArguments;
            if (list == null) {
                Request.$$$reportNull$$$0(15);
            }
            return list;
        }

        @NotNull
        public Request setCommandLineArguments(@NotNull List<String> commandLineArguments) {
            if (commandLineArguments == null) {
                Request.$$$reportNull$$$0(16);
            }
            this.myCommandLineArguments.clear();
            this.myCommandLineArguments.addAll(commandLineArguments);
            Request request = this;
            if (request == null) {
                Request.$$$reportNull$$$0(17);
            }
            return request;
        }

        public Request withEnvironmentVariables(Map<String, String> envs) {
            this.myEnv.putAll(envs);
            return this;
        }

        public Map<String, String> getEnv() {
            return Collections.unmodifiableMap(this.myEnv);
        }

        public Request passParentEnvs(boolean passParentEnvs) {
            this.myPassParentEnvs = passParentEnvs;
            return this;
        }

        public boolean isPassParentEnvs() {
            return this.myPassParentEnvs;
        }

        @Nullable
        public ExternalSystemTaskNotificationListener getTaskListener() {
            return this.myTaskListener;
        }

        @NotNull
        public Request setTaskListener(@Nullable ExternalSystemTaskNotificationListener taskListener) {
            this.myTaskListener = taskListener;
            Request request = this;
            if (request == null) {
                Request.$$$reportNull$$$0(18);
            }
            return request;
        }

        @NotNull
        ExternalSystemTaskId getTaskId() {
            ExternalSystemTaskId externalSystemTaskId = this.myTaskId;
            if (externalSystemTaskId == null) {
                Request.$$$reportNull$$$0(19);
            }
            return externalSystemTaskId;
        }

        @NotNull
        File getBuildFilePath() {
            File file = this.myBuildFilePath;
            if (file == null) {
                Request.$$$reportNull$$$0(20);
            }
            return file;
        }

        boolean isWaitForCompletion() {
            return this.myWaitForCompletion;
        }

        @NotNull
        public Request waitForCompletion() {
            this.myWaitForCompletion = true;
            Request request = this;
            if (request == null) {
                Request.$$$reportNull$$$0(21);
            }
            return request;
        }

        @Nullable
        public BuildAction getBuildAction() {
            return this.myBuildAction;
        }

        @NotNull
        public Request setBuildAction(@Nullable BuildAction buildAction) {
            this.myBuildAction = buildAction;
            Request request = this;
            if (request == null) {
                Request.$$$reportNull$$$0(22);
            }
            return request;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request that = (Request)o;
            return Objects.equals(this.myBuildFilePath, that.myBuildFilePath) && Objects.equals(this.myGradleTasks, that.myGradleTasks) && Objects.equals(this.myJvmArguments, that.myJvmArguments) && Objects.equals(this.myCommandLineArguments, that.myCommandLineArguments);
        }

        public int hashCode() {
            return Objects.hash(this.myBuildFilePath, this.myGradleTasks, this.myJvmArguments, this.myCommandLineArguments);
        }

        public String toString() {
            return "RequestSettings{myBuildFilePath=" + this.myBuildFilePath + ", myGradleTasks=" + this.myGradleTasks + ", myJvmArguments=" + this.myJvmArguments + ", myCommandLineArguments=" + this.myCommandLineArguments + ", myBuildAction=" + this.myBuildAction + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildFilePath";
                    break;
                }
                case 2: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gradleTasks";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "taskId";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jvmArguments";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLineArguments";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGradleTasks";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getJvmArguments";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setJvmArguments";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommandLineArguments";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setCommandLineArguments";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setTaskListener";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTaskId";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBuildFilePath";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "waitForCompletion";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setBuildAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "setJvmArguments";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "setCommandLineArguments";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface AfterGradleInvocationTask {
        public void execute(@NotNull GradleInvocationResult var1);
    }
}

