/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.LegacyAndroidProjects;
import com.android.tools.idea.gradle.project.SupportedModuleChecker;
import com.android.tools.idea.gradle.project.build.GradleBuildContext;
import com.android.tools.idea.gradle.project.build.JpsBuildContext;
import com.android.tools.idea.gradle.project.build.PostProjectBuildTasksExecutor;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.project.AndroidProjectBuildNotifications;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.execution.RunConfigurationProducerService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.test.runner.AllInPackageGradleConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.TestClassGradleConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.TestMethodGradleConfigurationProducer;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class AndroidGradleProjectComponent
implements ProjectComponent {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleProjectInfo myGradleProjectInfo;
    @NotNull
    private final AndroidProjectInfo myAndroidProjectInfo;
    @NotNull
    private final ExternalSystemNotificationManager myNotificationManager;
    @NotNull
    private final GradleSyncInvoker myGradleSyncInvoker;
    @NotNull
    private final SupportedModuleChecker mySupportedModuleChecker;
    @NotNull
    private final IdeInfo myIdeInfo;
    @NotNull
    private final LegacyAndroidProjects myLegacyAndroidProjects;
    @Nullable
    private Disposable myDisposable;

    @NotNull
    public static AndroidGradleProjectComponent getInstance(@NotNull Project project) {
        if (project == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(0);
        }
        AndroidGradleProjectComponent component2 = (AndroidGradleProjectComponent)project.getComponent(AndroidGradleProjectComponent.class);
        assert (component2 != null);
        AndroidGradleProjectComponent androidGradleProjectComponent = component2;
        if (androidGradleProjectComponent == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(1);
        }
        return androidGradleProjectComponent;
    }

    public AndroidGradleProjectComponent(@NotNull Project project, @NotNull GradleProjectInfo gradleProjectInfo, @NotNull AndroidProjectInfo androidProjectInfo, @NotNull ExternalSystemNotificationManager notificationManager, @NotNull GradleSyncInvoker gradleSyncInvoker, @NotNull GradleBuildInvoker gradleBuildInvoker, @NotNull CompilerManager compilerManager, @NotNull SupportedModuleChecker supportedModuleChecker, @NotNull IdeInfo ideInfo) {
        if (project == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(2);
        }
        if (gradleProjectInfo == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(3);
        }
        if (androidProjectInfo == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(4);
        }
        if (notificationManager == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(5);
        }
        if (gradleSyncInvoker == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(6);
        }
        if (gradleBuildInvoker == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(7);
        }
        if (compilerManager == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(8);
        }
        if (supportedModuleChecker == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(9);
        }
        if (ideInfo == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(10);
        }
        this(project, gradleProjectInfo, androidProjectInfo, notificationManager, gradleSyncInvoker, gradleBuildInvoker, compilerManager, supportedModuleChecker, ideInfo, new LegacyAndroidProjects(project));
    }

    @VisibleForTesting
    public AndroidGradleProjectComponent(@NotNull Project project, @NotNull GradleProjectInfo gradleProjectInfo, @NotNull AndroidProjectInfo androidProjectInfo, @NotNull ExternalSystemNotificationManager notificationManager, @NotNull GradleSyncInvoker gradleSyncInvoker, @NotNull GradleBuildInvoker gradleBuildInvoker, @NotNull CompilerManager compilerManager, @NotNull SupportedModuleChecker supportedModuleChecker, @NotNull IdeInfo ideInfo, @NotNull LegacyAndroidProjects legacyAndroidProjects) {
        if (project == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(11);
        }
        if (gradleProjectInfo == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(12);
        }
        if (androidProjectInfo == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(13);
        }
        if (notificationManager == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(14);
        }
        if (gradleSyncInvoker == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(15);
        }
        if (gradleBuildInvoker == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(16);
        }
        if (compilerManager == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(17);
        }
        if (supportedModuleChecker == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(18);
        }
        if (ideInfo == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(19);
        }
        if (legacyAndroidProjects == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(20);
        }
        this.myProject = project;
        this.myGradleProjectInfo = gradleProjectInfo;
        this.myAndroidProjectInfo = androidProjectInfo;
        this.myNotificationManager = notificationManager;
        this.myGradleSyncInvoker = gradleSyncInvoker;
        this.mySupportedModuleChecker = supportedModuleChecker;
        this.myIdeInfo = ideInfo;
        this.myLegacyAndroidProjects = legacyAndroidProjects;
        compilerManager.addAfterTask(context -> {
            if (project == null) {
                AndroidGradleProjectComponent.$$$reportNull$$$0(21);
            }
            if (this.myGradleProjectInfo.isBuildWithGradle()) {
                PostProjectBuildTasksExecutor.getInstance(project).onBuildCompletion(context);
                JpsBuildContext newContext = new JpsBuildContext(context);
                AndroidProjectBuildNotifications.getInstance(this.myProject).notifyBuildComplete(newContext);
            }
            return true;
        });
        gradleBuildInvoker.add(result -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            PostProjectBuildTasksExecutor.getInstance(this.myProject).onBuildCompletion(result);
            GradleBuildContext newContext = new GradleBuildContext(result);
            AndroidProjectBuildNotifications.getInstance(this.myProject).notifyBuildComplete(newContext);
        });
    }

    public void projectOpened() {
        String error;
        if (this.myProject.isOpen() && StringUtil.isNotEmpty((String)(error = this.myGradleProjectInfo.getProjectCreationError()))) {
            Runnable processError = () -> this.myNotificationManager.processExternalProjectRefreshError((Throwable)new ExternalSystemException(error), this.myProject.getName(), GradleConstants.SYSTEM_ID);
            StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(processError);
            this.myGradleProjectInfo.setProjectCreationError(null);
        }
        this.mySupportedModuleChecker.checkForSupportedModules(this.myProject);
        GradleSyncState syncState = GradleSyncState.getInstance(this.myProject);
        if (syncState.isSyncInProgress()) {
            syncState.notifyStateChanged();
        }
        if (this.myIdeInfo.isAndroidStudio() && this.myAndroidProjectInfo.isLegacyIdeaAndroidProject() && !this.myAndroidProjectInfo.isApkProject()) {
            this.myLegacyAndroidProjects.trackProject();
            this.myLegacyAndroidProjects.showMigrateToGradleWarning();
            return;
        }
        if (this.myGradleProjectInfo.isBuildWithGradle()) {
            this.configureGradleProject();
        } else if (this.myIdeInfo.isAndroidStudio() && this.myProject.getBaseDir() != null && GradleProjects.canImportAsGradleProject(this.myProject.getBaseDir())) {
            this.myGradleSyncInvoker.requestProjectSyncAndSourceGeneration(this.myProject, GradleSyncStats.Trigger.TRIGGER_PROJECT_LOADED);
        }
    }

    public void configureGradleProject() {
        if (this.myDisposable != null) {
            return;
        }
        this.myDisposable = Disposer.newDisposable();
        if (IdeInfo.getInstance().isAndroidStudio()) {
            this.myProject.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, (Object)Boolean.TRUE);
        }
        ArrayList<Class<TestMethodGradleConfigurationProducer>> runConfigurationProducerTypes = new ArrayList<Class<TestMethodGradleConfigurationProducer>>();
        runConfigurationProducerTypes.add(AllInPackageGradleConfigurationProducer.class);
        runConfigurationProducerTypes.add(TestClassGradleConfigurationProducer.class);
        runConfigurationProducerTypes.add(TestMethodGradleConfigurationProducer.class);
        RunConfigurationProducerService runConfigurationProducerManager = RunConfigurationProducerService.getInstance((Project)this.myProject);
        if (this.myIdeInfo.isAndroidStudio()) {
            for (Class clazz : runConfigurationProducerTypes) {
                runConfigurationProducerManager.getState().ignoredProducers.add(clazz.getName());
            }
        } else {
            for (Class clazz : runConfigurationProducerTypes) {
                runConfigurationProducerManager.getState().ignoredProducers.remove(clazz.getName());
            }
        }
    }

    public void projectClosed() {
        if (this.myDisposable != null) {
            Disposer.dispose((Disposable)this.myDisposable);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/AndroidGradleProjectComponent";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProjectInfo";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidProjectInfo";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationManager";
                break;
            }
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleSyncInvoker";
                break;
            }
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleBuildInvoker";
                break;
            }
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerManager";
                break;
            }
            case 9: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedModuleChecker";
                break;
            }
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideInfo";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "legacyAndroidProjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/AndroidGradleProjectComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

