/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.parser;

import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.BuildFileKeyType;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.parser.ValueFactory;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;

class GradleGroovyFile {
    private static final Logger LOG = Logger.getInstance(GradleGroovyFile.class);
    protected final Project myProject;
    protected final VirtualFile myFile;
    protected GroovyFile myGroovyFile;

    GradleGroovyFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            GradleGroovyFile.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GradleGroovyFile.$$$reportNull$$$0(1);
        }
        this.myGroovyFile = null;
        this.myProject = project;
        this.myFile = file;
        this.reload();
    }

    public Project getProject() {
        return this.myProject;
    }

    static void reformatClosure(@NotNull GrStatementOwner closure) {
        if (closure == null) {
            GradleGroovyFile.$$$reportNull$$$0(2);
        }
        new ReformatCodeProcessor(closure.getProject(), closure.getContainingFile(), closure.getParent().getTextRange(), false).runWithoutProgress();
        for (PsiElement psiElement : closure.getChildren()) {
            String text;
            if (!(psiElement instanceof LeafPsiElement) || !StringUtil.isEmptyOrSpaces((String)(text = psiElement.getText()))) continue;
            String newText = text;
            while (newText.contains("\n\n")) {
                newText = newText.replaceAll("\n\n", "\n");
            }
            if (newText.equals(text)) continue;
            ((LeafPsiElement)psiElement).replaceWithText(newText);
        }
    }

    @Nullable
    static GrMethodCall createNewValue(@NotNull GrStatementOwner root, @NotNull BuildFileKey key, @Nullable Object value, boolean reformatClosure) {
        GrStatement[] parentStatements;
        if (root == null) {
            GradleGroovyFile.$$$reportNull$$$0(3);
        }
        if (key == null) {
            GradleGroovyFile.$$$reportNull$$$0(4);
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)root.getProject());
        String path = key.getPath();
        String[] parts = path.split("/");
        GrStatementOwner parent = root;
        for (int i = 0; i < parts.length - 1; ++i) {
            String part = parts[i];
            GrClosableBlock closure = GradleGroovyFile.getMethodClosureArgument(parent, part);
            if (closure == null) {
                parent.addStatementBefore(factory.createStatementFromText((CharSequence)(part + " {}")), null);
                closure = GradleGroovyFile.getMethodClosureArgument(parent, part);
                if (closure == null) {
                    return null;
                }
            }
            parent = closure;
        }
        String name = parts[parts.length - 1];
        String text = name + " " + key.getType().convertValueToExpression(value);
        GrStatement statementBefore = null;
        if (key.shouldInsertAtBeginning() && (parentStatements = parent.getStatements()).length > 0) {
            statementBefore = parentStatements[0];
        }
        parent.addStatementBefore(factory.createStatementFromText((CharSequence)text), statementBefore);
        if (reformatClosure) {
            GradleGroovyFile.reformatClosure(parent);
        }
        return GradleGroovyFile.getMethodCall(parent, name);
    }

    public void reload() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!GradleGroovyFile.this.myFile.exists()) {
                    LOG.warn("File " + GradleGroovyFile.this.myFile.getPath() + " no longer exists");
                    return;
                }
                PsiFile psiFile = PsiManager.getInstance((Project)GradleGroovyFile.this.myProject).findFile(GradleGroovyFile.this.myFile);
                if (psiFile == null) {
                    LOG.warn("Could not find PsiFile for " + GradleGroovyFile.this.myFile.getPath());
                    return;
                }
                if (!(psiFile instanceof GroovyFile)) {
                    LOG.warn("PsiFile " + psiFile.getName() + " is not a Groovy file");
                    return;
                }
                GradleGroovyFile.this.myGroovyFile = (GroovyFile)psiFile;
                GradleGroovyFile.this.onPsiFileAvailable();
            }
        };
        if (this.myProject.isInitialized()) {
            ApplicationManager.getApplication().runReadAction(runnable);
        } else {
            StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(runnable);
        }
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    public PsiFile getPsiFile() {
        return this.myGroovyFile;
    }

    protected void checkInitialized() {
        if (this.myGroovyFile == null) {
            throw new IllegalStateException("PsiFile not parsed for file " + this.myFile.getPath() + ". Wait until onPsiFileAvailable() is called.");
        }
    }

    protected void commitDocumentChanges() {
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        Document document = documentManager.getDocument((PsiFile)this.myGroovyFile);
        if (document != null) {
            documentManager.commitDocument(document);
        }
    }

    @Nullable
    protected static GrMethodCall getMethodCallByPath(@NotNull GrStatementOwner root, @NotNull String path) {
        if (root == null) {
            GradleGroovyFile.$$$reportNull$$$0(5);
        }
        if (path == null) {
            GradleGroovyFile.$$$reportNull$$$0(6);
        }
        if (path.isEmpty() || path.endsWith("/")) {
            return null;
        }
        int slash = path.indexOf(47);
        String pathElement = slash == -1 ? path : path.substring(0, slash);
        for (GrMethodCall gmc : GradleGroovyFile.getMethodCalls(root, pathElement)) {
            if (slash == -1) {
                return gmc;
            }
            if (gmc == null) {
                return null;
            }
            GrClosableBlock[] blocks = gmc.getClosureArguments();
            if (blocks.length != 1) {
                return null;
            }
            GrMethodCall subresult = GradleGroovyFile.getMethodCallByPath((GrStatementOwner)blocks[0], path.substring(slash + 1));
            if (subresult == null) continue;
            return subresult;
        }
        return null;
    }

    @NotNull
    protected static GroovyPsiElement[] getArguments(@NotNull GrCall gmc) {
        GrArgumentList argList;
        if (gmc == null) {
            GradleGroovyFile.$$$reportNull$$$0(7);
        }
        if ((argList = gmc.getArgumentList()) == null) {
            if (GroovyPsiElement.EMPTY_ARRAY == null) {
                GradleGroovyFile.$$$reportNull$$$0(8);
            }
            return GroovyPsiElement.EMPTY_ARRAY;
        }
        GroovyPsiElement[] groovyPsiElementArray = argList.getAllArguments();
        if (groovyPsiElementArray == null) {
            GradleGroovyFile.$$$reportNull$$$0(9);
        }
        return groovyPsiElementArray;
    }

    @Nullable
    protected static GroovyPsiElement getFirstArgument(@NotNull GrCall gmc) {
        GroovyPsiElement[] arguments;
        if (gmc == null) {
            GradleGroovyFile.$$$reportNull$$$0(10);
        }
        return (arguments = GradleGroovyFile.getArguments(gmc)).length > 0 ? arguments[0] : null;
    }

    @Nullable
    protected static String getSingleStringArgumentValue(@NotNull GrCall methodCall) {
        GroovyPsiElement argument;
        if (methodCall == null) {
            GradleGroovyFile.$$$reportNull$$$0(11);
        }
        if ((argument = GradleGroovyFile.getFirstArgument(methodCall)) instanceof GrLiteral) {
            Object value = ((GrLiteral)argument).getValue();
            return value instanceof String ? (String)value : null;
        }
        return null;
    }

    @Nullable
    protected static GrMethodCall getMethodCall(@NotNull GrStatementOwner parent, @NotNull String methodName) {
        if (parent == null) {
            GradleGroovyFile.$$$reportNull$$$0(12);
        }
        if (methodName == null) {
            GradleGroovyFile.$$$reportNull$$$0(13);
        }
        return (GrMethodCall)Iterables.getFirst(GradleGroovyFile.getMethodCalls(parent, methodName), null);
    }

    @NotNull
    protected static Iterable<GrMethodCall> getMethodCalls(@NotNull GrStatementOwner parent) {
        if (parent == null) {
            GradleGroovyFile.$$$reportNull$$$0(14);
        }
        Iterable iterable = Iterables.filter(Arrays.asList(parent.getStatements()), GrMethodCall.class);
        if (iterable == null) {
            GradleGroovyFile.$$$reportNull$$$0(15);
        }
        return iterable;
    }

    @NotNull
    protected static Iterable<GrMethodCall> getMethodCalls(@NotNull GrStatementOwner parent, final @NotNull String methodName) {
        if (parent == null) {
            GradleGroovyFile.$$$reportNull$$$0(16);
        }
        if (methodName == null) {
            GradleGroovyFile.$$$reportNull$$$0(17);
        }
        Iterable iterable = Iterables.filter(GradleGroovyFile.getMethodCalls(parent), (Predicate)new Predicate<GrMethodCall>(){

            public boolean apply(@Nullable GrMethodCall input) {
                return input != null && methodName.equals(GradleGroovyFile.getMethodCallName(input));
            }
        });
        if (iterable == null) {
            GradleGroovyFile.$$$reportNull$$$0(18);
        }
        return iterable;
    }

    @NotNull
    protected static String getMethodCallName(@NotNull GrMethodCall gmc) {
        GrExpression expression;
        if (gmc == null) {
            GradleGroovyFile.$$$reportNull$$$0(19);
        }
        String string = (expression = gmc.getInvokedExpression()).getText() != null ? expression.getText() : "";
        if (string == null) {
            GradleGroovyFile.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    protected static <E> Iterable<E> getTypedArguments(@NotNull GrArgumentList args, @NotNull Class<E> clazz) {
        if (args == null) {
            GradleGroovyFile.$$$reportNull$$$0(21);
        }
        if (clazz == null) {
            GradleGroovyFile.$$$reportNull$$$0(22);
        }
        Iterable iterable = Iterables.filter(Arrays.asList(args.getAllArguments()), clazz);
        if (iterable == null) {
            GradleGroovyFile.$$$reportNull$$$0(23);
        }
        return iterable;
    }

    @NotNull
    protected static Iterable<GrLiteral> getLiteralArguments(@NotNull GrMethodCall gmc) {
        if (gmc == null) {
            GradleGroovyFile.$$$reportNull$$$0(24);
        }
        GrArgumentList argumentList = gmc.getArgumentList();
        Iterable<GrLiteral> iterable = GradleGroovyFile.getTypedArguments(argumentList, GrLiteral.class);
        if (iterable == null) {
            GradleGroovyFile.$$$reportNull$$$0(25);
        }
        return iterable;
    }

    @NotNull
    protected static Iterable<Object> getLiteralArgumentValues(@NotNull GrMethodCall gmc) {
        if (gmc == null) {
            GradleGroovyFile.$$$reportNull$$$0(26);
        }
        Iterable iterable = Iterables.filter((Iterable)Iterables.transform(GradleGroovyFile.getLiteralArguments(gmc), (Function)new Function<GrLiteral, Object>(){

            public Object apply(@Nullable GrLiteral input) {
                return input != null ? input.getValue() : null;
            }
        }), (Predicate)Predicates.notNull());
        if (iterable == null) {
            GradleGroovyFile.$$$reportNull$$$0(27);
        }
        return iterable;
    }

    @NotNull
    protected static Map<String, Object> getNamedArgumentValues(@NotNull GrMethodCall gmc) {
        if (gmc == null) {
            GradleGroovyFile.$$$reportNull$$$0(28);
        }
        GrArgumentList argumentList = gmc.getArgumentList();
        HashMap values = Maps.newHashMap();
        for (GrNamedArgument grNamedArgument : GradleGroovyFile.getTypedArguments(argumentList, GrNamedArgument.class)) {
            values.put(grNamedArgument.getLabelName(), GradleGroovyFile.parseValueExpression(grNamedArgument.getExpression()));
        }
        HashMap hashMap = values;
        if (hashMap == null) {
            GradleGroovyFile.$$$reportNull$$$0(29);
        }
        return hashMap;
    }

    @Nullable
    protected static Object parseValueExpression(@Nullable GrExpression gre) {
        if (gre instanceof GrLiteral) {
            return ((GrLiteral)gre).getValue();
        }
        if (gre instanceof GrListOrMap) {
            GrListOrMap grLom = (GrListOrMap)gre;
            if (grLom.isMap()) {
                return null;
            }
            ArrayList values = Lists.newArrayList();
            for (GrExpression subexpression : grLom.getInitializers()) {
                Object subValue = GradleGroovyFile.parseValueExpression(subexpression);
                if (subValue == null) continue;
                values.add(subValue);
            }
            return values;
        }
        return null;
    }

    @NotNull
    protected static String convertMapToGroovySource(@NotNull Map<String, Object> map) {
        if (map == null) {
            GradleGroovyFile.$$$reportNull$$$0(30);
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(entry.getKey());
            sb.append(": ");
            sb.append(GradleGroovyFile.convertValueToGroovySource(entry.getValue()));
        }
        String string = sb.toString();
        if (string == null) {
            GradleGroovyFile.$$$reportNull$$$0(31);
        }
        return string;
    }

    @NotNull
    protected static String convertValueToGroovySource(@NotNull Object value) {
        if (value == null) {
            GradleGroovyFile.$$$reportNull$$$0(32);
        }
        if (value instanceof List) {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            for (Object v : (List)value) {
                if (sb.length() > 1) {
                    sb.append(", ");
                }
                sb.append(GradleGroovyFile.convertValueToGroovySource(v));
            }
            sb.append(']');
            String string = sb.toString();
            if (string == null) {
                GradleGroovyFile.$$$reportNull$$$0(33);
            }
            return string;
        }
        if (value instanceof Number || value instanceof Boolean) {
            String string = value.toString();
            if (string == null) {
                GradleGroovyFile.$$$reportNull$$$0(34);
            }
            return string;
        }
        String string = "'" + BuildFileKey.escapeLiteralString(value.toString()) + "'";
        if (string == null) {
            GradleGroovyFile.$$$reportNull$$$0(35);
        }
        return string;
    }

    @Nullable
    protected static Object getFirstLiteralArgumentValue(@NotNull GrMethodCall gmc) {
        GrLiteral lit;
        if (gmc == null) {
            GradleGroovyFile.$$$reportNull$$$0(36);
        }
        return (lit = GradleGroovyFile.getFirstLiteralArgument(gmc)) != null ? lit.getValue() : null;
    }

    @Nullable
    protected static GrLiteral getFirstLiteralArgument(@NotNull GrMethodCall gmc) {
        if (gmc == null) {
            GradleGroovyFile.$$$reportNull$$$0(37);
        }
        return (GrLiteral)Iterables.getFirst(GradleGroovyFile.getLiteralArguments(gmc), null);
    }

    @Nullable
    protected static GrClosableBlock getMethodClosureArgument(@NotNull GrStatementOwner parent, @NotNull String methodName) {
        GrMethodCall methodCall;
        if (parent == null) {
            GradleGroovyFile.$$$reportNull$$$0(38);
        }
        if (methodName == null) {
            GradleGroovyFile.$$$reportNull$$$0(39);
        }
        if ((methodCall = GradleGroovyFile.getMethodCall(parent, methodName)) == null) {
            return null;
        }
        return GradleGroovyFile.getMethodClosureArgument(methodCall);
    }

    @Nullable
    public static GrClosableBlock getMethodClosureArgument(@NotNull GrMethodCall methodCall) {
        if (methodCall == null) {
            GradleGroovyFile.$$$reportNull$$$0(40);
        }
        return (GrClosableBlock)Iterables.getFirst(Arrays.asList(methodCall.getClosureArguments()), null);
    }

    @Nullable
    static Object getValueStatic(@NotNull GrStatementOwner root, @NotNull BuildFileKey key) {
        GrClosableBlock arg;
        GrMethodCall method;
        if (root == null) {
            GradleGroovyFile.$$$reportNull$$$0(41);
        }
        if (key == null) {
            GradleGroovyFile.$$$reportNull$$$0(42);
        }
        if ((method = GradleGroovyFile.getMethodCallByPath(root, key.getPath())) == null) {
            return null;
        }
        Object object = arg = key.getType() == BuildFileKeyType.CLOSURE ? GradleGroovyFile.getMethodClosureArgument(method) : GradleGroovyFile.getFirstArgument((GrCall)method);
        if (arg == null) {
            return null;
        }
        return key.getValue((GroovyPsiElement)arg);
    }

    static void setValueStatic(@NotNull GrStatementOwner root, @NotNull BuildFileKey key, @NotNull Object value, boolean reformatClosure, @Nullable ValueFactory.KeyFilter filter) {
        if (root == null) {
            GradleGroovyFile.$$$reportNull$$$0(43);
        }
        if (key == null) {
            GradleGroovyFile.$$$reportNull$$$0(44);
        }
        if (value == null) {
            GradleGroovyFile.$$$reportNull$$$0(45);
        }
        if (value == GradleBuildFile.UNRECOGNIZED_VALUE) {
            return;
        }
        GrMethodCall method = GradleGroovyFile.getMethodCallByPath(root, key.getPath());
        if (method == null) {
            method = GradleGroovyFile.createNewValue(root, key, value, reformatClosure);
            if (key.getType() != BuildFileKeyType.CLOSURE) {
                return;
            }
        }
        if (method != null) {
            GrClosableBlock arg;
            Object object = arg = key.getType() == BuildFileKeyType.CLOSURE ? GradleGroovyFile.getMethodClosureArgument(method) : GradleGroovyFile.getFirstArgument((GrCall)method);
            if (arg == null) {
                return;
            }
            key.setValue((GroovyPsiElement)arg, value, filter);
        }
    }

    static void removeValueStatic(@NotNull GrStatementOwner root, @NotNull BuildFileKey key) {
        GrMethodCall method;
        if (root == null) {
            GradleGroovyFile.$$$reportNull$$$0(46);
        }
        if (key == null) {
            GradleGroovyFile.$$$reportNull$$$0(47);
        }
        if ((method = GradleGroovyFile.getMethodCallByPath(root, key.getPath())) != null) {
            method.delete();
        }
    }

    protected void onPsiFileAvailable() {
    }

    @NotNull
    public String toString() {
        if (this.myGroovyFile == null) {
            if ("<uninitialized>" == null) {
                GradleGroovyFile.$$$reportNull$$$0(48);
            }
            return "<uninitialized>";
        }
        ToStringPsiVisitor visitor = new ToStringPsiVisitor();
        this.myGroovyFile.accept((PsiElementVisitor)visitor);
        String string = this.myFile.getPath() + ":\n" + visitor.toString();
        if (string == null) {
            GradleGroovyFile.$$$reportNull$$$0(49);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 15: 
            case 18: 
            case 20: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 48: 
            case 49: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 15: 
            case 18: 
            case 20: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 48: 
            case 49: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
            case 3: 
            case 5: 
            case 41: 
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: 
            case 42: 
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: 
            case 10: 
            case 19: 
            case 24: 
            case 26: 
            case 28: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gmc";
                break;
            }
            case 8: 
            case 9: 
            case 15: 
            case 18: 
            case 20: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/parser/GradleGroovyFile";
                break;
            }
            case 11: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 13: 
            case 17: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 32: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/parser/GradleGroovyFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 15: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodCalls";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodCallName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypedArguments";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteralArguments";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteralArgumentValues";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamedArgumentValues";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "convertMapToGroovySource";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "convertValueToGroovySource";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reformatClosure";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createNewValue";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getMethodCallByPath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getArguments";
                break;
            }
            case 8: 
            case 9: 
            case 15: 
            case 18: 
            case 20: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 48: 
            case 49: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFirstArgument";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSingleStringArgumentValue";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getMethodCall";
                break;
            }
            case 14: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getMethodCalls";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getMethodCallName";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getTypedArguments";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getLiteralArguments";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getLiteralArgumentValues";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getNamedArgumentValues";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "convertMapToGroovySource";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "convertValueToGroovySource";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getFirstLiteralArgumentValue";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getFirstLiteralArgument";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getMethodClosureArgument";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getValueStatic";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "setValueStatic";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "removeValueStatic";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 15: 
            case 18: 
            case 20: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 48: 
            case 49: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ToStringPsiVisitor
    extends PsiRecursiveElementVisitor {
        private StringBuilder myString = new StringBuilder();

        private ToStringPsiVisitor() {
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                ToStringPsiVisitor.$$$reportNull$$$0(0);
            }
            PsiElement e = element;
            while (e.getParent() != null) {
                this.myString.append("  ");
                e = e.getParent();
            }
            this.myString.append(element.getClass().getName());
            this.myString.append(": ");
            this.myString.append(element.toString());
            if (element instanceof LeafPsiElement) {
                this.myString.append(" ");
                this.myString.append(element.getText());
            }
            this.myString.append("\n");
            super.visitElement(element);
        }

        @NotNull
        public String toString() {
            String string = this.myString.toString();
            if (string == null) {
                ToStringPsiVisitor.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/parser/GradleGroovyFile$ToStringPsiVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/parser/GradleGroovyFile$ToStringPsiVisitor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "visitElement";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

