/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.editor;

import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class GeneratedFileWritingAccessProvider
extends WritingAccessProvider {
    @NotNull
    private final GradleProjectInfo myProjectInfo;
    @NotNull
    private final ProjectFileIndex myProjectFileIndex;

    public GeneratedFileWritingAccessProvider(@NotNull GradleProjectInfo projectInfo, @NotNull ProjectFileIndex projectFileIndex) {
        if (projectInfo == null) {
            GeneratedFileWritingAccessProvider.$$$reportNull$$$0(0);
        }
        if (projectFileIndex == null) {
            GeneratedFileWritingAccessProvider.$$$reportNull$$$0(1);
        }
        this.myProjectInfo = projectInfo;
        this.myProjectFileIndex = projectFileIndex;
    }

    @NotNull
    public Collection<VirtualFile> requestWriting(VirtualFile ... files) {
        ArrayList<VirtualFile> readOnlyFiles = new ArrayList<VirtualFile>();
        for (VirtualFile file : files) {
            if (!this.isInBuildFolderAndNotSource(file)) continue;
            readOnlyFiles.add(file);
        }
        ArrayList<VirtualFile> arrayList = readOnlyFiles;
        if (arrayList == null) {
            GeneratedFileWritingAccessProvider.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public boolean isPotentiallyWritable(@NotNull VirtualFile file) {
        if (file == null) {
            GeneratedFileWritingAccessProvider.$$$reportNull$$$0(3);
        }
        return !this.isInBuildFolderAndNotSource(file);
    }

    private boolean isInBuildFolderAndNotSource(@NotNull VirtualFile file) {
        if (file == null) {
            GeneratedFileWritingAccessProvider.$$$reportNull$$$0(4);
        }
        if (this.myProjectFileIndex.isInSource(file)) {
            return false;
        }
        AndroidModuleModel androidModel = this.myProjectInfo.findAndroidModelInModule(file, false);
        if (androidModel == null) {
            return false;
        }
        File buildFolderPath = androidModel.getAndroidProject().getBuildFolder();
        VirtualFile buildFolder = VfsUtil.findFileByIoFile((File)buildFolderPath, (boolean)false);
        if (buildFolder == null || !buildFolder.isDirectory()) {
            return false;
        }
        return VfsUtilCore.isAncestor((VirtualFile)buildFolder, (VirtualFile)file, (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFileIndex";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/editor/GeneratedFileWritingAccessProvider";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/editor/GeneratedFileWritingAccessProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "requestWriting";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isPotentiallyWritable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isInBuildFolderAndNotSource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

