/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.groovy;

import com.android.tools.idea.gradle.dsl.parser.GradleDslWriter;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslReference;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.groovy.GroovyDslUtil;
import com.android.tools.idea.gradle.dsl.parser.java.JavaVersionDslElement;
import com.android.tools.idea.gradle.dsl.parser.java.LanguageLevelUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class GroovyDslWriter
implements GradleDslWriter {
    @Override
    public PsiElement createDslElement(@NotNull GradleDslElement element) {
        PsiElement addedElement;
        GrAssignmentExpression assignment;
        GroovyPsiElement psiElement;
        if (element == null) {
            GroovyDslWriter.$$$reportNull$$$0(0);
        }
        if ((psiElement = GroovyDslUtil.ensureGroovyPsi(element.getPsiElement())) != null) {
            return psiElement;
        }
        GradleDslElement parent = element.getParent();
        if (parent == null) {
            return null;
        }
        GroovyPsiElement parentPsiElement = GroovyDslUtil.ensureGroovyPsi(parent.create());
        if (parentPsiElement == null) {
            return null;
        }
        Project project = parentPsiElement.getProject();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)project);
        if (GroovyDslUtil.isNewEmptyBlockElement(element)) {
            return null;
        }
        String statementText = element.getName();
        statementText = element.isBlockElement() ? statementText + " {\n}\n" : (element.shouldUseAssignment() ? statementText + " = 'abc'" : statementText + "\"abc\", \"xyz\"");
        GrStatement statement = factory.createStatementFromText((CharSequence)statementText);
        if (statement instanceof GrApplicationStatement) {
            ((GrApplicationStatement)statement).getArgumentList().delete();
        } else if (statement instanceof GrAssignmentExpression && (assignment = (GrAssignmentExpression)statement).getRValue() != null) {
            assignment.getRValue().delete();
        }
        PsiElement lineTerminator = factory.createLineTerminator(1);
        if (parentPsiElement instanceof GroovyFile) {
            addedElement = parentPsiElement.addAfter((PsiElement)statement, parentPsiElement.getLastChild());
            parentPsiElement.addBefore(lineTerminator, addedElement);
        } else {
            addedElement = parentPsiElement.addBefore((PsiElement)statement, parentPsiElement.getLastChild());
            parentPsiElement.addAfter(lineTerminator, addedElement);
        }
        if (element.isBlockElement()) {
            GrClosableBlock closableBlock = GroovyDslUtil.getClosableBlock(addedElement);
            if (closableBlock != null) {
                element.setPsiElement((PsiElement)closableBlock);
            }
        } else if (addedElement instanceof GrApplicationStatement || addedElement instanceof GrAssignmentExpression) {
            element.setPsiElement(addedElement);
        }
        return element.getPsiElement();
    }

    @Override
    public void deleteDslElement(@NotNull GradleDslElement element) {
        PsiElement psiElement;
        if (element == null) {
            GroovyDslWriter.$$$reportNull$$$0(1);
        }
        if ((psiElement = element.getPsiElement()) == null || !psiElement.isValid()) {
            return;
        }
        PsiElement parent = psiElement.getParent();
        psiElement.delete();
        if (parent != null) {
            GroovyDslUtil.deleteIfEmpty(parent);
        }
        element.setPsiElement(null);
    }

    @Override
    public PsiElement createDslLiteral(@NotNull GradleDslLiteral literal) {
        GrNamedArgument addedNameArgument;
        GrLiteral grLiteral;
        GradleDslElement parent;
        if (literal == null) {
            GroovyDslWriter.$$$reportNull$$$0(2);
        }
        if (!((parent = literal.getParent()) instanceof GradleDslExpressionMap)) {
            return this.createDslElement(literal);
        }
        GroovyPsiElement parentPsiElement = GroovyDslUtil.ensureGroovyPsi(parent.create());
        if (parentPsiElement == null) {
            return null;
        }
        literal.setPsiElement((PsiElement)parentPsiElement);
        GrLiteral newLiteral = GroovyDslUtil.extractUnsavedLiteral(literal);
        if (newLiteral == null) {
            return null;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)newLiteral.getProject());
        GrNamedArgument namedArgument = factory.createNamedArgument(literal.getName(), (GrExpression)newLiteral);
        Object added = parentPsiElement instanceof GrArgumentList ? ((GrArgumentList)parentPsiElement).addNamedArgument(namedArgument) : parentPsiElement.addAfter((PsiElement)namedArgument, parentPsiElement.getLastChild());
        if (added instanceof GrNamedArgument && (grLiteral = (GrLiteral)PsiTreeUtil.getChildOfType((PsiElement)(addedNameArgument = added), GrLiteral.class)) != null) {
            literal.setExpression((PsiElement)grLiteral);
            literal.setModified(false);
            literal.reset();
            return literal.getPsiElement();
        }
        return null;
    }

    @Override
    public void applyDslLiteral(@NotNull GradleDslLiteral literal) {
        GroovyPsiElement psiElement;
        if (literal == null) {
            GroovyDslWriter.$$$reportNull$$$0(3);
        }
        if ((psiElement = GroovyDslUtil.ensureGroovyPsi(literal.getPsiElement())) == null) {
            return;
        }
        GrLiteral newLiteral = GroovyDslUtil.extractUnsavedLiteral(literal);
        if (newLiteral == null) {
            return;
        }
        GroovyPsiElement expression = GroovyDslUtil.ensureGroovyPsi(literal.getExpression());
        if (expression != null) {
            PsiElement replace = expression.replace((PsiElement)newLiteral);
            if (replace instanceof GrLiteral) {
                literal.setExpression(replace);
            }
        } else {
            PsiElement added = psiElement instanceof GrListOrMap || psiElement instanceof GrArgumentList && !(psiElement instanceof GrCommandArgumentList) ? psiElement.addBefore((PsiElement)newLiteral, psiElement.getLastChild()) : psiElement.addAfter((PsiElement)newLiteral, psiElement.getLastChild());
            if (added instanceof GrLiteral) {
                literal.setExpression(added);
            }
            if (literal.getUnsavedConfigBlock() != null) {
                GroovyDslUtil.addConfigBlock(literal);
            }
        }
        literal.reset();
        literal.setModified(false);
    }

    @Override
    public void deleteDslLiteral(@NotNull GradleDslLiteral literal) {
        PsiElement expression;
        if (literal == null) {
            GroovyDslWriter.$$$reportNull$$$0(4);
        }
        if ((expression = literal.getExpression()) == null) {
            return;
        }
        PsiElement parent = expression.getParent();
        expression.delete();
        GroovyDslUtil.deleteIfEmpty(parent);
    }

    @Override
    public PsiElement createDslReference(@NotNull GradleDslReference reference) {
        if (reference == null) {
            GroovyDslWriter.$$$reportNull$$$0(5);
        }
        return this.createDslElement(reference);
    }

    @Override
    public void applyDslReference(@NotNull GradleDslReference reference) {
        GroovyPsiElement psiElement;
        if (reference == null) {
            GroovyDslWriter.$$$reportNull$$$0(6);
        }
        if ((psiElement = GroovyDslUtil.ensureGroovyPsi(reference.getPsiElement())) == null) {
            return;
        }
        PsiElement newReference = GroovyDslUtil.extractUnsavedReference(reference);
        if (newReference == null) {
            return;
        }
        GroovyPsiElement expression = GroovyDslUtil.ensureGroovyPsi(reference.getExpression());
        if (expression != null) {
            PsiElement replace = expression.replace(newReference);
            reference.setExpression(replace);
        } else {
            PsiElement added = psiElement.addAfter(newReference, psiElement.getLastChild());
            reference.setExpression(added);
        }
        reference.reset();
        reference.setModified(false);
    }

    @Override
    public void deleteDslReference(@NotNull GradleDslReference reference) {
        PsiElement expression;
        if (reference == null) {
            GroovyDslWriter.$$$reportNull$$$0(7);
        }
        if ((expression = reference.getExpression()) == null) {
            return;
        }
        PsiElement parent = expression.getParent();
        expression.delete();
        GroovyDslUtil.deleteIfEmpty(parent);
    }

    @Override
    public PsiElement createDslMethodCall(@NotNull GradleDslMethodCall methodCall) {
        GrExpression[] expressionArguments;
        String statementText;
        PsiElement psiElement;
        if (methodCall == null) {
            GroovyDslWriter.$$$reportNull$$$0(8);
        }
        if ((psiElement = methodCall.getPsiElement()) != null) {
            return psiElement;
        }
        if (methodCall.getParent() == null) {
            return null;
        }
        PsiElement parentPsiElement = methodCall.getParent().create();
        if (parentPsiElement == null) {
            return null;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)parentPsiElement.getProject());
        GrStatement statement = factory.createStatementFromText((CharSequence)(statementText = (methodCall.getStatementName() != null ? methodCall.getStatementName() + " " : "") + methodCall.getName() + "()"));
        PsiElement addedElement = parentPsiElement.addBefore((PsiElement)statement, parentPsiElement.getLastChild());
        if (addedElement instanceof GrApplicationStatement && (expressionArguments = ((GrApplicationStatement)addedElement).getArgumentList().getExpressionArguments()).length == 1 && expressionArguments[0] instanceof GrMethodCallExpression) {
            methodCall.setPsiElement((PsiElement)expressionArguments[0]);
            return methodCall.getPsiElement();
        }
        if (addedElement instanceof GrMethodCallExpression) {
            methodCall.setPsiElement(addedElement);
            return methodCall.getPsiElement();
        }
        return null;
    }

    @Override
    public void applyDslMethodCall(@NotNull GradleDslMethodCall element) {
        PsiElement psiElement;
        if (element == null) {
            GroovyDslWriter.$$$reportNull$$$0(9);
        }
        if ((psiElement = element.getPsiElement()) instanceof GrMethodCallExpression) {
            GrMethodCallExpression methodCall = (GrMethodCallExpression)psiElement;
            GradleDslElement toBeAddedArgument = element.getToBeAddedArgument();
            if (toBeAddedArgument != null) {
                toBeAddedArgument.setPsiElement((PsiElement)methodCall.getArgumentList());
                toBeAddedArgument.applyChanges();
                element.commitNewArgument(toBeAddedArgument);
            }
        }
        for (GradleDslElement argument : element.getArguments()) {
            if (!argument.isModified()) continue;
            argument.applyChanges();
        }
    }

    @Override
    public PsiElement createDslExpressionList(@NotNull GradleDslExpressionList expressionList) {
        PsiElement psiElement;
        if (expressionList == null) {
            GroovyDslWriter.$$$reportNull$$$0(10);
        }
        if ((psiElement = expressionList.getPsiElement()) == null) {
            if (expressionList.getParent() instanceof GradleDslExpressionMap) {
                return GroovyDslUtil.createNamedArgumentList(expressionList);
            }
            psiElement = this.createDslElement(expressionList);
        }
        if (psiElement == null) {
            return null;
        }
        if (psiElement instanceof GrListOrMap) {
            return psiElement;
        }
        if (psiElement instanceof GrArgumentList) {
            if (!expressionList.getToBeAddedExpressions().isEmpty() && ((GrArgumentList)psiElement).getAllArguments().length == 1 && !expressionList.isAppendToArgumentListWithOneElement()) {
                expressionList.setPsiElement(null);
                psiElement = this.createDslElement(expressionList);
            } else {
                return psiElement;
            }
        }
        if (psiElement instanceof GrApplicationStatement) {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)psiElement.getProject());
            GrArgumentList argumentList = factory.createArgumentListFromText("xyz");
            argumentList.getFirstChild().delete();
            PsiElement added = psiElement.addAfter((PsiElement)argumentList, psiElement.getLastChild());
            if (added instanceof GrArgumentList) {
                GrArgumentList addedArgumentList = (GrArgumentList)added;
                expressionList.setPsiElement((PsiElement)addedArgumentList);
                return addedArgumentList;
            }
        }
        return null;
    }

    @Override
    public PsiElement createDslExpressionMap(@NotNull GradleDslExpressionMap expressionMap) {
        PsiElement psiElement;
        if (expressionMap == null) {
            GroovyDslWriter.$$$reportNull$$$0(11);
        }
        if ((psiElement = this.createDslElement(expressionMap)) == null) {
            return null;
        }
        if (psiElement instanceof GrListOrMap || psiElement instanceof GrArgumentList) {
            return psiElement;
        }
        if (psiElement instanceof GrApplicationStatement) {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)psiElement.getProject());
            GrArgumentList argumentList = factory.createArgumentListFromText("xyz");
            argumentList.getFirstChild().delete();
            PsiElement added = psiElement.addAfter((PsiElement)argumentList, psiElement.getLastChild());
            if (added instanceof GrArgumentList) {
                GrArgumentList addedArgumentList = (GrArgumentList)added;
                expressionMap.setPsiElement((PsiElement)addedArgumentList);
                return addedArgumentList;
            }
        }
        return null;
    }

    @Override
    public PsiElement createDslJavaVersionElement(@NotNull JavaVersionDslElement element) {
        GrExpression valuePsi;
        GrExpression newExpressionPsi;
        GroovyPsiElement psiElement;
        if (element == null) {
            GroovyDslWriter.$$$reportNull$$$0(12);
        }
        if ((psiElement = GroovyDslUtil.ensureGroovyPsi(GroovyDslUtil.extractCorrectJavaVersionPsiElement(element))) != null) {
            return psiElement;
        }
        GradlePropertiesDslElement parent = (GradlePropertiesDslElement)element.getParent();
        assert (parent != null);
        PsiElement javaPsiElement = parent.create();
        assert (javaPsiElement != null);
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)javaPsiElement.getProject());
        JavaVersionDslElement anchor = null;
        String name = element.getName();
        if ("sourceCompatibility".equals(name)) {
            anchor = parent.getPropertyElement("targetCompatibility", JavaVersionDslElement.class);
        } else if ("targetCompatibility".equals(name)) {
            anchor = parent.getPropertyElement("sourceCompatibility", JavaVersionDslElement.class);
        }
        PsiElement anchorPsiElement = null;
        String anchorText = null;
        if (anchor != null) {
            anchorPsiElement = anchor.getPsiElement();
            anchorText = anchor.getVersionText();
        }
        if (anchorPsiElement == null) {
            anchorPsiElement = javaPsiElement.getLastChild();
        }
        if (anchorText == null) {
            anchorText = "1.6";
        }
        if (element.shouldUseAssignment()) {
            GrExpression expression = factory.createExpressionFromText((CharSequence)(name + " = " + anchorText));
            newExpressionPsi = (GrExpression)javaPsiElement.addBefore((PsiElement)expression, anchorPsiElement);
            valuePsi = ((GrAssignmentExpression)newExpressionPsi).getRValue();
        } else {
            GrExpression expression = factory.createExpressionFromText((CharSequence)(name + " " + anchorText));
            newExpressionPsi = (GrExpression)javaPsiElement.addBefore((PsiElement)expression, anchorPsiElement);
            valuePsi = ((GrApplicationStatement)newExpressionPsi).getExpressionArguments()[0];
        }
        if (valuePsi instanceof GrLiteral) {
            element.setVersionElement(new GradleDslLiteral(parent, (PsiElement)newExpressionPsi, name, (PsiElement)valuePsi));
        } else if (valuePsi instanceof GrReferenceExpression) {
            element.setVersionElement(new GradleDslReference(parent, (PsiElement)newExpressionPsi, name, (PsiElement)valuePsi));
        }
        return element.getPsiElement();
    }

    @Override
    public void applyDslJavaVersionElement(@NotNull JavaVersionDslElement element) {
        if (element == null) {
            GroovyDslWriter.$$$reportNull$$$0(13);
        }
        PsiElement psiElement = GroovyDslUtil.extractCorrectJavaVersionPsiElement(element);
        LanguageLevel newValue = element.getUnsavedValue();
        if (newValue == null || psiElement == null) {
            return;
        }
        String groovyString = LanguageLevelUtil.convertToGradleString(newValue, element.getVersionText());
        GrExpression newVersionPsi = GroovyPsiElementFactory.getInstance((Project)psiElement.getProject()).createExpressionFromText((CharSequence)groovyString);
        GrExpression oldVersionPsi = element.shouldUseAssignment() ? ((GrAssignmentExpression)psiElement).getRValue() : ((GrApplicationStatement)psiElement).getExpressionArguments()[0];
        assert (oldVersionPsi != null);
        oldVersionPsi.replace((PsiElement)newVersionPsi);
    }

    @Override
    public void deleteDslJavaVersionElement(@NotNull JavaVersionDslElement element) {
        PsiElement psiElement;
        if (element == null) {
            GroovyDslWriter.$$$reportNull$$$0(14);
        }
        if ((psiElement = GroovyDslUtil.extractCorrectJavaVersionPsiElement(element)) != null) {
            PsiElement parent = psiElement.getParent();
            psiElement.delete();
            GroovyDslUtil.deleteIfEmpty(parent);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionList";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionMap";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/groovy/GroovyDslWriter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createDslElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteDslElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createDslLiteral";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "applyDslLiteral";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteDslLiteral";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createDslReference";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "applyDslReference";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteDslReference";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createDslMethodCall";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "applyDslMethodCall";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "createDslExpressionList";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "createDslExpressionMap";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "createDslJavaVersionElement";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "applyDslJavaVersionElement";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteDslJavaVersionElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

