/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.ext;

import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.api.ext.ReferenceTo;
import com.android.tools.idea.gradle.dsl.api.util.TypeReference;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslReference;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradlePropertyModelImpl
implements GradlePropertyModel {
    @NotNull
    private GradlePropertyModel.ValueType myValueType;
    @Nullable
    private GradleDslElement myElement;
    @NotNull
    private GradleDslElement myPropertyHolder;
    @NotNull
    private final PropertyType myPropertyType;
    @NotNull
    private String myName;

    public GradlePropertyModelImpl(@NotNull GradleDslElement element) {
        if (element == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(0);
        }
        this.myElement = element;
        GradleDslElement parent = element.getParent();
        assert (parent != null && (parent instanceof GradlePropertiesDslElement || parent instanceof GradleDslExpressionList)) : "Property found to be invalid, this should never happen!";
        this.myPropertyHolder = parent;
        this.myPropertyType = this.myElement.getElementType();
        this.myName = this.myElement.getName();
        this.myValueType = GradlePropertyModelImpl.extractAndGetValueType(this.myElement);
    }

    public GradlePropertyModelImpl(@NotNull GradlePropertiesDslElement element, @NotNull PropertyType type, @NotNull String name) {
        if (element == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(1);
        }
        if (type == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(2);
        }
        if (name == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(3);
        }
        this.myPropertyHolder = element;
        this.myPropertyType = type;
        this.myName = name;
        this.myValueType = GradlePropertyModel.ValueType.NONE;
    }

    @Override
    @NotNull
    public GradlePropertyModel.ValueType getValueType() {
        GradlePropertyModel.ValueType valueType = this.myValueType;
        if (valueType == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(4);
        }
        return valueType;
    }

    @Override
    @NotNull
    public PropertyType getPropertyType() {
        PropertyType propertyType = this.myPropertyType;
        if (propertyType == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(5);
        }
        return propertyType;
    }

    @Override
    @Nullable
    public <T> T getValue(@NotNull TypeReference<T> typeReference) {
        if (typeReference == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(6);
        }
        return this.extractValue(typeReference, true);
    }

    @Override
    public <T> T getRawValue(@NotNull TypeReference<T> typeReference) {
        if (typeReference == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(7);
        }
        return this.extractValue(typeReference, false);
    }

    @NotNull
    private Map<String, GradlePropertyModel> getMap() {
        if (this.myValueType != GradlePropertyModel.ValueType.MAP || !(this.myElement instanceof GradleDslExpressionMap)) {
            ImmutableMap immutableMap = ImmutableMap.of();
            if (immutableMap == null) {
                GradlePropertyModelImpl.$$$reportNull$$$0(8);
            }
            return immutableMap;
        }
        GradleDslExpressionMap map = (GradleDslExpressionMap)this.myElement;
        Map<String, GradlePropertyModel> map2 = map.getPropertyElements().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new GradlePropertyModelImpl((GradleDslElement)e.getValue())));
        if (map2 == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(9);
        }
        return map2;
    }

    @NotNull
    private List<GradlePropertyModel> getList() {
        if (this.myValueType != GradlePropertyModel.ValueType.LIST || !(this.myElement instanceof GradleDslExpressionList)) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                GradlePropertyModelImpl.$$$reportNull$$$0(10);
            }
            return immutableList;
        }
        GradleDslExpressionList list = (GradleDslExpressionList)this.myElement;
        List<GradlePropertyModel> list2 = list.getExpressions().stream().map(e -> new GradlePropertyModelImpl((GradleDslElement)e)).collect(Collectors.toList());
        if (list2 == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(11);
        }
        return list2;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    @NotNull
    public List<GradlePropertyModel> getDependencies() {
        if (this.myElement == null) {
            List<GradlePropertyModel> list = Collections.emptyList();
            if (list == null) {
                GradlePropertyModelImpl.$$$reportNull$$$0(13);
            }
            return list;
        }
        List<GradlePropertyModel> list = this.myElement.getResolvedVariables().stream().map(injection -> new GradlePropertyModelImpl(injection.getToBeInjected())).collect(Collectors.toList());
        if (list == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Override
    @NotNull
    public String getFullyQualifiedName() {
        String string = this.myPropertyHolder.getQualifiedName() + "." + this.myName;
        if (string == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Override
    @NotNull
    public VirtualFile getGradleFile() {
        VirtualFile virtualFile = this.myPropertyHolder.getDslFile().getFile();
        if (virtualFile == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(16);
        }
        return virtualFile;
    }

    @Override
    public void setValue(@NotNull Object value) {
        if (value == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(17);
        }
        if (this.myValueType == GradlePropertyModel.ValueType.MAP || this.myValueType == GradlePropertyModel.ValueType.LIST) {
            throw new UnsupportedOperationException("Setting map and list values are not supported!");
        }
        boolean isReference = value instanceof ReferenceTo;
        if (!(value instanceof Integer || value instanceof Boolean || value instanceof String || isReference)) {
            throw new UnsupportedOperationException("Only setting basic types are currently supported");
        }
        if (!isReference && this.myElement instanceof GradleDslLiteral || isReference && this.myElement instanceof GradleDslReference) {
            GradleDslExpression expression = (GradleDslExpression)this.myElement;
            expression.setValue(value);
        } else {
            this.delete();
            assert (this.myPropertyHolder instanceof GradlePropertiesDslElement);
            if (!isReference) {
                this.myElement = ((GradlePropertiesDslElement)this.myPropertyHolder).setNewLiteral(this.myName, value);
                this.myElement.setElementType(this.myPropertyType);
            } else {
                GradleDslReference newReference = new GradleDslReference(this.myPropertyHolder, this.myName);
                newReference.setValue(value);
                newReference.setElementType(this.myPropertyType);
                this.myElement = ((GradlePropertiesDslElement)this.myPropertyHolder).setNewElement(this.myName, newReference);
            }
        }
        this.myValueType = GradlePropertyModelImpl.extractAndGetValueType(this.myElement);
    }

    @Override
    public void delete() {
        if (this.myElement == null) {
            return;
        }
        if (this.myPropertyHolder instanceof GradlePropertiesDslElement) {
            ((GradlePropertiesDslElement)this.myPropertyHolder).removeProperty(this.myElement.getName());
        } else {
            assert (this.myPropertyHolder instanceof GradleDslExpressionList);
            ((GradleDslExpressionList)this.myPropertyHolder).removeElement(this.myElement);
        }
        this.myElement = null;
        this.myValueType = GradlePropertyModel.ValueType.NONE;
    }

    public String toString() {
        return String.format("[Element: %1$s, Type: %2$s, ValueType: %3$s]@%4$s", new Object[]{this.myElement, this.myPropertyType, this.myValueType.toString(), Integer.toHexString(this.hashCode())});
    }

    private static GradlePropertyModel.ValueType extractAndGetValueType(@NotNull GradleDslElement element) {
        if (element == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(18);
        }
        if (element instanceof GradleDslExpressionMap) {
            return GradlePropertyModel.ValueType.MAP;
        }
        if (element instanceof GradleDslExpressionList) {
            return GradlePropertyModel.ValueType.LIST;
        }
        if (element instanceof GradleDslReference) {
            return GradlePropertyModel.ValueType.REFERENCE;
        }
        if (element instanceof GradleDslExpression) {
            GradleDslExpression expression = (GradleDslExpression)element;
            Object value = expression.getValue();
            if (value instanceof Boolean) {
                return GradlePropertyModel.ValueType.BOOLEAN;
            }
            if (value instanceof Integer) {
                return GradlePropertyModel.ValueType.INTEGER;
            }
            if (value instanceof String) {
                return GradlePropertyModel.ValueType.STRING;
            }
            return GradlePropertyModel.ValueType.UNKNOWN;
        }
        throw new IllegalArgumentException("Can't create property model from given GradleDslElement: " + element);
    }

    @Nullable
    private <T> T extractValue(@NotNull TypeReference<T> typeReference, boolean resolved) {
        Object value;
        if (typeReference == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(19);
        }
        if (this.myElement == null) {
            return null;
        }
        if (this.myValueType == GradlePropertyModel.ValueType.MAP) {
            Map<String, GradlePropertyModel> value2 = this.getMap();
            return typeReference.castTo(value2);
        }
        if (this.myValueType == GradlePropertyModel.ValueType.LIST) {
            List<GradlePropertyModel> value3 = this.getList();
            return typeReference.castTo(value3);
        }
        if (this.myValueType == GradlePropertyModel.ValueType.REFERENCE) {
            GradleDslReference ref = (GradleDslReference)this.myElement;
            String refText = ref.getReferenceText();
            return refText == null ? null : (T)typeReference.castTo(refText);
        }
        GradleDslExpression expression = (GradleDslExpression)this.myElement;
        Object object = value = resolved ? expression.getValue() : expression.getUnresolvedValue();
        if (value == null) {
            return null;
        }
        return typeReference.castTo(value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/ext/GradlePropertyModelImpl";
                break;
            }
            case 6: 
            case 7: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeReference";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/ext/GradlePropertyModelImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyType";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMap";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getList";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullyQualifiedName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradleFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRawValue";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "extractAndGetValueType";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "extractValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

