/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fonts;

import com.android.ide.common.fonts.FontDetail;
import com.android.ide.common.fonts.FontFamily;
import com.android.ide.common.fonts.FontProvider;
import com.android.ide.common.fonts.FontSource;
import com.android.ide.common.fonts.MutableFontDetail;
import com.android.ide.common.fonts.QueryParser;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ResourceValueMap;
import com.android.resources.ResourceType;
import com.android.tools.idea.fonts.DownloadableFontCacheService;
import com.android.tools.idea.fonts.FontFamilyParser;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectFonts {
    private final DownloadableFontCacheService myService = DownloadableFontCacheService.getInstance();
    private final ResourceResolver myResolver;
    private final Map<String, FontFamily> myProjectFonts;
    private final Map<String, QueryParser.ParseResult> myParseResults;
    private final List<String> myDefinitions;

    public ProjectFonts(@Nullable ResourceResolver resolver) {
        this.myResolver = resolver;
        this.myProjectFonts = new TreeMap<String, FontFamily>();
        this.myParseResults = new HashMap<String, QueryParser.ParseResult>();
        this.myDefinitions = new ArrayList<String>();
    }

    @NotNull
    public List<FontFamily> getFonts() {
        if (this.myResolver == null) {
            List<FontFamily> list = Collections.emptyList();
            if (list == null) {
                ProjectFonts.$$$reportNull$$$0(0);
            }
            return list;
        }
        ArrayList<FontFamily> fonts = new ArrayList<FontFamily>();
        ResourceValueMap myFonts = (ResourceValueMap)this.myResolver.getProjectResources().get(ResourceType.FONT);
        List names = myFonts.keySet().stream().sorted().collect(Collectors.toList());
        for (String name : names) {
            fonts.add(this.resolveFont("@font/" + name));
        }
        ArrayList<FontFamily> arrayList = fonts;
        if (arrayList == null) {
            ProjectFonts.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public FontFamily getFont(@NotNull String name) {
        if (name == null) {
            ProjectFonts.$$$reportNull$$$0(2);
        }
        FontFamily fontFamily = this.resolveFont(name);
        if (fontFamily == null) {
            ProjectFonts.$$$reportNull$$$0(3);
        }
        return fontFamily;
    }

    @Nullable
    public String getErrorMessage(@Nullable FontFamily family) {
        if (family == null || !family.getMenu().isEmpty()) {
            return null;
        }
        String name = "@font/" + family.getName();
        this.analyzeFont(name);
        if (this.hasCircularReferences(name)) {
            return "The font: \"" + family.getName() + "\" has a circular definition";
        }
        return "The font: \"" + family.getName() + "\" has an error in the definition";
    }

    @NotNull
    private FontFamily resolveFont(@NotNull String name) {
        if (name == null) {
            ProjectFonts.$$$reportNull$$$0(4);
        }
        this.analyzeFont(name);
        FontFamily resolvedFamily = this.myProjectFonts.get(name);
        if (resolvedFamily != null) {
            FontFamily fontFamily = resolvedFamily;
            if (fontFamily == null) {
                ProjectFonts.$$$reportNull$$$0(5);
            }
            return fontFamily;
        }
        if (ProjectFonts.isSystemFont(name)) {
            FontFamily family = this.myService.getSystemFont(name);
            if (family == null) {
                family = this.myService.getDefaultSystemFont();
            }
            FontFamily fontFamily = family;
            if (fontFamily == null) {
                ProjectFonts.$$$reportNull$$$0(6);
            }
            return fontFamily;
        }
        QueryParser.ParseResult result = this.myParseResults.get(name);
        if (result instanceof QueryParser.DownloadableParseResult) {
            FontFamily fontFamily = this.resolveDownloadableFont(name, (QueryParser.DownloadableParseResult)result);
            if (fontFamily == null) {
                ProjectFonts.$$$reportNull$$$0(7);
            }
            return fontFamily;
        }
        if (result instanceof FontFamilyParser.CompoundFontResult) {
            FontFamily fontFamily = this.resolveCompoundFont(name, (FontFamilyParser.CompoundFontResult)result);
            if (fontFamily == null) {
                ProjectFonts.$$$reportNull$$$0(8);
            }
            return fontFamily;
        }
        FontFamily fontFamily = this.createUnresolvedFontFamily(name);
        if (fontFamily == null) {
            ProjectFonts.$$$reportNull$$$0(9);
        }
        return fontFamily;
    }

    private FontFamily resolveDownloadableFont(@NotNull String name, @NotNull QueryParser.DownloadableParseResult result) {
        if (name == null) {
            ProjectFonts.$$$reportNull$$$0(10);
        }
        if (result == null) {
            ProjectFonts.$$$reportNull$$$0(11);
        }
        String authority = result.getAuthority();
        ArrayList<FontDetail> details = new ArrayList<FontDetail>();
        Iterator iterator = result.getFonts().asMap().entrySet().iterator();
        while (iterator.hasNext()) {
            FontProvider provider = new FontProvider("", authority, "", "", "", "");
            Map.Entry entry = iterator.next();
            String fontName = (String)entry.getKey();
            FontFamily family = this.myService.findFont(provider, fontName);
            if (family == null) {
                return this.createUnresolvedFontFamily(name);
            }
            for (MutableFontDetail wanted : (Collection)entry.getValue()) {
                FontDetail best = wanted.findBestMatch((Collection)family.getFonts());
                if (best == null) {
                    return this.createUnresolvedFontFamily(name);
                }
                if (details.indexOf(best) >= 0) continue;
                details.add(best);
            }
        }
        if (details.isEmpty()) {
            return this.createUnresolvedFontFamily(name);
        }
        return this.createSynonym(name, details);
    }

    private FontFamily resolveCompoundFont(@NotNull String name, @NotNull FontFamilyParser.CompoundFontResult result) {
        if (name == null) {
            ProjectFonts.$$$reportNull$$$0(12);
        }
        if (result == null) {
            ProjectFonts.$$$reportNull$$$0(13);
        }
        if (this.hasCircularReferences(name)) {
            return this.createUnresolvedFontFamily(name);
        }
        ArrayList<FontDetail> fonts = new ArrayList<FontDetail>();
        for (Map.Entry<String, MutableFontDetail> font2 : result.getFonts().entrySet()) {
            String dependency = font2.getKey();
            MutableFontDetail wanted = font2.getValue();
            FontFamily family = this.resolveFont(dependency);
            if (family.getMenu().isEmpty()) {
                return this.createUnresolvedFontFamily(name);
            }
            FontDetail best = wanted.findBestMatch((Collection)family.getFonts());
            assert (best != null);
            best = new FontDetail(best, wanted);
            fonts.add(best);
        }
        fonts.sort(Comparator.comparing(font -> font.getFamily().getName()));
        return this.createCompoundFamily(name, fonts);
    }

    private void analyzeFont(@NotNull String name) {
        String fontName;
        if (name == null) {
            ProjectFonts.$$$reportNull$$$0(14);
        }
        if (this.isKnownFont(name)) {
            return;
        }
        if (this.myResolver == null) {
            return;
        }
        ResourceValueMap myFonts = (ResourceValueMap)this.myResolver.getProjectResources().get(ResourceType.FONT);
        ResourceValue resourceValue = (ResourceValue)myFonts.get((Object)(fontName = StringUtil.trimStart((String)name, (String)"@font/")));
        if (resourceValue == null) {
            this.createUnresolvedFontFamily(name);
            return;
        }
        ResourceValue resolvedValue = this.myResolver.resolveResValue(resourceValue);
        String value = (resourceValue = resolvedValue != null ? resolvedValue : resourceValue).getValue();
        if (value == null) {
            this.createUnresolvedFontFamily(name);
            return;
        }
        if (value.endsWith(".xml")) {
            File fontFile = new File(value);
            if (!fontFile.exists()) {
                this.createUnresolvedFontFamily(name);
                return;
            }
            QueryParser.ParseResult result = FontFamilyParser.parseFontFamily(fontFile);
            if (result instanceof FontFamilyParser.ParseErrorResult) {
                this.createUnresolvedFontFamily(name);
                return;
            }
            this.myParseResults.put(name, result);
            if (result instanceof FontFamilyParser.CompoundFontResult) {
                FontFamilyParser.CompoundFontResult compoundResult = (FontFamilyParser.CompoundFontResult)result;
                for (String font : compoundResult.getFonts().keySet()) {
                    this.analyzeFont(font);
                }
            }
            return;
        }
        this.createEmbeddedFontFamily(name, value);
    }

    private boolean isKnownFont(@NotNull String name) {
        if (name == null) {
            ProjectFonts.$$$reportNull$$$0(15);
        }
        return ProjectFonts.isSystemFont(name) || this.myProjectFonts.containsKey(name) || this.myParseResults.containsKey(name);
    }

    private static boolean isSystemFont(@NotNull String name) {
        if (name == null) {
            ProjectFonts.$$$reportNull$$$0(16);
        }
        return !name.startsWith("@font/");
    }

    private boolean hasCircularReferences(@NotNull String name) {
        if (name == null) {
            ProjectFonts.$$$reportNull$$$0(17);
        }
        this.myDefinitions.clear();
        this.myDefinitions.add(name);
        return this.checkDependencies(name);
    }

    private boolean checkDependencies(@NotNull String name) {
        QueryParser.ParseResult result;
        if (name == null) {
            ProjectFonts.$$$reportNull$$$0(18);
        }
        if ((result = this.myParseResults.get(name)) == null) {
            return false;
        }
        int dept = this.myDefinitions.size();
        if (result instanceof FontFamilyParser.CompoundFontResult) {
            FontFamilyParser.CompoundFontResult compoundResult = (FontFamilyParser.CompoundFontResult)result;
            for (String dependency : compoundResult.getFonts().keySet()) {
                this.myDefinitions.subList(dept, this.myDefinitions.size()).clear();
                if (this.myDefinitions.contains(dependency)) {
                    return true;
                }
                this.myDefinitions.add(dependency);
                if (!this.checkDependencies(dependency)) continue;
                return true;
            }
        }
        return false;
    }

    private void createEmbeddedFontFamily(@NotNull String name, @NotNull String fileName) {
        if (name == null) {
            ProjectFonts.$$$reportNull$$$0(19);
        }
        if (fileName == null) {
            ProjectFonts.$$$reportNull$$$0(20);
        }
        String fontName = StringUtil.trimStart((String)name, (String)"@font/");
        String fileUrl = "file://" + fileName;
        MutableFontDetail detail = new MutableFontDetail(400, 100, false, fileUrl, "", false);
        FontFamily family = new FontFamily(FontProvider.EMPTY_PROVIDER, FontSource.PROJECT, fontName, fileUrl, "", Collections.singletonList(detail));
        this.myProjectFonts.put(name, family);
    }

    private FontFamily createUnresolvedFontFamily(@NotNull String name) {
        if (name == null) {
            ProjectFonts.$$$reportNull$$$0(21);
        }
        String fontName = StringUtil.trimStart((String)name, (String)"@font/");
        MutableFontDetail detail = new MutableFontDetail(400, 100, false);
        FontFamily family = new FontFamily(FontProvider.EMPTY_PROVIDER, FontSource.PROJECT, fontName, "", "", Collections.singletonList(detail));
        this.myProjectFonts.put(name, family);
        return family;
    }

    private FontFamily createSynonym(@NotNull String name, @NotNull List<FontDetail> details) {
        if (name == null) {
            ProjectFonts.$$$reportNull$$$0(22);
        }
        if (details == null) {
            ProjectFonts.$$$reportNull$$$0(23);
        }
        assert (!details.isEmpty());
        MutableFontDetail wanted = new MutableFontDetail(400, 100, false);
        FontDetail best = wanted.findBestMatch(details);
        assert (best != null);
        FontProvider provider = best.getFamily().getProvider();
        String fontName = StringUtil.trimStart((String)name, (String)"@font/");
        FontFamily family = new FontFamily(provider, FontSource.PROJECT, fontName, best.getFontUrl(), "", ImmutableList.copyOf(details));
        this.myProjectFonts.put(name, family);
        return family;
    }

    private FontFamily createCompoundFamily(@NotNull String name, @NotNull List<FontDetail> fonts) {
        if (name == null) {
            ProjectFonts.$$$reportNull$$$0(24);
        }
        if (fonts == null) {
            ProjectFonts.$$$reportNull$$$0(25);
        }
        assert (!fonts.isEmpty());
        String fontName = StringUtil.trimStart((String)name, (String)"@font/");
        MutableFontDetail wanted = new MutableFontDetail(400, 100, false);
        FontDetail best = wanted.findBestMatch(fonts);
        assert (best != null);
        FontFamily original = best.getFamily();
        FontFamily family = new FontFamily(original.getProvider(), FontSource.PROJECT, fontName, original.getMenu(), "", ImmutableList.copyOf(fonts));
        this.myProjectFonts.put(name, family);
        return family;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/fonts/ProjectFonts";
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fonts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFonts";
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/fonts/ProjectFonts";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFont";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveFont";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFont";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveFont";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolveDownloadableFont";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveCompoundFont";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "analyzeFont";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isKnownFont";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isSystemFont";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "hasCircularReferences";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "checkDependencies";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createEmbeddedFontFamily";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createUnresolvedFontFamily";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createSynonym";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createCompoundFamily";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

