/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd.gradle;

import com.android.builder.model.BuildType;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.InstantRun;
import com.android.builder.model.ProductFlavor;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.ide.common.repository.GradleVersion;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.fd.gradle.InstantRunGradleSupport;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.run.GradleInstantRunContext;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.run.ApkProviderUtil;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.ir.client.InstantRunBuildInfo;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstantRunGradleUtils {
    private static final String MINIMUM_GRADLE_PLUGIN_VERSION_STRING = "2.3.0-beta1";
    public static final GradleVersion MINIMUM_GRADLE_PLUGIN_VERSION = GradleVersion.parse((String)"2.3.0-beta1");
    @Nullable
    private static InstantRunGradleSupport ourInstantRunGradleSupportOverride = null;

    public static void setInstantRunGradleSupportOverride(@Nullable InstantRunGradleSupport supportOverride) {
        ourInstantRunGradleSupportOverride = supportOverride;
    }

    @NotNull
    public static InstantRunGradleSupport getIrSupportStatus(@Nullable AndroidModuleModel model, @Nullable AndroidVersion deviceVersion) {
        ProductFlavor mergedFlavor;
        block16: {
            InstantRunGradleSupport instantRunGradleSupport;
            if (ourInstantRunGradleSupportOverride != null) {
                InstantRunGradleSupport instantRunGradleSupport2 = ourInstantRunGradleSupportOverride;
                if (instantRunGradleSupport2 == null) {
                    InstantRunGradleUtils.$$$reportNull$$$0(0);
                }
                return instantRunGradleSupport2;
            }
            if (model == null) {
                InstantRunGradleSupport instantRunGradleSupport3 = InstantRunGradleSupport.NO_GRADLE_MODEL;
                if (instantRunGradleSupport3 == null) {
                    InstantRunGradleUtils.$$$reportNull$$$0(1);
                }
                return instantRunGradleSupport3;
            }
            try {
                InstantRunGradleSupport modelStatus = InstantRunGradleSupport.fromModel(model);
                if (modelStatus == InstantRunGradleSupport.SUPPORTED) break block16;
                instantRunGradleSupport = modelStatus;
            }
            catch (UnsupportedOperationException e) {
                if (!InstantRunGradleUtils.modelSupportsInstantRun(model)) {
                    InstantRunGradleSupport instantRunGradleSupport4 = InstantRunGradleSupport.GRADLE_PLUGIN_TOO_OLD;
                    if (instantRunGradleSupport4 == null) {
                        InstantRunGradleUtils.$$$reportNull$$$0(3);
                    }
                    return instantRunGradleSupport4;
                }
                if (InstantRunGradleUtils.variantSupportsInstantRun(model)) break block16;
                InstantRunGradleSupport instantRunGradleSupport5 = InstantRunGradleSupport.VARIANT_DOES_NOT_SUPPORT_INSTANT_RUN;
                if (instantRunGradleSupport5 == null) {
                    InstantRunGradleUtils.$$$reportNull$$$0(4);
                }
                return instantRunGradleSupport5;
            }
            if (instantRunGradleSupport == null) {
                InstantRunGradleUtils.$$$reportNull$$$0(2);
            }
            return instantRunGradleSupport;
        }
        if (deviceVersion == null) {
            InstantRunGradleSupport instantRunGradleSupport = InstantRunGradleSupport.SUPPORTED;
            if (instantRunGradleSupport == null) {
                InstantRunGradleUtils.$$$reportNull$$$0(5);
            }
            return instantRunGradleSupport;
        }
        IdeVariant variant = model.getSelectedVariant();
        BuildTypeContainer buildTypeContainer = model.findBuildType(model.getSelectedVariant().getBuildType());
        assert (buildTypeContainer != null);
        BuildType buildType = buildTypeContainer.getBuildType();
        if (InstantRunGradleUtils.isLegacyMultiDex(buildType, mergedFlavor = variant.getMergedFlavor()) && !deviceVersion.isGreaterOrEqualThan(AndroidVersion.ART_RUNTIME.getApiLevel())) {
            InstantRunGradleSupport instantRunGradleSupport = InstantRunGradleSupport.LEGACY_MULTIDEX_REQUIRES_ART;
            if (instantRunGradleSupport == null) {
                InstantRunGradleUtils.$$$reportNull$$$0(6);
            }
            return instantRunGradleSupport;
        }
        InstantRunGradleSupport instantRunGradleSupport = InstantRunGradleSupport.SUPPORTED;
        if (instantRunGradleSupport == null) {
            InstantRunGradleUtils.$$$reportNull$$$0(7);
        }
        return instantRunGradleSupport;
    }

    private static boolean isLegacyMultiDex(@NotNull BuildType buildType, @NotNull ProductFlavor mergedFlavor) {
        if (buildType == null) {
            InstantRunGradleUtils.$$$reportNull$$$0(8);
        }
        if (mergedFlavor == null) {
            InstantRunGradleUtils.$$$reportNull$$$0(9);
        }
        if (buildType.getMultiDexEnabled() != null) {
            return buildType.getMultiDexEnabled();
        }
        if (mergedFlavor.getMultiDexEnabled() != null) {
            return mergedFlavor.getMultiDexEnabled();
        }
        return false;
    }

    public static boolean variantSupportsInstantRun(@NotNull AndroidModuleModel model) {
        if (model == null) {
            InstantRunGradleUtils.$$$reportNull$$$0(10);
        }
        try {
            return model.getSelectedVariant().getMainArtifact().getInstantRun().isSupportedByArtifact();
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean modelSupportsInstantRun(@NotNull AndroidModuleModel model) {
        GradleVersion modelVersion;
        if (model == null) {
            InstantRunGradleUtils.$$$reportNull$$$0(11);
        }
        return (modelVersion = model.getModelVersion()) == null || modelVersion.compareTo(MINIMUM_GRADLE_PLUGIN_VERSION) >= 0;
    }

    @Nullable
    public static AndroidModuleModel getAppModel(@NotNull Module module) {
        AndroidFacet facet;
        if (module == null) {
            InstantRunGradleUtils.$$$reportNull$$$0(12);
        }
        if ((facet = InstantRunGradleUtils.findAppModule(module, module.getProject())) == null) {
            return null;
        }
        return AndroidModuleModel.get(facet);
    }

    @Nullable
    public static AndroidFacet findAppModule(@Nullable Module module, @NotNull Project project) {
        if (project == null) {
            InstantRunGradleUtils.$$$reportNull$$$0(13);
        }
        if (module != null) {
            assert (module.getProject() == project);
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet != null && facet.isAppProject()) {
                return facet;
            }
        }
        for (Module m : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidFacet facet = AndroidFacet.getInstance(m);
            if (facet == null || !facet.isAppProject()) continue;
            return facet;
        }
        return null;
    }

    @Nullable
    public static InstantRunBuildInfo getBuildInfo(AndroidModuleModel model) {
        String xml;
        File buildInfo = InstantRunGradleUtils.getLocalBuildInfoFile(model);
        if (!buildInfo.exists()) {
            return null;
        }
        try {
            xml = Files.toString((File)buildInfo, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            return null;
        }
        return InstantRunBuildInfo.get((String)xml);
    }

    @NotNull
    private static File getLocalBuildInfoFile(@NotNull AndroidModuleModel model) {
        if (model == null) {
            InstantRunGradleUtils.$$$reportNull$$$0(14);
        }
        InstantRun instantRun = model.getSelectedVariant().getMainArtifact().getInstantRun();
        File file = instantRun.getInfoFile();
        if (file == null) {
            InstantRunGradleUtils.$$$reportNull$$$0(15);
        }
        return file;
    }

    @Nullable
    public static InstantRunContext createGradleProjectContext(@NotNull Module module) {
        AndroidFacet appFacet;
        if (module == null) {
            InstantRunGradleUtils.$$$reportNull$$$0(16);
        }
        if ((appFacet = InstantRunGradleUtils.findAppModule(module, module.getProject())) == null) {
            return null;
        }
        return InstantRunGradleUtils.createGradleProjectContext(appFacet);
    }

    @Nullable
    public static InstantRunContext createGradleProjectContext(@NotNull AndroidFacet facet) {
        if (facet == null) {
            InstantRunGradleUtils.$$$reportNull$$$0(17);
        }
        try {
            String pkgName = ApkProviderUtil.computePackageName(facet);
            return new GradleInstantRunContext(pkgName, facet);
        }
        catch (ApkProvisionException e) {
            return null;
        }
    }

    public static boolean appHasCode(@Nullable AndroidFacet facet) {
        if (facet == null) {
            return true;
        }
        MergedManifest mergedManifest = MergedManifest.get(facet);
        return mergedManifest.getApplicationHasCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/fd/gradle/InstantRunGradleUtils";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergedFlavor";
                break;
            }
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIrSupportStatus";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/fd/gradle/InstantRunGradleUtils";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalBuildInfoFile";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isLegacyMultiDex";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "variantSupportsInstantRun";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "modelSupportsInstantRun";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAppModel";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findAppModule";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getLocalBuildInfoFile";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createGradleProjectContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

