/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd.actions;

import com.android.tools.idea.fd.FlightRecorder;
import com.android.tools.idea.fd.InstantRunSettings;
import com.android.tools.idea.fd.actions.InstantRunFeedbackDialog;
import com.android.tools.idea.fd.crash.GoogleCrash;
import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import com.intellij.ide.BrowserUtil;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class SubmitFeedback
extends DumbAwareAction {
    private static final NotificationGroup FLR_NOTIFICATION_GROUP = NotificationGroup.balloonGroup((String)"Instant Run Issue Submission");

    public SubmitFeedback() {
        super("Report Instant Run Issue...");
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SubmitFeedback.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        this.getTemplatePresentation().setVisible(project != null && !project.isDefault());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            SubmitFeedback.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            Logger.getInstance(SubmitFeedback.class).info("Unable to identify current project");
            return;
        }
        if (!InstantRunSettings.isInstantRunEnabled() || !InstantRunSettings.isRecorderEnabled()) {
            int result = Messages.showYesNoDialog((Project)project, (String)AndroidBundle.message("instant.run.flr.would.you.like.to.enable", new Object[0]), (String)AndroidBundle.message("instant.run.flr.dialog.title", new Object[0]), (String)"Yes, I'd like to help", (String)"Cancel", (Icon)Messages.getQuestionIcon());
            if (result == 1) {
                return;
            }
            InstantRunSettings.setInstantRunEnabled(true);
            InstantRunSettings.setRecorderEnabled(true);
            Messages.showInfoMessage((Project)project, (String)AndroidBundle.message("instant.run.flr.howto", new Object[0]), (String)AndroidBundle.message("instant.run.flr.dialog.title", new Object[0]));
            return;
        }
        final InstantRunFeedbackDialog dialog = new InstantRunFeedbackDialog(project);
        boolean ok = dialog.showAndGet();
        if (ok) {
            new Task.Backgroundable(project, "Submitting Instant Run Issue"){
                public CompletableFuture<String> myReport;

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.myReport = GoogleCrash.getInstance().submit(FlightRecorder.get(project), dialog.getIssueText(), dialog.getLogs());
                    while (!this.myReport.isDone()) {
                        try {
                            this.myReport.get(200L, TimeUnit.MILLISECONDS);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (!indicator.isCanceled()) continue;
                        return;
                    }
                }

                public void onSuccess() {
                    if (this.myReport.isDone()) {
                        String reportId;
                        try {
                            reportId = this.myReport.getNow("00");
                        }
                        catch (CancellationException e) {
                            Logger.getInstance(SubmitFeedback.class).info("Submission of flight recorder logs cancelled");
                            return;
                        }
                        catch (CompletionException e) {
                            String msg = "<html>Unexpected error while submitting instant run logs<br>Please file a bug at <a href=\"bug\">b.android.com</a> and include your idea.log file</html>";
                            FLR_NOTIFICATION_GROUP.createNotification("", msg, NotificationType.ERROR, (notification, event) -> SubmitFeedback.openBrowserToInstantRunBug("Error uploading Instant Run Logs: " + e.toString())).notify(project);
                            Logger.getInstance(SubmitFeedback.class).info((Throwable)e);
                            return;
                        }
                        String message = String.format("<html>Thank you for submitting the bug report.<br>If you would like to follow up on this report, please file a bug at <a href=\"bug\">b.android.com</a> and specify the report id '%1$s'<html>", reportId);
                        FLR_NOTIFICATION_GROUP.createNotification("", message, NotificationType.INFORMATION, (notification, event) -> {
                            String comment = String.format("Build: %1$s\nInstant Run Report: %2$s", ApplicationInfo.getInstance().getFullVersion(), reportId);
                            SubmitFeedback.openBrowserToInstantRunBug(comment);
                        }).notify(project);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/fd/actions/SubmitFeedback$1", "run"));
                }
            }.queue();
        }
    }

    private static void openBrowserToInstantRunBug(@NotNull String comment) {
        if (comment == null) {
            SubmitFeedback.$$$reportNull$$$0(2);
        }
        Escaper escaper = UrlEscapers.urlFormParameterEscaper();
        String url = String.format("https://code.google.com/p/android/issues/entry?template=%1$s&comment=%2$s&status=New", escaper.escape("Android Studio Instant Run Bug"), escaper.escape(comment));
        BrowserUtil.browse((String)url);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/fd/actions/SubmitFeedback";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "openBrowserToInstantRunBug";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

