/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd;

import com.android.ddmlib.IDevice;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.fd.BuildCause;
import com.android.tools.idea.fd.BuildSelection;
import com.android.tools.idea.fd.DeployType;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.gradle.util.GradleVersions;
import com.android.tools.idea.stats.AndroidStudioUsageTracker;
import com.android.tools.ir.client.InstantRunBuildInfo;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleBuildDetails;
import com.google.wireless.android.sdk.stats.InstantRun;
import com.google.wireless.android.sdk.stats.InstantRunStatus;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstantRunStatsService {
    private static final String UNKOWN_VERSION = "0.0.0";
    private final Object LOCK;
    private final Project myProject;
    @NotNull
    private UUID mySessionId;
    private long myBuildStartTime;

    public static InstantRunStatsService get(@NotNull Project project) {
        if (project == null) {
            InstantRunStatsService.$$$reportNull$$$0(0);
        }
        return (InstantRunStatsService)ServiceManager.getService((Project)project, InstantRunStatsService.class);
    }

    private InstantRunStatsService(@NotNull Project project) {
        if (project == null) {
            InstantRunStatsService.$$$reportNull$$$0(1);
        }
        this.LOCK = new Object();
        this.mySessionId = UUID.randomUUID();
        this.myProject = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyBuildStarted() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myBuildStartTime = System.currentTimeMillis();
        }
    }

    public void notifyDeployStarted() {
    }

    public void notifyDeployType(@NotNull DeployType type, @NotNull InstantRunContext context, @NotNull IDevice device) {
        BuildSelection selection;
        if (type == null) {
            InstantRunStatsService.$$$reportNull$$$0(2);
        }
        if (context == null) {
            InstantRunStatsService.$$$reportNull$$$0(3);
        }
        if (device == null) {
            InstantRunStatsService.$$$reportNull$$$0(4);
        }
        BuildCause buildCause = (selection = context.getBuildSelection()) == null ? null : selection.why;
        InstantRunBuildInfo buildInfo = context.getInstantRunBuildInfo();
        String verifierStatus = buildInfo == null ? "unknown" : buildInfo.getVerifierStatus();
        this.notifyDeployType(type, InstantRunStatsService.buildCauseToProto(buildCause), InstantRunStatsService.verifierStatusToProto(verifierStatus), context.getGradlePluginVersion().toString(), device);
    }

    public void notifyNonInstantRunDeployType(@NotNull IDevice device) {
        if (device == null) {
            InstantRunStatsService.$$$reportNull$$$0(5);
        }
        this.notifyDeployType(DeployType.LEGACY, InstantRun.InstantRunIdeBuildCause.NO_INSTANT_RUN, InstantRunStatus.VerifierStatus.UNKNOWN_VERIFIER_STATUS, UNKOWN_VERSION, device);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDeployType(@NotNull DeployType type, @NotNull InstantRun.InstantRunIdeBuildCause buildCause, @NotNull InstantRunStatus.VerifierStatus verifierStatus, @NotNull String androidPluginVersion, @NotNull IDevice device) {
        String sessionId;
        long buildAndDeployTime;
        if (type == null) {
            InstantRunStatsService.$$$reportNull$$$0(6);
        }
        if (buildCause == null) {
            InstantRunStatsService.$$$reportNull$$$0(7);
        }
        if (verifierStatus == null) {
            InstantRunStatsService.$$$reportNull$$$0(8);
        }
        if (androidPluginVersion == null) {
            InstantRunStatsService.$$$reportNull$$$0(9);
        }
        if (device == null) {
            InstantRunStatsService.$$$reportNull$$$0(10);
        }
        Object object = this.LOCK;
        synchronized (object) {
            buildAndDeployTime = System.currentTimeMillis() - this.myBuildStartTime;
            if (type == DeployType.FULLAPK || type == DeployType.LEGACY || type == DeployType.SPLITAPK) {
                this.resetSession();
            }
            sessionId = this.mySessionId.toString();
        }
        AndroidStudioEvent.Builder studioEvent = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.STUDIO_BUILD).setKind(AndroidStudioEvent.EventKind.INSTANT_RUN).setInstantRun(InstantRun.newBuilder().setSessionId(sessionId).setBuildTime(buildAndDeployTime).setDeploymentKind(InstantRunStatsService.deployTypeToDeploymentKind(type)).setIdeBuildCause(buildCause).setGradleBuildCause(verifierStatus)).setGradleBuildDetails(GradleBuildDetails.newBuilder().setGradleVersion(InstantRunStatsService.getGradleVersion(this.myProject)).setAndroidPluginVersion(androidPluginVersion));
        if (buildCause == InstantRun.InstantRunIdeBuildCause.API_TOO_LOW_FOR_INSTANT_RUN || buildCause == InstantRun.InstantRunIdeBuildCause.FREEZE_SWAP_REQUIRES_API21 || buildCause == InstantRun.InstantRunIdeBuildCause.FREEZE_SWAP_REQUIRES_WORKING_RUN_AS) {
            studioEvent.setDeviceInfo(AndroidStudioUsageTracker.deviceToDeviceInfo(device));
        } else {
            studioEvent.setDeviceInfo(AndroidStudioUsageTracker.deviceToDeviceInfoApilLevelOnly(device));
        }
        UsageTracker.getInstance().log(studioEvent);
    }

    @NotNull
    private static String getGradleVersion(@NotNull Project project) {
        GradleVersion gradleVersion;
        if (project == null) {
            InstantRunStatsService.$$$reportNull$$$0(11);
        }
        String string = (gradleVersion = GradleVersions.getInstance().getGradleVersion(project)) == null ? UNKOWN_VERSION : gradleVersion.toString();
        if (string == null) {
            InstantRunStatsService.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static InstantRun.InstantRunIdeBuildCause buildCauseToProto(@Nullable BuildCause buildCause) {
        if (buildCause == null) {
            return InstantRun.InstantRunIdeBuildCause.UNKNOWN_INSTANT_RUN_IDE_BUILD_CAUSE;
        }
        try {
            return InstantRun.InstantRunIdeBuildCause.valueOf((String)buildCause.name());
        }
        catch (IllegalArgumentException e) {
            return InstantRun.InstantRunIdeBuildCause.UNKNOWN_INSTANT_RUN_IDE_BUILD_CAUSE;
        }
    }

    private static InstantRun.InstantRunDeploymentKind deployTypeToDeploymentKind(@NotNull DeployType type) {
        if (type == null) {
            InstantRunStatsService.$$$reportNull$$$0(13);
        }
        switch (type) {
            case LEGACY: {
                return InstantRun.InstantRunDeploymentKind.LEGACY;
            }
            case FULLAPK: {
                return InstantRun.InstantRunDeploymentKind.FULL_APK;
            }
            case HOTSWAP: {
                return InstantRun.InstantRunDeploymentKind.HOT_SWAP;
            }
            case SPLITAPK: {
                return InstantRun.InstantRunDeploymentKind.SPLIT_APK;
            }
            case WARMSWAP: {
                return InstantRun.InstantRunDeploymentKind.WARM_SWAP;
            }
            case NO_CHANGES: {
                return InstantRun.InstantRunDeploymentKind.NO_CHANGES;
            }
        }
        return InstantRun.InstantRunDeploymentKind.UNKNOWN_INSTANT_RUN_DEPLOYMENT_KIND;
    }

    private static InstantRunStatus.VerifierStatus verifierStatusToProto(@NotNull String verifierStatus) {
        if (verifierStatus == null) {
            InstantRunStatsService.$$$reportNull$$$0(14);
        }
        try {
            return InstantRunStatus.VerifierStatus.valueOf((String)verifierStatus);
        }
        catch (IllegalArgumentException e) {
            return InstantRunStatus.VerifierStatus.UNKNOWN_VERIFIER_STATUS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetSession() {
        Object object = this.LOCK;
        synchronized (object) {
            this.mySessionId = UUID.randomUUID();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildCause";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "verifierStatus";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidPluginVersion";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/fd/InstantRunStatsService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/fd/InstantRunStatsService";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradleVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "notifyDeployType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "notifyNonInstantRunDeployType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getGradleVersion";
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "deployTypeToDeploymentKind";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "verifierStatusToProto";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

