/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.fd.InstantRunSettings;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.run.AndroidSessionInfo;
import com.android.tools.idea.run.InstalledPatchCache;
import com.android.tools.ir.client.InstantRunBuildInfo;
import com.android.tools.ir.client.InstantRunClient;
import com.android.tools.ir.client.InstantRunPushFailedException;
import com.android.tools.ir.client.UpdateMode;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableSet;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.JavaExecutionStack;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.xdebugger.XDebugSession;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InstantRunManager {
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"InstantRun", (String)ToolWindowId.RUN);
    public static final Logger LOG = Logger.getInstance((String)"#InstantRun");
    public static final ILogger ILOGGER = new LogWrapper(LOG);
    public static final ImmutableSet<String> ALLOWED_MULTI_PROCESSES = ImmutableSet.of((Object)":leakcanary", (Object)":background_crash");
    public static final int MIN_IR_API_VERSION = 21;
    @NotNull
    private final Project myProject;

    @NotNull
    public static InstantRunManager get(@NotNull Project project) {
        if (project == null) {
            InstantRunManager.$$$reportNull$$$0(0);
        }
        InstantRunManager instantRunManager = (InstantRunManager)ServiceManager.getService((Project)project, InstantRunManager.class);
        if (instantRunManager == null) {
            InstantRunManager.$$$reportNull$$$0(1);
        }
        return instantRunManager;
    }

    private InstantRunManager(@NotNull Project project) {
        if (project == null) {
            InstantRunManager.$$$reportNull$$$0(2);
        }
        this.myProject = project;
    }

    @Nullable
    public static AndroidVersion getMinDeviceApiLevel(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            InstantRunManager.$$$reportNull$$$0(3);
        }
        return (AndroidVersion)processHandler.getUserData(AndroidSessionInfo.ANDROID_DEVICE_API_LEVEL);
    }

    public static void transferLocalIdToDeviceId(@NotNull IDevice device, @NotNull InstantRunContext context) {
        if (device == null) {
            InstantRunManager.$$$reportNull$$$0(4);
        }
        if (context == null) {
            InstantRunManager.$$$reportNull$$$0(5);
        }
        InstantRunBuildInfo buildInfo = context.getInstantRunBuildInfo();
        assert (buildInfo != null);
        String localTimestamp = buildInfo.getTimeStamp();
        assert (!StringUtil.isEmpty((String)localTimestamp)) : "Unable to detect build timestamp";
        InstantRunClient.transferBuildIdToDevice((IDevice)device, (String)localTimestamp, (String)context.getApplicationId(), (ILogger)ILOGGER);
    }

    public static boolean isInstantRunCapableDeviceVersion(@NotNull AndroidVersion version) {
        if (version == null) {
            InstantRunManager.$$$reportNull$$$0(6);
        }
        return version.getApiLevel() >= 21;
    }

    public static boolean hasLocalCacheOfDeviceData(@NotNull IDevice device, @NotNull InstantRunContext context) {
        InstalledPatchCache cache;
        if (device == null) {
            InstantRunManager.$$$reportNull$$$0(7);
        }
        if (context == null) {
            InstantRunManager.$$$reportNull$$$0(8);
        }
        return (cache = context.getInstalledPatchCache()).getInstalledManifestResourcesHash(device, context.getApplicationId()) != null;
    }

    @Nullable
    public static InstantRunClient getInstantRunClient(@NotNull InstantRunContext context) {
        InstantRunBuildInfo buildInfo;
        if (context == null) {
            InstantRunManager.$$$reportNull$$$0(9);
        }
        if ((buildInfo = context.getInstantRunBuildInfo()) == null) {
            return null;
        }
        return new InstantRunClient(context.getApplicationId(), ILOGGER, buildInfo.getSecretToken());
    }

    public UpdateMode pushArtifacts(@NotNull IDevice device, @NotNull InstantRunContext context, @NotNull UpdateMode updateMode) throws InstantRunPushFailedException, IOException {
        if (device == null) {
            InstantRunManager.$$$reportNull$$$0(10);
        }
        if (context == null) {
            InstantRunManager.$$$reportNull$$$0(11);
        }
        if (updateMode == null) {
            InstantRunManager.$$$reportNull$$$0(12);
        }
        InstantRunClient client = InstantRunManager.getInstantRunClient(context);
        assert (client != null);
        InstantRunBuildInfo instantRunBuildInfo = context.getInstantRunBuildInfo();
        assert (instantRunBuildInfo != null);
        if ((updateMode = client.pushPatches(device, instantRunBuildInfo, updateMode, InstantRunSettings.isRestartActivity(), InstantRunSettings.isShowToastEnabled())) == UpdateMode.HOT_SWAP || updateMode == UpdateMode.WARM_SWAP) {
            this.refreshDebugger(context.getApplicationId());
        }
        return updateMode;
    }

    private void refreshDebugger(@NotNull String packageName) {
        if (packageName == null) {
            InstantRunManager.$$$reportNull$$$0(13);
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                DebuggerManagerEx debugger = DebuggerManagerEx.getInstanceEx((Project)InstantRunManager.this.myProject);
                if (!debugger.getSessions().isEmpty()) {
                    List breakpoints = debugger.getBreakpointManager().getBreakpoints();
                    for (Breakpoint breakpoint : breakpoints) {
                        if (!breakpoint.isEnabled()) continue;
                        breakpoint.setEnabled(false);
                        breakpoint.setEnabled(true);
                    }
                }
            }
        });
        DebuggerManagerEx debugger = DebuggerManagerEx.getInstanceEx((Project)this.myProject);
        for (final DebuggerSession session : debugger.getSessions()) {
            Client client = (Client)session.getProcess().getProcessHandler().getUserData(AndroidSessionInfo.ANDROID_DEBUG_CLIENT);
            if (client == null || !client.isValid() || !StringUtil.equals((CharSequence)packageName, (CharSequence)client.getClientData().getClientDescription())) continue;
            session.getProcess().getManagerThread().invoke(new DebuggerCommandImpl(){

                protected void action() throws Exception {
                    JavaExecutionStack stack;
                    DebuggerContextImpl context = session.getContextManager().getContext();
                    SuspendContextImpl suspendContext = context.getSuspendContext();
                    if (suspendContext != null && (stack = suspendContext.getActiveExecutionStack()) != null) {
                        stack.initTopFrame();
                    }
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            session.refresh(false);
                            XDebugSession xSession = session.getXDebugSession();
                            if (xSession != null) {
                                xSession.resume();
                            }
                        }
                    });
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/fd/InstantRunManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateMode";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/fd/InstantRunManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMinDeviceApiLevel";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "transferLocalIdToDeviceId";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isInstantRunCapableDeviceVersion";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasLocalCacheOfDeviceData";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getInstantRunClient";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "pushArtifacts";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "refreshDebugger";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

