/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.experimental.codeanalysis.datastructs;

import com.android.tools.idea.experimental.codeanalysis.datastructs.PsiCFGPartialMethodSignature;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;

public class PsiCFGPartialMethodSignatureBuilder {
    public static PsiCFGPartialMethodSignature buildFromPsiMethod(PsiMethod psiMethod) {
        PsiParameter[] paramList;
        PsiCFGPartialMethodSignature retSignature = new PsiCFGPartialMethodSignature();
        retSignature.methodName = psiMethod.getName().trim();
        if (psiMethod.isVarArgs()) {
            retSignature.isVarArgs = true;
        }
        if ((paramList = psiMethod.getParameterList().getParameters()) == null || paramList.length == 0) {
            retSignature.parameterTypes = PsiType.EMPTY_ARRAY;
        } else {
            retSignature.parameterTypes = new PsiType[paramList.length];
            for (int i = 0; i < paramList.length; ++i) {
                PsiType curParamType;
                retSignature.parameterTypes[i] = curParamType = paramList[i].getType();
            }
        }
        return retSignature;
    }

    public static PsiCFGPartialMethodSignature buildFromScratch(String name, PsiType[] paramTypes, boolean isVarArgs) {
        PsiCFGPartialMethodSignature retSignature = new PsiCFGPartialMethodSignature();
        retSignature.methodName = name.trim();
        retSignature.isVarArgs = isVarArgs;
        retSignature.parameterTypes = paramTypes == null || paramTypes.length == 0 ? PsiType.EMPTY_ARRAY : (PsiType[])paramTypes.clone();
        return retSignature;
    }
}

