/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.experimental;

import com.android.tools.idea.experimental.codeanalysis.PsiCFGScene;
import com.android.tools.idea.experimental.codeanalysis.datastructs.PsiCFGClass;
import com.android.tools.idea.experimental.codeanalysis.utils.PsiCFGAnalysisUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.analysis.AnalysisScope;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CodeAnalysisMain {
    private static Map<Project, CodeAnalysisMain> instanceMap = Maps.newHashMap();
    private Project mProject;
    private PsiCFGScene mScene;

    private CodeAnalysisMain(Project project) {
        this.mProject = project;
    }

    @NotNull
    public static CodeAnalysisMain getInstance(@NotNull Project project) {
        if (project == null) {
            CodeAnalysisMain.$$$reportNull$$$0(0);
        }
        if (instanceMap.containsKey(project)) {
            CodeAnalysisMain codeAnalysisMain = instanceMap.get(project);
            if (codeAnalysisMain == null) {
                CodeAnalysisMain.$$$reportNull$$$0(1);
            }
            return codeAnalysisMain;
        }
        CodeAnalysisMain instance = new CodeAnalysisMain(project);
        instanceMap.put(project, instance);
        CodeAnalysisMain codeAnalysisMain = instance;
        if (codeAnalysisMain == null) {
            CodeAnalysisMain.$$$reportNull$$$0(2);
        }
        return codeAnalysisMain;
    }

    public void analyze(@NotNull AnalysisScope scope) {
        if (scope == null) {
            CodeAnalysisMain.$$$reportNull$$$0(3);
        }
        this.mScene = PsiCFGScene.createFreshInstance(this.mProject);
        PsiCFGAnalysisUtil AnalysisUtil = this.mScene.analysisUtil;
        int fileCount = scope.getFileCount();
        PsiFile[] allFilesInScope = this.findAllJavaFiles(this.mProject, scope);
        this.initiateProjectClassesFromPsiFile(allFilesInScope);
        PsiCFGClass[] allClasses = this.mScene.getAllApplicationClasses();
        AnalysisUtil.performStage0();
        AnalysisUtil.performStage1();
        AnalysisUtil.performStage2();
        AnalysisUtil.performStage3();
        AnalysisUtil.performStage4();
        AnalysisUtil.performStage5();
        AnalysisUtil.performStage6();
    }

    private void outputFileNames(PsiFile[] filesArray) {
        for (PsiFile f : filesArray) {
            System.out.println(f.getName());
        }
    }

    protected PsiFile[] findAllJavaFiles(@NotNull Project project, @NotNull AnalysisScope scope) {
        if (project == null) {
            CodeAnalysisMain.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            CodeAnalysisMain.$$$reportNull$$$0(5);
        }
        final ArrayList retList = Lists.newArrayList();
        scope.accept(new PsiElementVisitor(){

            public void visitFile(PsiFile file) {
                if (file instanceof PsiJavaFile) {
                    retList.add(file);
                }
            }
        });
        return retList.toArray(PsiFile.EMPTY_ARRAY);
    }

    private void initiateProjectClassesFromPsiFile(@NotNull PsiFile[] files) {
        if (files == null) {
            CodeAnalysisMain.$$$reportNull$$$0(6);
        }
        for (PsiFile pFile : files) {
            PsiClass[] curClassesInFile;
            if (!(pFile instanceof PsiJavaFile)) continue;
            for (PsiClass curClass : curClassesInFile = this.extractProjectClasses(pFile)) {
                this.mScene.createPsiCFGClass(curClass, pFile, true);
            }
        }
    }

    private PsiClass[] extractProjectClasses(PsiFile pFile) {
        ArrayList retList = Lists.newArrayList();
        if (!(pFile instanceof PsiJavaFile)) {
            return retList.toArray(PsiClass.EMPTY_ARRAY);
        }
        PsiJavaFile curJavaFile = (PsiJavaFile)pFile;
        PsiClass[] firstLevelClasses = curJavaFile.getClasses();
        if (firstLevelClasses.length == 0) {
            return retList.toArray(PsiClass.EMPTY_ARRAY);
        }
        for (PsiClass clazz : firstLevelClasses) {
            this.retrieveClassAndInnerClass(retList, clazz);
        }
        return retList.toArray(PsiClass.EMPTY_ARRAY);
    }

    private void retrieveClassAndInnerClass(@NotNull ArrayList<PsiClass> retList, @NotNull PsiClass psiClass) {
        if (retList == null) {
            CodeAnalysisMain.$$$reportNull$$$0(7);
        }
        if (psiClass == null) {
            CodeAnalysisMain.$$$reportNull$$$0(8);
        }
        retList.add(psiClass);
        PsiClass[] innerClasses = psiClass.getInnerClasses();
        if (innerClasses == null || innerClasses.length == 0) {
            return;
        }
        for (PsiClass innerClazz : innerClasses) {
            this.retrieveClassAndInnerClass(retList, innerClazz);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/experimental/CodeAnalysisMain";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "retList";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/experimental/CodeAnalysisMain";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "analyze";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findAllJavaFiles";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "initiateProjectClassesFromPsiFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "retrieveClassAndInnerClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

