/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes.editors;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.ThemeEditorConstants;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.attributes.editors.GraphicalResourceRendererEditor;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.editors.theme.preview.AndroidThemePreviewPanel;
import com.android.tools.idea.editors.theme.ui.ResourceComponent;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.ui.resourcechooser.ResourceSwatchComponent;
import com.google.common.collect.Iterables;
import com.intellij.openapi.module.Module;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrawableRendererEditor
extends GraphicalResourceRendererEditor {
    private static final int MIN_DRAWABLE_PREVIEW_SIZE = JBUI.scale((int)25);
    @Nullable
    private RenderTask myRenderTask;

    public DrawableRendererEditor(@NotNull ThemeEditorContext context, @NotNull AndroidThemePreviewPanel previewPanel, boolean isEditor) {
        if (context == null) {
            DrawableRendererEditor.$$$reportNull$$$0(0);
        }
        if (previewPanel == null) {
            DrawableRendererEditor.$$$reportNull$$$0(1);
        }
        super(context, previewPanel, isEditor);
    }

    @NotNull
    public static RenderTask configureRenderTask(@NotNull Module module, @NotNull Configuration configuration) {
        if (module == null) {
            DrawableRendererEditor.$$$reportNull$$$0(2);
        }
        if (configuration == null) {
            DrawableRendererEditor.$$$reportNull$$$0(3);
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        assert (facet != null);
        RenderService service = RenderService.getInstance(facet);
        RenderLogger logger = new RenderLogger("ThemeEditorLogger", null);
        RenderTask task = service.createTask(null, configuration, logger, null);
        assert (task != null);
        task.getLayoutlibCallback().setLogger(logger);
        RenderTask renderTask = task;
        if (renderTask == null) {
            DrawableRendererEditor.$$$reportNull$$$0(4);
        }
        return renderTask;
    }

    @Override
    protected void updateComponent(@NotNull ThemeEditorContext context, @NotNull ResourceComponent component2, @NotNull EditedStyleItem item) {
        ResourceSwatchComponent.SwatchIcon icon;
        if (context == null) {
            DrawableRendererEditor.$$$reportNull$$$0(5);
        }
        if (component2 == null) {
            DrawableRendererEditor.$$$reportNull$$$0(6);
        }
        if (item == null) {
            DrawableRendererEditor.$$$reportNull$$$0(7);
        }
        assert (context.getResourceResolver() != null);
        Dimension iconSize = component2.getSwatchIconSize();
        int iconWidth = Math.max(iconSize.width, MIN_DRAWABLE_PREVIEW_SIZE);
        int iconHeight = Math.max(iconSize.height, MIN_DRAWABLE_PREVIEW_SIZE);
        if (this.myRenderTask == null || this.myRenderTask.getModule() != context.getCurrentContextModule()) {
            this.myRenderTask = DrawableRendererEditor.configureRenderTask(context.getCurrentContextModule(), context.getConfiguration());
        }
        this.myRenderTask.setMaxRenderSize(iconWidth, iconHeight);
        List<BufferedImage> images = this.myRenderTask.renderDrawableAllStates((ResourceValue)item.getSelectedValue());
        if (images.isEmpty()) {
            icon = ResourceSwatchComponent.WARNING_ICON;
        } else {
            icon = new ResourceSwatchComponent.SquareImageIcon((BufferedImage)Iterables.getLast(images));
            icon.setIsStack(images.size() > 1);
        }
        component2.setSwatchIcon(icon);
        String nameText = String.format("<html><nobr><b><font color=\"#%1$s\">%2$s", ColorUtil.toHex((Color)ThemeEditorConstants.RESOURCE_ITEM_COLOR), ThemeEditorUtils.getDisplayHtml(item));
        component2.setNameText(nameText);
        component2.setValueText(item.getValue());
    }

    @Override
    @NotNull
    protected EnumSet<ResourceType> getAllowedResourceTypes() {
        EnumSet<ResourceType> enumSet = GraphicalResourceRendererEditor.DRAWABLES_ONLY;
        if (enumSet == null) {
            DrawableRendererEditor.$$$reportNull$$$0(8);
        }
        return enumSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewPanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/theme/attributes/editors/DrawableRendererEditor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/theme/attributes/editors/DrawableRendererEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "configureRenderTask";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllowedResourceTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "configureRenderTask";
                break;
            }
            case 4: 
            case 8: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

