/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.intellij.ide.util.DeleteHandler;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.safeDelete.SafeDeleteDialog;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessor;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegate;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegateBase;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.HashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DelegateDeleteHandler {
    private DelegateDeleteHandler() {
    }

    public static void deletePsiElement(@NotNull Project project, @NotNull PsiElement[] elementsToDelete, @Nullable Module module) {
        if (project == null) {
            DelegateDeleteHandler.$$$reportNull$$$0(0);
        }
        if (elementsToDelete == null) {
            DelegateDeleteHandler.$$$reportNull$$$0(1);
        }
        if (elementsToDelete.length == 0) {
            return;
        }
        PsiElement[] elementRoots = PsiTreeUtil.filterAncestors((PsiElement[])elementsToDelete);
        HashSet elementsSet = new HashSet(Arrays.asList(elementRoots));
        LinkedHashSet<PsiElement> fullElementsSet = new LinkedHashSet<PsiElement>();
        for (PsiElement element : elementRoots) {
            boolean found = false;
            for (SafeDeleteProcessorDelegate delegate : SafeDeleteProcessorDelegate.EP_NAME.getExtensionList()) {
                Collection addElements;
                if (!delegate.handlesElement(element)) continue;
                found = true;
                Collection collection = addElements = delegate instanceof SafeDeleteProcessorDelegateBase ? ((SafeDeleteProcessorDelegateBase)delegate).getElementsToSearch(element, module, (Collection)elementsSet) : delegate.getElementsToSearch(element, (Collection)elementsSet);
                if (addElements == null) {
                    return;
                }
                fullElementsSet.addAll(addElements);
                break;
            }
            if (found) continue;
            fullElementsSet.add(element);
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project, fullElementsSet, (boolean)true)) {
            return;
        }
        PsiElement[] elements = PsiUtilCore.toPsiElementArray(fullElementsSet);
        boolean safeDeleteApplicable = true;
        for (int i = 0; i < elements.length && safeDeleteApplicable; ++i) {
            PsiElement element;
            element = elements[i];
            safeDeleteApplicable = SafeDeleteProcessor.validElement((PsiElement)element);
        }
        boolean dumb = DumbService.getInstance((Project)project).isDumb();
        if (!safeDeleteApplicable || dumb) {
            DeleteHandler.deletePsiElement((PsiElement[])elementRoots, (Project)project, (boolean)true);
            return;
        }
        Ref exit = Ref.create((Object)false);
        SafeDeleteDialog dialog = new SafeDeleteDialog(project, elements, dialog1 -> {
            if (project == null) {
                DelegateDeleteHandler.$$$reportNull$$$0(2);
            }
            if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project, Arrays.asList(elements), (boolean)true)) {
                return;
            }
            SafeDeleteProcessor processor = SafeDeleteProcessor.createInstance((Project)project, () -> {
                exit.set((Object)true);
                dialog1.close(0);
            }, (PsiElement[])elements, (boolean)dialog1.isSearchInComments(), (boolean)dialog1.isSearchForTextOccurences(), (boolean)true);
            processor.run();
        }){

            protected boolean isDelete() {
                return true;
            }
        };
        dialog.setTitle(RefactoringBundle.message((String)"delete.title"));
        if (!dialog.showAndGet() || ((Boolean)exit.get()).booleanValue()) {
            return;
        }
        DeleteHandler.deletePsiElement((PsiElement[])elementRoots, (Project)project, (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToDelete";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/editors/strings/DelegateDeleteHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "deletePsiElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$deletePsiElement$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

