/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.layoutInspector;

import com.android.ddmlib.Client;
import com.android.layoutinspector.model.ClientWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowPickerDialog
extends DialogWrapper {
    @NonNls
    private static final String WINDOW_PICKER_DIMENSIONS_KEY = "LayoutInspector.WindowPicker.Options.Dimensions";
    private final JPanel myPanel;
    private final JComboBox myWindowsCombo;
    @Nullable
    ClientWindow mySelectedWindow;

    public WindowPickerDialog(@NotNull Project project, @NotNull Client client, @NotNull List<ClientWindow> windows) {
        if (project == null) {
            WindowPickerDialog.$$$reportNull$$$0(0);
        }
        if (client == null) {
            WindowPickerDialog.$$$reportNull$$$0(1);
        }
        if (windows == null) {
            WindowPickerDialog.$$$reportNull$$$0(2);
        }
        super(project, true);
        this.setTitle(AndroidBundle.message("android.ddms.actions.layoutinspector.windowpicker", new Object[0]));
        this.myPanel = new JPanel(new BorderLayout());
        this.myWindowsCombo = new ComboBox((ComboBoxModel)new CollectionComboBoxModel(windows));
        this.myWindowsCombo.setRenderer(new ClientWindowRenderer());
        this.myWindowsCombo.setSelectedIndex(0);
        this.myPanel.add((Component)this.myWindowsCombo, "Center");
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return WINDOW_PICKER_DIMENSIONS_KEY;
    }

    protected void doOKAction() {
        Object selection = this.myWindowsCombo.getSelectedItem();
        if (selection instanceof ClientWindow) {
            this.mySelectedWindow = (ClientWindow)selection;
        }
        super.doOKAction();
    }

    @Nullable
    public ClientWindow getSelectedWindow() {
        return this.mySelectedWindow;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "client";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "windows";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/editors/layoutInspector/WindowPickerDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ClientWindowRenderer
    extends ColoredListCellRenderer {
        private ClientWindowRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                ClientWindowRenderer.$$$reportNull$$$0(0);
            }
            assert (value instanceof ClientWindow);
            this.append(((ClientWindow)value).getDisplayName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/editors/layoutInspector/WindowPickerDialog$ClientWindowRenderer", "customizeCellRenderer"));
        }
    }
}

