/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.layoutInspector;

import com.android.ddmlib.Client;
import com.android.layoutinspector.LayoutInspectorBridge;
import com.android.layoutinspector.LayoutInspectorCaptureOptions;
import com.android.layoutinspector.LayoutInspectorResult;
import com.android.layoutinspector.model.ClientWindow;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.editors.layoutInspector.LayoutInspectorCaptureType;
import com.android.tools.idea.editors.layoutInspector.LayoutInspectorEditor;
import com.android.tools.idea.profiling.capture.Capture;
import com.android.tools.idea.profiling.capture.CaptureService;
import com.android.tools.idea.stats.AndroidStudioUsageTracker;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.LayoutInspectorEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LayoutInspectorCaptureTask
extends Task.Backgroundable {
    private static final String TITLE = "Capture View Hierarchy";
    @NotNull
    private final Client myClient;
    @NotNull
    private final ClientWindow myWindow;
    private String myError;
    private byte[] myData;

    public LayoutInspectorCaptureTask(@NotNull Project project, @NotNull Client client, @NotNull ClientWindow window) {
        if (project == null) {
            LayoutInspectorCaptureTask.$$$reportNull$$$0(0);
        }
        if (client == null) {
            LayoutInspectorCaptureTask.$$$reportNull$$$0(1);
        }
        if (window == null) {
            LayoutInspectorCaptureTask.$$$reportNull$$$0(2);
        }
        super(project, "Capturing View Hierarchy");
        this.myClient = client;
        this.myWindow = window;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            LayoutInspectorCaptureTask.$$$reportNull$$$0(3);
        }
        LayoutInspectorCaptureOptions options = new LayoutInspectorCaptureOptions();
        options.setTitle(this.myWindow.getDisplayName());
        indicator.setText("Capturing View Hierarchy");
        indicator.setIndeterminate(false);
        long startTimeMs = System.currentTimeMillis();
        LayoutInspectorResult result = LayoutInspectorBridge.captureView((ClientWindow)this.myWindow, (LayoutInspectorCaptureOptions)options);
        long captureDurationMs = System.currentTimeMillis() - startTimeMs;
        UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.LAYOUT_INSPECTOR_EVENT).setDeviceInfo(AndroidStudioUsageTracker.deviceToDeviceInfo(this.myClient.getDevice())).setLayoutInspectorEvent(LayoutInspectorEvent.newBuilder().setType(LayoutInspectorEvent.LayoutInspectorEventType.CAPTURE).setDurationInMs(captureDurationMs).setDataSize(result.getError().isEmpty() ? (long)result.getData().length : 0L)));
        if (!result.getError().isEmpty()) {
            this.myError = result.getError();
            return;
        }
        this.myData = result.getData();
    }

    public void onSuccess() {
        if (this.myError != null) {
            Messages.showErrorDialog((String)("Error obtaining view hierarchy: " + StringUtil.notNullize((String)this.myError)), (String)TITLE);
            return;
        }
        CaptureService service = CaptureService.getInstance(this.myProject);
        try {
            Capture capture = service.createCapture(LayoutInspectorCaptureType.class, this.myData, service.getSuggestedName(this.myClient));
            VirtualFile file = capture.getFile();
            file.refresh(true, false, () -> UIUtil.invokeLaterIfNeeded(() -> {
                OpenFileDescriptor descriptor = new OpenFileDescriptor(this.myProject, file);
                List editors = FileEditorManager.getInstance((Project)this.myProject).openEditor(descriptor, true);
                editors.stream().filter(e -> e instanceof LayoutInspectorEditor).findFirst().ifPresent(editor -> ((LayoutInspectorEditor)((Object)((Object)((Object)editor)))).setSources(this.myClient, this.myWindow));
            }));
        }
        catch (IOException e) {
            Messages.showErrorDialog((String)("Error creating hierarchy view capture: " + e), (String)TITLE);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/editors/layoutInspector/LayoutInspectorCaptureTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

