/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.ClientCellRenderer;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.DeviceNameProperties;
import com.android.tools.idea.ddms.DeviceNamePropertiesFetcher;
import com.android.tools.idea.ddms.DeviceRenderer;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.FutureCallback;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DevicePanel
implements AndroidDebugBridge.IDeviceChangeListener,
AndroidDebugBridge.IDebugBridgeChangeListener,
AndroidDebugBridge.IClientChangeListener,
Disposable {
    private static final Logger LOG = Logger.getInstance(DevicePanel.class);
    private JPanel myPanel;
    private final DeviceContext myDeviceContext;
    @Nullable
    private AndroidDebugBridge myBridge;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<String, String> myPreferredClients;
    private boolean myIgnoringActionEvents;
    private JComboBox<IDevice> myDeviceCombo;
    private JComboBox<Client> myClientCombo;
    private final NullableLazyValue<String> myCandidateClientName;
    private DeviceRenderer.DeviceComboBoxRenderer myDeviceRenderer;

    public DevicePanel(@NotNull Project project, @NotNull DeviceContext context) {
        if (project == null) {
            DevicePanel.$$$reportNull$$$0(0);
        }
        if (context == null) {
            DevicePanel.$$$reportNull$$$0(1);
        }
        this.$$$setupUI$$$();
        this.myCandidateClientName = new NullableLazyValue<String>(){

            @Nullable
            protected String compute() {
                return DevicePanel.this.getApplicationName();
            }
        };
        this.myProject = project;
        this.myDeviceContext = context;
        this.myPreferredClients = Maps.newHashMap();
        Disposer.register((Disposable)this.myProject, (Disposable)this);
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
        AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
    }

    private void createUIComponents() {
        this.initializeDeviceCombo();
        this.initializeClientCombo();
    }

    private void initializeDeviceCombo() {
        this.myDeviceCombo = new ComboBox();
        AccessibleContextUtil.setName(this.myDeviceCombo, (String)"Devices");
        this.myDeviceCombo.addActionListener(actionEvent -> {
            if (this.myIgnoringActionEvents) {
                return;
            }
            this.updateClientCombo();
            Object sel = this.myDeviceCombo.getSelectedItem();
            IDevice device = sel instanceof IDevice ? (IDevice)sel : null;
            this.myDeviceContext.fireDeviceSelected(device);
        });
        boolean showSerial = false;
        if (this.myBridge != null) {
            showSerial = DeviceRenderer.shouldShowSerialNumbers(Arrays.asList(this.myBridge.getDevices()));
        }
        this.myDeviceRenderer = new DeviceRenderer.DeviceComboBoxRenderer("No Connected Devices", showSerial, new DeviceNamePropertiesFetcher(new FutureCallback<DeviceNameProperties>(){

            public void onSuccess(@Nullable DeviceNameProperties result) {
                DevicePanel.this.updateDeviceCombo();
            }

            public void onFailure(@NotNull Throwable t) {
                if (t == null) {
                    2.$$$reportNull$$$0(0);
                }
                LOG.warn("Error retrieving device name properties", t);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/ddms/DevicePanel$2", "onFailure"));
            }
        }, this));
        this.myDeviceCombo.setRenderer((ListCellRenderer<IDevice>)((Object)this.myDeviceRenderer));
        Dimension size = this.myDeviceCombo.getMinimumSize();
        this.myDeviceCombo.setMinimumSize(new Dimension(200, size.height));
    }

    private void initializeClientCombo() {
        this.myClientCombo = new ComboBox();
        AccessibleContextUtil.setName(this.myClientCombo, (String)"Processes");
        this.myClientCombo.setName("Processes");
        this.myClientCombo.addActionListener(actionEvent -> {
            if (this.myIgnoringActionEvents) {
                return;
            }
            Client client = (Client)this.myClientCombo.getSelectedItem();
            if (client != null) {
                this.myPreferredClients.put(client.getDevice().getName(), client.getClientData().getClientDescription());
            }
            this.myDeviceContext.fireClientSelected(client);
        });
        this.myClientCombo.setRenderer((ListCellRenderer<Client>)((Object)new ClientCellRenderer("No Debuggable Processes")));
        Dimension size = this.myClientCombo.getMinimumSize();
        this.myClientCombo.setMinimumSize(new Dimension(250, size.height));
    }

    @NotNull
    public JComboBox<IDevice> getDeviceComboBox() {
        JComboBox<IDevice> jComboBox = this.myDeviceCombo;
        if (jComboBox == null) {
            DevicePanel.$$$reportNull$$$0(2);
        }
        return jComboBox;
    }

    public void selectDevice(IDevice device) {
        this.myDeviceCombo.setSelectedItem(device);
    }

    @NotNull
    public Component getClientComboBox() {
        JComboBox<Client> jComboBox = this.myClientCombo;
        if (jComboBox == null) {
            DevicePanel.$$$reportNull$$$0(3);
        }
        return jComboBox;
    }

    public void selectClient(Client client) {
        this.myClientCombo.setSelectedItem(client);
    }

    @Nullable
    private String getApplicationName() {
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            String pkg;
            AndroidModuleInfo moduleInfo = AndroidModuleInfo.getInstance(module);
            if (moduleInfo == null || (pkg = moduleInfo.getPackage()) == null) continue;
            return pkg;
        }
        return null;
    }

    public void dispose() {
        if (this.myBridge != null) {
            AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
            AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
            AndroidDebugBridge.removeDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
            this.myBridge = null;
        }
    }

    public JPanel getComponent() {
        return this.myPanel;
    }

    public void bridgeChanged(AndroidDebugBridge bridge) {
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> UIUtil.invokeLaterIfNeeded(() -> {
            this.myBridge = bridge;
            this.updateDeviceCombo();
        }));
    }

    void setBridge(@NotNull AndroidDebugBridge bridge) {
        if (bridge == null) {
            DevicePanel.$$$reportNull$$$0(4);
        }
        this.myBridge = bridge;
    }

    public void deviceConnected(@NotNull IDevice device) {
        if (device == null) {
            DevicePanel.$$$reportNull$$$0(5);
        }
        LOG.info("Device connected: " + device.getName());
        UIUtil.invokeLaterIfNeeded(this::updateDeviceCombo);
    }

    public void deviceDisconnected(@NotNull IDevice device) {
        if (device == null) {
            DevicePanel.$$$reportNull$$$0(6);
        }
        LOG.info("Device disconnected: " + device.getName());
        UIUtil.invokeLaterIfNeeded(this::updateDeviceCombo);
    }

    public void deviceChanged(@NotNull IDevice device, int changeMask) {
        if (device == null) {
            DevicePanel.$$$reportNull$$$0(7);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (device == null) {
                DevicePanel.$$$reportNull$$$0(13);
            }
            if ((changeMask & 2) != 0) {
                this.updateClientCombo();
            } else if ((changeMask & 1) != 0) {
                this.updateDeviceCombo();
            }
            this.myDeviceContext.fireDeviceChanged(device, changeMask);
        });
    }

    public void clientChanged(@NotNull Client client, int changeMask) {
        if (client == null) {
            DevicePanel.$$$reportNull$$$0(8);
        }
        if ((changeMask & 1) != 0) {
            ApplicationManager.getApplication().invokeLater(this::updateClientCombo);
        }
    }

    void updateDeviceCombo() {
        if (this.myBridge == null) {
            return;
        }
        this.myIgnoringActionEvents = true;
        IDevice selectedDevice = (IDevice)this.myDeviceCombo.getSelectedItem();
        this.myDeviceCombo.removeAllItems();
        List<IDevice> devices = Arrays.asList(this.myBridge.getDevices());
        devices.forEach(device -> this.myDeviceCombo.addItem((IDevice)device));
        this.myDeviceRenderer.setShowSerial(DeviceRenderer.shouldShowSerialNumbers(devices));
        Optional<IDevice> optionalDevice = IntStream.range(0, this.myDeviceCombo.getItemCount()).mapToObj(i -> this.myDeviceCombo.getItemAt(i)).filter(device -> DevicePanel.equals(device, selectedDevice)).findFirst();
        if (optionalDevice.isPresent()) {
            IDevice device2 = optionalDevice.get();
            this.myDeviceCombo.setSelectedItem(device2);
            this.myDeviceContext.fireDeviceSelected(device2);
        } else if (selectedDevice != null) {
            this.myDeviceCombo.addItem(selectedDevice);
            this.myDeviceCombo.setSelectedItem(selectedDevice);
            this.myDeviceContext.fireDeviceSelected(selectedDevice);
        }
        this.updateClientCombo();
        this.myIgnoringActionEvents = false;
    }

    private static boolean equals(@NotNull IDevice device1, @Nullable IDevice device2) {
        if (device1 == null) {
            DevicePanel.$$$reportNull$$$0(9);
        }
        if (device2 == null) {
            return false;
        }
        boolean device1Emulator = device1.isEmulator();
        if (device1Emulator != device2.isEmulator()) {
            return false;
        }
        if (device1Emulator) {
            return Objects.equals(device1.getAvdName(), device2.getAvdName());
        }
        return device1.getSerialNumber().equals(device2.getSerialNumber());
    }

    private void updateClientCombo() {
        this.myIgnoringActionEvents = true;
        IDevice device = (IDevice)this.myDeviceCombo.getSelectedItem();
        Client selected = (Client)this.myClientCombo.getSelectedItem();
        Client toSelect = null;
        boolean update = true;
        this.myClientCombo.removeAllItems();
        if (device != null) {
            boolean selectedClientDied;
            Client preferredClient;
            String preferred = this.getPreferredClient(device.getName());
            if (preferred != null && (preferredClient = device.getClient(preferred)) != null) {
                toSelect = preferredClient;
            }
            ArrayList clients = Lists.newArrayList((Object[])device.getClients());
            boolean bl = selectedClientDied = selected != null && selected.getDevice() == device && !clients.contains(selected);
            if (selectedClientDied) {
                if (toSelect == null) {
                    toSelect = selected;
                }
                clients.add(selected);
            }
            clients.sort(new ClientCellRenderer.ClientComparator());
            for (Client client : clients) {
                this.myClientCombo.addItem(client);
            }
            this.myClientCombo.setSelectedItem(toSelect);
            update = toSelect != selected;
        }
        this.myIgnoringActionEvents = false;
        if (update) {
            this.myDeviceContext.fireClientSelected((Client)this.myClientCombo.getSelectedItem());
        }
    }

    void setIgnoringActionEvents(boolean ignoringActionEvents) {
        this.myIgnoringActionEvents = ignoringActionEvents;
    }

    @Nullable
    private String getPreferredClient(@NotNull String device) {
        String client;
        if (device == null) {
            DevicePanel.$$$reportNull$$$0(10);
        }
        return (client = this.myPreferredClients.get(device)) == null ? (String)this.myCandidateClientName.getValue() : client;
    }

    void putPreferredClient(@NotNull String device, @NotNull String client) {
        if (device == null) {
            DevicePanel.$$$reportNull$$$0(11);
        }
        if (client == null) {
            DevicePanel.$$$reportNull$$$0(12);
        }
        this.myPreferredClients.put(device, client);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/ddms/DevicePanel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bridge";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device1";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/ddms/DevicePanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceComboBox";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getClientComboBox";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setBridge";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deviceConnected";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deviceDisconnected";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "deviceChanged";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "clientChanged";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "equals";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredClient";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "putPreferredClient";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$deviceChanged$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JComboBox<IDevice> jComboBox = this.myDeviceCombo;
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JComboBox<Client> jComboBox2 = this.myClientCombo;
        jPanel.add(jComboBox2, new GridConstraints(0, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 1, new Dimension(20, -1), new Dimension(27, 11), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

