/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import com.android.resources.ScreenRound;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Screen;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.ColorSet;
import com.google.common.collect.ImmutableList;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SceneView {
    private final DesignSurface mySurface;
    private final SceneManager myManager;
    private ImmutableList<Layer> myLayers;
    private int x;
    private int y;

    public SceneView(@NotNull DesignSurface surface, @NotNull SceneManager manager) {
        if (surface == null) {
            SceneView.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SceneView.$$$reportNull$$$0(1);
        }
        this.mySurface = surface;
        this.myManager = manager;
    }

    @NotNull
    protected abstract ImmutableList<Layer> createLayers();

    @NotNull
    public final ImmutableList<Layer> getLayers() {
        if (this.myLayers == null) {
            this.myLayers = this.createLayers();
        }
        ImmutableList<Layer> immutableList = this.myLayers;
        if (immutableList == null) {
            SceneView.$$$reportNull$$$0(2);
        }
        return immutableList;
    }

    @NotNull
    public Scene getScene() {
        Scene scene = this.myManager.getScene();
        if (scene == null) {
            SceneView.$$$reportNull$$$0(3);
        }
        return scene;
    }

    @NotNull
    public Dimension getSize(@Nullable Dimension dimension2) {
        if (dimension2 == null) {
            dimension2 = new Dimension();
        }
        Dimension preferred = this.getPreferredSize(dimension2);
        double scale = this.getScale();
        dimension2.setSize((int)(scale * (double)preferred.width), (int)(scale * (double)preferred.height));
        Dimension dimension3 = dimension2;
        if (dimension3 == null) {
            SceneView.$$$reportNull$$$0(4);
        }
        return dimension3;
    }

    @NotNull
    public Dimension getPreferredSize() {
        Dimension dimension2 = this.getPreferredSize(null);
        if (dimension2 == null) {
            SceneView.$$$reportNull$$$0(5);
        }
        return dimension2;
    }

    @NotNull
    public Dimension getSize() {
        Dimension dimension2 = this.getSize(null);
        if (dimension2 == null) {
            SceneView.$$$reportNull$$$0(6);
        }
        return dimension2;
    }

    @NotNull
    public abstract Dimension getPreferredSize(@Nullable Dimension var1);

    @NotNull
    public Configuration getConfiguration() {
        Configuration configuration = this.getSceneManager().getModel().getConfiguration();
        if (configuration == null) {
            SceneView.$$$reportNull$$$0(7);
        }
        return configuration;
    }

    @Deprecated
    @NotNull
    public NlModel getModel() {
        NlModel nlModel = this.myManager.getModel();
        if (nlModel == null) {
            SceneView.$$$reportNull$$$0(8);
        }
        return nlModel;
    }

    @NotNull
    public SelectionModel getSelectionModel() {
        SelectionModel selectionModel = this.getSurface().getSelectionModel();
        if (selectionModel == null) {
            SceneView.$$$reportNull$$$0(9);
        }
        return selectionModel;
    }

    @Nullable
    public Shape getScreenShape() {
        Device device = this.getConfiguration().getDevice();
        if (device == null) {
            return null;
        }
        Screen screen = device.getDefaultHardware().getScreen();
        if (screen.getScreenRound() != ScreenRound.ROUND) {
            return null;
        }
        Dimension size = this.getSize();
        int chin = screen.getChin();
        int originX = this.getX();
        int originY = this.getY();
        if (chin == 0) {
            return new Ellipse2D.Double(originX, originY, size.width, size.height);
        }
        int height = size.height * chin / screen.getYDimension();
        Area a1 = new Area(new Ellipse2D.Double(originX, originY, size.width, size.height + height));
        Area a2 = new Area(new Rectangle2D.Double(originX, originY + 2 * (size.height + height) - height, size.width, height));
        a1.subtract(a2);
        return a1;
    }

    @NotNull
    public DesignSurface getSurface() {
        DesignSurface designSurface = this.mySurface;
        if (designSurface == null) {
            SceneView.$$$reportNull$$$0(10);
        }
        return designSurface;
    }

    public double getScale() {
        return this.getSurface().getScale();
    }

    public void setLocation(int screenX, int screenY) {
        this.x = screenX;
        this.y = screenY;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getContentTranslationX() {
        return 0;
    }

    public int getContentTranslationY() {
        return 0;
    }

    @Nullable
    public Cursor getCursor(int x, int y) {
        SceneContext.get(this).setMouseLocation(x, y);
        this.getScene().mouseHover(SceneContext.get(this), Coordinates.getAndroidXDip(this, x), Coordinates.getAndroidYDip(this, y));
        return this.getScene().getMouseCursor();
    }

    public SceneManager getSceneManager() {
        return this.myManager;
    }

    public void setToolTip(String toolTip) {
        this.getSurface().setDesignToolTip(toolTip);
    }

    @NotNull
    public abstract ColorSet getColorSet();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/surface/SceneView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/surface/SceneView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayers";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getScene";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSize";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredSize";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionModel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSurface";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

