/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawRegion;
import com.android.tools.idea.common.scene.draw.FancyStroke;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.ColorSet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;

public class DrawNlComponentFrame
extends DrawRegion {
    public static final int SUBDUED = 0;
    public static final int NORMAL = 1;
    public static final int OVER = 2;
    public static final int SELECTED = 3;
    static Stroke myNormalStroke = new BasicStroke(1.0f);
    static Stroke myProblemStroke = new BasicStroke(2.0f);
    static Stroke myWrapStroke = new BasicStroke(1.0f);
    static Stroke myMatchParentStroke = new BasicStroke(1.0f);
    static Stroke myDragReceiverStroke = new BasicStroke(3.0f);
    static Stroke myMatchConstraintStroke = new FancyStroke(FancyStroke.Type.SPRING, 2.0f, 2, 1.0f);
    int myMode;
    int myLayoutWidth;
    int myLayoutHeight;
    int myLevel = 20;

    public DrawNlComponentFrame(String s) {
        String[] sp = s.split(",");
        int c = 0;
        c = super.parse(sp, c);
        this.myMode = Integer.parseInt(sp[c++]);
        this.myLayoutWidth = Integer.parseInt(sp[c++]);
        this.myLayoutHeight = Integer.parseInt(sp[c++]);
    }

    @Override
    public int getLevel() {
        return this.myLevel;
    }

    public DrawNlComponentFrame(int x, int y, int width, int height, int mode, int layout_width, int layout_height) {
        super(x, y, width, height);
        this.myMode = mode;
        this.myLayoutWidth = layout_width;
        this.myLayoutHeight = layout_height;
        if (mode == 3) {
            this.myLevel = 30;
        }
    }

    private Stroke getStroke(int dim) {
        if (dim == 0) {
            return myMatchConstraintStroke;
        }
        if (dim == -1) {
            return myMatchParentStroke;
        }
        if (dim == -2) {
            return myWrapStroke;
        }
        return myNormalStroke;
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        ColorSet colorSet = sceneContext.getColorSet();
        Color[] colorFrame = new Color[]{colorSet.getSubduedFrames(), colorSet.getFrames(), colorSet.getHighlightedFrames(), colorSet.getSelectedFrames(), colorSet.getDragReceiverFrames()};
        Stroke previousStroke = g.getStroke();
        g.setStroke(myNormalStroke);
        g.setColor(colorFrame[this.myMode]);
        if (this.myLayoutWidth == this.myLayoutHeight || this.myMode == 4) {
            if (this.myMode == 4) {
                g.setStroke(myDragReceiverStroke);
            } else {
                g.setStroke(this.getStroke(this.myLayoutWidth));
            }
            g.drawRect(this.x, this.y, this.width, this.height);
        } else {
            g.setColor(colorFrame[this.myMode]);
            g.setStroke(this.getStroke(this.myLayoutHeight));
            g.drawLine(this.x, this.y, this.x, this.y + this.height);
            g.drawLine(this.x + this.width, this.y, this.x + this.width, this.y + this.height);
            g.setColor(colorFrame[this.myMode]);
            g.setStroke(this.getStroke(this.myLayoutWidth));
            g.drawLine(this.x, this.y, this.x + this.width, this.y);
            g.drawLine(this.x, this.y + this.height, this.x + this.width, this.y + this.height);
        }
        g.setStroke(previousStroke);
    }

    @Override
    public String serialize() {
        return super.serialize() + "," + this.myMode + "," + this.myLayoutHeight + "," + this.myLayoutHeight;
    }

    public static void add(DisplayList list, SceneContext sceneContext, Rectangle rect, int mode, int layout_width, int layout_height) {
        int l = sceneContext.getSwingXDip(rect.x);
        int t = sceneContext.getSwingYDip(rect.y);
        int w = sceneContext.getSwingDimensionDip(rect.width);
        int h = sceneContext.getSwingDimensionDip(rect.height);
        list.add(new DrawNlComponentFrame(l, t, w, h, mode, layout_width, layout_height));
    }
}

