/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.model;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.SelectionListener;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.uibuilder.model.DnDTransferComponent;
import com.android.tools.idea.uibuilder.model.DnDTransferItem;
import com.android.tools.idea.uibuilder.model.ItemTransferable;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.model.SelectionHandle;
import com.android.tools.idea.uibuilder.model.SelectionHandles;
import com.android.tools.idea.util.ListenerCollection;
import com.android.utils.ImmutableCollectors;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectionModel {
    @NotNull
    private ImmutableList<NlComponent> mySelection = ImmutableList.of();
    private NlComponent myPrimary;
    private final ListenerCollection<SelectionListener> myListeners = ListenerCollection.createWithDirectExecutor();
    private Map<NlComponent, SelectionHandles> myHandles;

    @NotNull
    public ImmutableList<NlComponent> getSelection() {
        ImmutableList<NlComponent> immutableList = this.mySelection;
        if (immutableList == null) {
            SelectionModel.$$$reportNull$$$0(0);
        }
        return immutableList;
    }

    @Nullable
    public NlComponent getPrimary() {
        return this.myPrimary;
    }

    public void setSelection(@NotNull List<NlComponent> components) {
        if (components == null) {
            SelectionModel.$$$reportNull$$$0(1);
        }
        this.setSelection((List<NlComponent>)ImmutableList.copyOf(components), components.isEmpty() ? null : components.iterator().next());
    }

    public void setSelection(@NotNull List<NlComponent> components, @Nullable NlComponent primary) {
        if (components == null) {
            SelectionModel.$$$reportNull$$$0(2);
        }
        if (components.equals(this.mySelection)) {
            return;
        }
        this.myHandles = null;
        this.mySelection = ImmutableList.copyOf(components);
        this.myPrimary = primary;
        this.notifySelectionChanged();
    }

    public void clear() {
        if (this.mySelection.isEmpty()) {
            return;
        }
        this.myHandles = null;
        this.mySelection = ImmutableList.of();
        this.myPrimary = null;
        this.notifySelectionChanged();
    }

    public void toggle(@NotNull NlComponent component2) {
        NlComponent newPrimary;
        ImmutableList newSelection;
        int size;
        if (component2 == null) {
            SelectionModel.$$$reportNull$$$0(3);
        }
        if ((size = this.mySelection.size()) == 0) {
            newSelection = ImmutableList.of((Object)component2);
            newPrimary = component2;
        } else if (this.mySelection.contains((Object)component2)) {
            if (size == 1) {
                newSelection = ImmutableList.of();
                newPrimary = null;
            } else {
                newSelection = (ImmutableList)this.mySelection.stream().filter(selection -> {
                    if (component2 == null) {
                        SelectionModel.$$$reportNull$$$0(9);
                    }
                    return !selection.equals(component2);
                }).collect(ImmutableCollectors.toImmutableList());
                newPrimary = this.myPrimary == component2 ? null : this.myPrimary;
            }
        } else {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(this.mySelection);
            builder.add((Object)component2);
            newSelection = builder.build();
            newPrimary = this.myPrimary;
        }
        this.setSelection((List<NlComponent>)newSelection, newPrimary);
    }

    private void notifySelectionChanged() {
        this.myListeners.forEach(l -> l.selectionChanged(this, (List<NlComponent>)this.mySelection));
    }

    public void addListener(@NotNull SelectionListener listener) {
        if (listener == null) {
            SelectionModel.$$$reportNull$$$0(4);
        }
        this.myListeners.add(listener);
    }

    public void removeListener(@Nullable SelectionListener listener) {
        this.myListeners.remove(listener);
    }

    public boolean isEmpty() {
        return this.mySelection.isEmpty();
    }

    @Nullable
    public SelectionHandle findHandle(int x, int y, int maxDistance, @NotNull DesignSurface surface) {
        if (surface == null) {
            SelectionModel.$$$reportNull$$$0(5);
        }
        if (this.myHandles == null) {
            return null;
        }
        for (SelectionHandles handles : this.myHandles.values()) {
            SelectionHandle handle = handles.findHandle(x, y, maxDistance, surface);
            if (handle == null) continue;
            return handle;
        }
        return null;
    }

    @NotNull
    public SelectionHandles getHandles(@NotNull NlComponent component2) {
        SelectionHandles handles;
        if (component2 == null) {
            SelectionModel.$$$reportNull$$$0(6);
        }
        if (this.myHandles == null) {
            this.myHandles = Maps.newHashMap();
        }
        if ((handles = this.myHandles.get(component2)) == null) {
            handles = new SelectionHandles(component2);
            this.myHandles.put(component2, handles);
        }
        SelectionHandles selectionHandles = handles;
        if (selectionHandles == null) {
            SelectionModel.$$$reportNull$$$0(7);
        }
        return selectionHandles;
    }

    public boolean isSelected(@NotNull NlComponent component2) {
        if (component2 == null) {
            SelectionModel.$$$reportNull$$$0(8);
        }
        return this.mySelection.contains((Object)component2);
    }

    public ItemTransferable getTransferable(long modelId) {
        ImmutableList components = (ImmutableList)this.mySelection.stream().map(component2 -> new DnDTransferComponent(component2.getTagName(), component2.getTag().getText(), NlComponentHelperKt.getW(component2), NlComponentHelperKt.getH(component2))).collect(ImmutableCollectors.toImmutableList());
        return new ItemTransferable(new DnDTransferItem(modelId, (ImmutableList<DnDTransferComponent>)components));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/model/SelectionModel";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelection";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/model/SelectionModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandles";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setSelection";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toggle";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findHandle";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getHandles";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$toggle$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

