/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.editor;

import com.android.tools.adtui.common.AdtPrimaryPanel;
import com.android.tools.adtui.workbench.AutoHide;
import com.android.tools.adtui.workbench.Side;
import com.android.tools.adtui.workbench.Split;
import com.android.tools.adtui.workbench.ToolWindowDefinition;
import com.android.tools.adtui.workbench.WorkBench;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.editor.NlEditor;
import com.android.tools.idea.common.model.NlLayoutType;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.naveditor.property.NavPropertyPanelDefinition;
import com.android.tools.idea.naveditor.structure.DestinationList;
import com.android.tools.idea.naveditor.surface.NavDesignSurface;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.startup.ClearResourceCacheAfterFirstBuild;
import com.android.tools.idea.uibuilder.error.IssuePanelSplitter;
import com.android.tools.idea.uibuilder.mockup.editor.MockupToolDefinition;
import com.android.tools.idea.uibuilder.palette2.PaletteDefinition;
import com.android.tools.idea.uibuilder.property.NlPropertyPanelDefinition;
import com.android.tools.idea.uibuilder.structure.NlComponentTreeDefinition;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.util.SyncUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.JBSplitter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlEditorPanel
extends JPanel
implements Disposable {
    private final NlEditor myEditor;
    private final Project myProject;
    private final VirtualFile myFile;
    private final DesignSurface mySurface;
    private final JPanel myContentPanel;
    private final WorkBench<DesignSurface> myWorkBench;
    private boolean myIsActive;
    private JBSplitter mySplitter;

    public NlEditorPanel(@NotNull NlEditor editor, @NotNull Project project, @NotNull VirtualFile file) {
        if (editor == null) {
            NlEditorPanel.$$$reportNull$$$0(0);
        }
        if (project == null) {
            NlEditorPanel.$$$reportNull$$$0(1);
        }
        if (file == null) {
            NlEditorPanel.$$$reportNull$$$0(2);
        }
        super(new BorderLayout());
        this.myWorkBench = new WorkBench(project, "NELE_EDITOR", (FileEditor)editor);
        this.myWorkBench.setOpaque(true);
        this.myEditor = editor;
        this.myProject = project;
        this.myFile = file;
        this.myContentPanel = new AdtPrimaryPanel((LayoutManager)new BorderLayout());
        if (NlLayoutType.typeOf(this.getFile()) == NlLayoutType.NAV) {
            this.mySurface = new NavDesignSurface(project, (Disposable)editor);
        } else {
            this.mySurface = new NlDesignSurface(project, false, (Disposable)editor);
            ((NlDesignSurface)this.mySurface).setCentered(true);
        }
        this.myWorkBench.setLoadingText("Waiting for build to finish...");
        ClearResourceCacheAfterFirstBuild.getInstance(project).runWhenResourceCacheClean(this::initNeleModel, this::buildError);
        this.mySplitter = new IssuePanelSplitter(this.mySurface, (JComponent)this.myWorkBench);
        this.add((Component)this.mySplitter);
        Disposer.register((Disposable)editor, this.myWorkBench);
    }

    private void buildError() {
        this.myWorkBench.loadingStopped("Design editor is unavailable until a successful build");
    }

    private void initNeleModel() {
        ProjectSystemSyncManager syncManager = ProjectSystemUtil.getSyncManager(this.myProject);
        if (!syncManager.isSyncInProgress()) {
            if (syncManager.getLastSyncResult().isSuccessful()) {
                DumbService.getInstance((Project)this.myProject).smartInvokeLater(() -> this.initNeleModelWhenSmart());
                return;
            }
            this.buildError();
        }
        SyncUtil.listenUntilNextSuccessfulSync(this.myProject, (Disposable)this.myEditor, result -> {
            if (result.isSuccessful()) {
                DumbService.getInstance((Project)this.myProject).smartInvokeLater(() -> this.initNeleModelWhenSmart());
            } else {
                this.buildError();
            }
        });
    }

    private void initNeleModelWhenSmart() {
        if (Disposer.isDisposed((Disposable)this.myEditor) || this.myContentPanel.getComponentCount() > 0) {
            return;
        }
        NlModel model = (NlModel)ReadAction.compute(() -> {
            XmlFile file = this.getFile();
            AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
            assert (facet != null);
            return NlModel.create((Disposable)this.myEditor, facet, this.myFile);
        });
        CompletableFuture<?> complete = this.mySurface.goingToSetModel(model);
        complete.whenComplete((a, b) -> DumbService.getInstance((Project)this.myProject).smartInvokeLater(() -> this.initNeleModelOnEventDispatchThread(model)));
    }

    private void initNeleModelOnEventDispatchThread(NlModel model) {
        this.mySurface.setModel(model);
        Disposer.register((Disposable)this.myEditor, (Disposable)this.mySurface);
        JComponent toolbarComponent = this.mySurface.getActionManager().createToolbar(model);
        this.myContentPanel.add((Component)toolbarComponent, "North");
        this.myContentPanel.add((Component)((Object)this.mySurface));
        ArrayList<ToolWindowDefinition> tools = new ArrayList<ToolWindowDefinition>(4);
        if (NlLayoutType.typeOf(model.getFile()) == NlLayoutType.NAV) {
            tools.add(new NavPropertyPanelDefinition(model.getFacet(), Side.RIGHT, Split.TOP, AutoHide.DOCKED));
            tools.add(new DestinationList.DestinationListDefinition());
        } else {
            tools.add(new PaletteDefinition(this.myProject, Side.LEFT, Split.TOP, AutoHide.DOCKED));
            tools.add(new NlPropertyPanelDefinition(model.getFacet(), Side.RIGHT, Split.TOP, AutoHide.DOCKED));
            tools.add(new NlComponentTreeDefinition(this.myProject, Side.LEFT, Split.BOTTOM, AutoHide.DOCKED));
            if (((Boolean)StudioFlags.NELE_MOCKUP_EDITOR.get()).booleanValue()) {
                tools.add(new MockupToolDefinition(Side.RIGHT, Split.TOP, AutoHide.AUTO_HIDE));
            }
        }
        this.myWorkBench.init((JComponent)this.myContentPanel, (Object)this.mySurface, tools);
        if (this.myIsActive) {
            model.activate(this.myWorkBench);
        }
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.mySurface.getPreferredFocusedComponent();
    }

    public void activate() {
        this.mySurface.activate();
        this.myIsActive = true;
    }

    public void deactivate() {
        this.mySurface.deactivate();
        this.myIsActive = false;
    }

    @NotNull
    public DesignSurface getSurface() {
        DesignSurface designSurface = this.mySurface;
        if (designSurface == null) {
            NlEditorPanel.$$$reportNull$$$0(3);
        }
        return designSurface;
    }

    @NotNull
    public XmlFile getFile() {
        XmlFile file = (XmlFile)AndroidPsiUtils.getPsiFileSafely(this.myProject, this.myFile);
        assert (file != null);
        XmlFile xmlFile = file;
        if (xmlFile == null) {
            NlEditorPanel.$$$reportNull$$$0(4);
        }
        return xmlFile;
    }

    public void setIssuePanelProportion(float proportion) {
        this.mySplitter.setProportion(proportion);
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/editor/NlEditorPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/editor/NlEditorPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSurface";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

