/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.debugging;

import com.android.tools.idea.apk.debugging.ApkClass;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ApkPackage {
    @NotNull
    private final String myName;
    @NotNull
    private final String myFqn;
    @Nullable
    private final ApkPackage myParent;
    @NotNull
    private final Map<String, ApkPackage> mySubpackagesByName;
    @NotNull
    private final Map<String, ApkClass> myClassesByName;

    public ApkPackage(@NotNull String name, @Nullable ApkPackage parent) {
        if (name == null) {
            ApkPackage.$$$reportNull$$$0(0);
        }
        this.mySubpackagesByName = new HashMap<String, ApkPackage>();
        this.myClassesByName = new HashMap<String, ApkClass>();
        this.myName = name;
        this.myParent = parent;
        this.myFqn = this.myParent != null ? this.myParent.getFqn() + "." + this.myName : this.myName;
    }

    @NotNull
    public Collection<ApkPackage> getSubpackages() {
        Collection<ApkPackage> collection = this.mySubpackagesByName.values();
        if (collection == null) {
            ApkPackage.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @Nullable
    public ApkPackage findSubpackage(@NotNull String name) {
        if (name == null) {
            ApkPackage.$$$reportNull$$$0(2);
        }
        return this.mySubpackagesByName.get(name);
    }

    @NotNull
    public Collection<ApkClass> getClasses() {
        Collection<ApkClass> collection = this.myClassesByName.values();
        if (collection == null) {
            ApkPackage.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @Nullable
    public ApkClass findClass(@NotNull String name) {
        if (name == null) {
            ApkPackage.$$$reportNull$$$0(4);
        }
        return this.myClassesByName.get(name);
    }

    @Nullable
    public ApkPackage getParent() {
        return this.myParent;
    }

    @NotNull
    public ApkPackage addSubpackage(@NotNull String name) {
        if (name == null) {
            ApkPackage.$$$reportNull$$$0(5);
        }
        ApkPackage apkPackage = this.mySubpackagesByName.computeIfAbsent(name, k -> {
            if (name == null) {
                ApkPackage.$$$reportNull$$$0(12);
            }
            return new ApkPackage(name, this);
        });
        if (apkPackage == null) {
            ApkPackage.$$$reportNull$$$0(6);
        }
        return apkPackage;
    }

    @NotNull
    public ApkClass addClass(@NotNull String name) {
        if (name == null) {
            ApkPackage.$$$reportNull$$$0(7);
        }
        ApkClass apkClass = this.myClassesByName.computeIfAbsent(name, s -> {
            if (name == null) {
                ApkPackage.$$$reportNull$$$0(11);
            }
            return new ApkClass(name, this);
        });
        if (apkClass == null) {
            ApkPackage.$$$reportNull$$$0(8);
        }
        return apkClass;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            ApkPackage.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public String getFqn() {
        String string = this.myFqn;
        if (string == null) {
            ApkPackage.$$$reportNull$$$0(10);
        }
        return string;
    }

    public boolean doSubpackagesHaveClasses() {
        for (ApkPackage subpackage : this.getSubpackages()) {
            if (subpackage.getClasses().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApkPackage)) {
            return false;
        }
        ApkPackage that = (ApkPackage)o;
        return Objects.equals(this.myName, that.myName) && Objects.equals(this.myFqn, that.myFqn) && Objects.equals(this.myParent, that.myParent);
    }

    public int hashCode() {
        return Objects.hash(this.myName, this.myFqn, this.myParent);
    }

    public String toString() {
        return this.getFqn();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/debugging/ApkPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/debugging/ApkPackage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubpackages";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "addSubpackage";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "addClass";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findSubpackage";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addSubpackage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addClass";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addClass$1";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addSubpackage$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

