/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.mxunit;

import com.intellij.coldFusion.UI.editorActions.CfmlScriptNodeSuppressor;
import com.intellij.coldFusion.mxunit.CfmlUnitRunConfiguration;
import com.intellij.coldFusion.mxunit.CfmlUnitRunnerParameters;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ResourceUtil;
import com.intellij.util.io.HttpRequests;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class CfmlUnitRemoteTestsRunner {
    private static final Logger LOG = Logger.getInstance((String)CfmlUnitRemoteTestsRunner.class.getName());

    public static String getLauncherText(String resourcePath) {
        try {
            return ResourceUtil.loadText((URL)CfmlUnitRunConfiguration.class.getResource(resourcePath)).replaceFirst("\\Q/*system_delimiter*/\\E", String.valueOf(File.separatorChar).replace("\\", "\\\\\\\\"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void deleteFile(final VirtualFile file) throws ExecutionException {
        final Ref error = new Ref();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (file.isValid()) {
                                file.delete((Object)this);
                            }
                        }
                        catch (IOException e) {
                            error.set((Object)e);
                        }
                    }
                });
            }
        };
        ApplicationManager.getApplication().invokeAndWait(runnable);
        if (!error.isNull()) {
            throw new ExecutionException(((IOException)error.get()).getMessage());
        }
    }

    public static void createFile(VirtualFile directory, String fileName, String fileText) throws ExecutionException {
        LOG.assertTrue(directory != null);
        Ref error = new Ref();
        Ref launcherFile = new Ref();
        Runnable runnable = () -> ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                VirtualFile file = directory.findChild(fileName);
                if (file == null) {
                    file = directory.createChildData(CfmlUnitRunConfiguration.class, fileName);
                }
                CfmlScriptNodeSuppressor.suppress(file);
                VfsUtil.saveText((VirtualFile)file, (String)fileText);
                launcherFile.set((Object)file);
            }
            catch (IOException e) {
                error.set((Object)e);
            }
        });
        ApplicationManager.getApplication().invokeAndWait(runnable);
        if (!error.isNull()) {
            throw new ExecutionException(((IOException)error.get()).getMessage());
        }
    }

    public static void executeScript(CfmlUnitRunnerParameters params, ProcessHandler processHandler) throws ExecutionException {
        Ref ref = new Ref();
        ApplicationManager.getApplication().assertIsDispatchThread();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                String agentUrl;
                VirtualFile componentFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(params.getPath());
                if (componentFile == null) {
                    throw new ExecutionException("File " + params.getPath() + " not found");
                }
                VirtualFile directory = componentFile.getParent();
                String launcherFileName = "mxunit-launcher.cfc";
                LOG.debug("Copying script filemxunit-launcher.cfc to component folder: " + directory);
                CfmlUnitRemoteTestsRunner.createFile(directory, "mxunit-launcher.cfc", CfmlUnitRemoteTestsRunner.getLauncherText("/scripts/mxunit-launcher.cfc"));
                String resultsFileName = "mxunit-result-capture.cfc";
                LOG.debug("Copying results capture file mxunit-result-capture.cfc to component folder: " + directory);
                CfmlUnitRemoteTestsRunner.createFile(directory, "mxunit-result-capture.cfc", CfmlUnitRemoteTestsRunner.getLauncherText("/scripts/mxunit-result-capture.cfc"));
                String webPath = params.getWebPath();
                if (webPath.endsWith("/") || webPath.endsWith("\\")) {
                    webPath = webPath.substring(0, webPath.length() - 1);
                }
                String agentPath = webPath.substring(0, webPath.lastIndexOf(47)) + "/" + "mxunit-launcher.cfc";
                LOG.debug("Retrieving data from coldfusion server by " + agentPath + " URL");
                if (params.getScope() == CfmlUnitRunnerParameters.Scope.Directory) {
                    agentUrl = agentPath + "?method=executeDirectory&directoryName=" + componentFile.getName();
                } else {
                    agentUrl = agentPath + "?method=executeTestCase&componentName=" + componentFile.getNameWithoutExtension();
                    if (params.getScope() == CfmlUnitRunnerParameters.Scope.Method) {
                        agentUrl = agentUrl + "&methodName=" + params.getMethod();
                    }
                }
                try {
                    LOG.debug("Retrieving test results from: " + agentUrl);
                    HttpRequests.request((String)agentUrl).connect(request -> {
                        String line;
                        BufferedReader reader = request.getReader();
                        while (!processHandler.isProcessTerminating() && !processHandler.isProcessTerminated() && (line = reader.readLine()) != null) {
                            if (StringUtil.isEmptyOrSpaces((String)line)) continue;
                            LOG.debug("MXUnit: " + line);
                            processHandler.notifyTextAvailable(line + "\n", ProcessOutputTypes.SYSTEM);
                        }
                        return null;
                    });
                }
                catch (HttpRequests.HttpStatusException e) {
                    LOG.debug("Http request failed: " + e.getMessage());
                    processHandler.notifyTextAvailable("Http request failed: " + e.getMessage(), ProcessOutputTypes.SYSTEM);
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                    processHandler.notifyTextAvailable("Failed to retrieve test results from the server at " + agentUrl + "\n", ProcessOutputTypes.SYSTEM);
                }
                LOG.debug("Cleaning temporary files");
                CfmlUnitRemoteTestsRunner.deleteFile(directory.findChild("mxunit-launcher.cfc"));
                CfmlUnitRemoteTestsRunner.deleteFile(directory.findChild("mxunit-result-capture.cfc"));
                if (!processHandler.isProcessTerminated() && !processHandler.isProcessTerminating()) {
                    processHandler.destroyProcess();
                }
            }
            catch (ExecutionException e) {
                ref.set((Object)e);
            }
        });
        if (!ref.isNull()) {
            throw (ExecutionException)((Object)ref.get());
        }
    }
}

