/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.psi;

import com.intellij.coldFusion.model.CfmlLanguage;
import com.intellij.coldFusion.model.files.CfmlFileViewProvider;
import com.intellij.coldFusion.model.lexer.CfmlTokenTypes;
import com.intellij.coldFusion.model.psi.CfmlTag;
import com.intellij.coldFusion.model.psi.CfmlTagUtil;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\u0010J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0006\u00a8\u0006\u0017"}, d2={"Lcom/intellij/coldFusion/model/psi/CfmlTagUtil;", "", "()V", "getEndTagNameElement", "Lcom/intellij/psi/impl/source/tree/LeafPsiElement;", "tag", "Lcom/intellij/coldFusion/model/psi/CfmlTag;", "getStartTagNameElement", "getTextByOffset", "", "provider", "Lcom/intellij/coldFusion/model/files/CfmlFileViewProvider;", "offset", "", "getUnclosedParentTag", "cfmlElement", "Lcom/intellij/psi/PsiElement;", "getUnclosedTagFromPrevSiblings", "psiElement", "isClosingTag", "", "isUnclosedTag", "cfmlTag", "intellij.cfml"})
public final class CfmlTagUtil {
    public static final CfmlTagUtil INSTANCE;

    @Nullable
    public final LeafPsiElement getStartTagNameElement(@NotNull CfmlTag tag) {
        LeafPsiElement leafPsiElement;
        IElementType elementType;
        ASTNode current;
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        ASTNode aSTNode = tag.getNode();
        if (aSTNode == null) {
            return null;
        }
        ASTNode node = aSTNode;
        ASTNode aSTNode2 = current = node.getFirstChildNode();
        Object object = elementType = aSTNode2 != null ? aSTNode2.getElementType() : null;
        while (current != null && elementType != CfmlTokenTypes.CF_TAG_NAME) {
            ASTNode aSTNode3 = current = current.getTreeNext();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode3, (String)"current");
            elementType = aSTNode3.getElementType();
        }
        if (current == null) {
            leafPsiElement = null;
        } else {
            PsiElement psiElement = current.getPsi();
            if (psiElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.impl.source.tree.LeafPsiElement");
            }
            leafPsiElement = (LeafPsiElement)psiElement;
        }
        return leafPsiElement;
    }

    @Nullable
    public final LeafPsiElement getEndTagNameElement(@NotNull CfmlTag tag) {
        ASTNode current;
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        ASTNode aSTNode = tag.getNode();
        if (aSTNode == null) {
            return null;
        }
        ASTNode node = aSTNode;
        ASTNode prev = current = node.getLastChildNode();
        while (current != null) {
            IElementType elementType;
            ASTNode aSTNode2 = prev;
            if (aSTNode2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode2.getElementType(), (String)"prev!!.elementType");
            if (elementType == CfmlTokenTypes.CF_TAG_NAME && current.getElementType() == CfmlTokenTypes.LSLASH_ANGLEBRACKET) {
                PsiElement psiElement = prev.getPsi();
                if (psiElement == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.impl.source.tree.LeafPsiElement");
                }
                return (LeafPsiElement)psiElement;
            }
            prev = current;
            current = current.getTreePrev();
        }
        return null;
    }

    public final boolean isClosingTag(@NotNull CfmlFileViewProvider provider, int offset) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)provider), (String)"provider");
        return Intrinsics.areEqual((Object)this.getTextByOffset(provider, offset), (Object)"/") && Intrinsics.areEqual((Object)this.getTextByOffset(provider, offset - 1), (Object)"<");
    }

    @Nullable
    public final CfmlTag getUnclosedTagFromPrevSiblings(@NotNull PsiElement psiElement) {
        Intrinsics.checkParameterIsNotNull((Object)psiElement, (String)"psiElement");
        getUnclosedTagFromPrevSiblings.1 getPreviousCfmlTagSibling$ = getUnclosedTagFromPrevSiblings.1.INSTANCE;
        PsiElement currentCfmlPsiElement = psiElement;
        while (currentCfmlPsiElement != null) {
            if (!((currentCfmlPsiElement = getPreviousCfmlTagSibling$.invoke(currentCfmlPsiElement)) instanceof CfmlTag) || !this.isUnclosedTag((CfmlTag)currentCfmlPsiElement)) continue;
            return (CfmlTag)currentCfmlPsiElement;
        }
        return null;
    }

    @Nullable
    public final CfmlTag getUnclosedParentTag(@NotNull PsiElement cfmlElement) {
        Intrinsics.checkParameterIsNotNull((Object)cfmlElement, (String)"cfmlElement");
        CfmlTag cfmlParentTag = (CfmlTag)PsiTreeUtil.getParentOfType((PsiElement)cfmlElement, CfmlTag.class);
        return cfmlParentTag != null && INSTANCE.isUnclosedTag(cfmlParentTag) ? cfmlParentTag : null;
    }

    public final boolean isUnclosedTag(@NotNull CfmlTag cfmlTag) {
        Intrinsics.checkParameterIsNotNull((Object)cfmlTag, (String)"cfmlTag");
        return this.getEndTagNameElement(cfmlTag) == null;
    }

    private final String getTextByOffset(CfmlFileViewProvider provider, int offset) {
        PsiElement psiElement = provider.findElementAt(offset - 1, CfmlLanguage.class);
        return psiElement != null ? psiElement.getText() : null;
    }

    private CfmlTagUtil() {
    }

    static {
        CfmlTagUtil cfmlTagUtil;
        INSTANCE = cfmlTagUtil = new CfmlTagUtil();
    }
}

